/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session.metadata.coarse;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.wildfly.clustering.ee.cache.offset.OffsetValue;
import org.wildfly.clustering.web.cache.session.metadata.coarse.ContextualSessionMetaDataEntry;
import org.wildfly.clustering.web.cache.session.metadata.coarse.SessionMetaDataEntryOffsets;
import org.wildfly.common.function.Functions;

public class DefaultSessionMetaDataEntry<C>
implements ContextualSessionMetaDataEntry<C> {
    private volatile Duration timeout = Duration.ZERO;
    private final OffsetValue<Instant> lastAccessStartTime;
    private final OffsetValue<Instant> lastAccessEndTime;
    private final AtomicReference<C> context = new AtomicReference();

    public DefaultSessionMetaDataEntry() {
        this(Instant.now().truncatedTo(ChronoUnit.MILLIS));
    }

    public DefaultSessionMetaDataEntry(Instant creationTime) {
        this.lastAccessStartTime = OffsetValue.from((Instant)creationTime);
        this.lastAccessEndTime = this.lastAccessStartTime.rebase();
    }

    @Override
    public boolean isNew() {
        return this.getLastAccessEndTime().getOffset().isZero();
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }

    @Override
    public OffsetValue<Instant> getLastAccessStartTime() {
        return this.lastAccessStartTime;
    }

    @Override
    public OffsetValue<Instant> getLastAccessEndTime() {
        return this.lastAccessEndTime;
    }

    @Override
    public C getContext(Supplier<C> factory) {
        return this.context.updateAndGet(context -> Optional.ofNullable(context).orElseGet(factory));
    }

    public ContextualSessionMetaDataEntry<C> remap(SessionMetaDataEntryOffsets delta) {
        DefaultSessionMetaDataEntry<C> result = new DefaultSessionMetaDataEntry<C>(this.getCreationTime());
        result.setTimeout((Duration)delta.getTimeoutOffset().apply((Object)this.timeout));
        result.getLastAccessStartTime().set((Object)((Instant)delta.getLastAccessStartTimeOffset().apply((Object)((Instant)this.lastAccessStartTime.get()))));
        result.getLastAccessEndTime().set((Object)((Instant)delta.getLastAccessEndTimeOffset().apply((Object)((Instant)this.lastAccessEndTime.get()))));
        result.getContext(Functions.constantSupplier(this.context.get()));
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName()).append(" { ");
        builder.append("created = ").append(this.lastAccessStartTime.getBasis());
        builder.append(", timeout = ").append(this.timeout);
        builder.append(", last-access-start = ").append(this.lastAccessStartTime.get());
        builder.append(", last-access-end = ").append(this.lastAccessEndTime.get());
        return builder.append(" }").toString();
    }
}

