/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.common.configuration;

import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.configuration.serializing.AbstractStoreSerializer;
import org.infinispan.persistence.jdbc.common.configuration.AbstractJdbcStoreConfiguration;
import org.infinispan.persistence.jdbc.common.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.common.configuration.Element;
import org.infinispan.persistence.jdbc.common.configuration.ManagedConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.common.configuration.PooledConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.common.configuration.SimpleConnectionFactoryConfiguration;

public abstract class AbstractJdbcStoreConfigurationSerializer
extends AbstractStoreSerializer {
    protected void writeJdbcStoreAttributes(ConfigurationWriter writer, AbstractJdbcStoreConfiguration configuration) {
        configuration.attributes().write(writer);
    }

    private void writeJDBCStoreConnection(ConfigurationWriter writer, SimpleConnectionFactoryConfiguration configuration) {
        writer.writeStartElement((Enum)Element.SIMPLE_CONNECTION);
        configuration.attributes().write(writer);
        writer.writeEndElement();
    }

    private void writeJDBCStoreConnection(ConfigurationWriter writer, PooledConnectionFactoryConfiguration configuration) {
        writer.writeStartElement((Enum)Element.CONNECTION_POOL);
        configuration.attributes().write(writer);
        writer.writeEndElement();
    }

    private void writeJDBCStoreConnection(ConfigurationWriter writer, ManagedConnectionFactoryConfiguration configuration) {
        writer.writeStartElement((Enum)Element.DATA_SOURCE);
        configuration.attributes().write(writer);
        writer.writeEndElement();
    }

    protected void writeJDBCStoreConnection(ConfigurationWriter writer, AbstractJdbcStoreConfiguration configuration) {
        ConnectionFactoryConfiguration cfc = configuration.connectionFactory();
        if (cfc instanceof SimpleConnectionFactoryConfiguration) {
            this.writeJDBCStoreConnection(writer, (SimpleConnectionFactoryConfiguration)cfc);
        } else if (cfc instanceof PooledConnectionFactoryConfiguration) {
            this.writeJDBCStoreConnection(writer, (PooledConnectionFactoryConfiguration)cfc);
        } else if (cfc instanceof ManagedConnectionFactoryConfiguration) {
            this.writeJDBCStoreConnection(writer, (ManagedConnectionFactoryConfiguration)cfc);
        }
    }
}

