/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web;

import java.io.Externalizable;
import java.io.Serializable;
import java.util.function.Function;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.wildfly.clustering.marshalling.jboss.DynamicClassTable;
import org.wildfly.clustering.marshalling.jboss.DynamicExternalizerObjectTable;
import org.wildfly.clustering.marshalling.jboss.SimpleClassTable;

public enum JBossMarshallingVersion implements Function<Module, MarshallingConfiguration>
{
    VERSION_1{

        @Override
        public MarshallingConfiguration apply(Module module) {
            MarshallingConfiguration config = new MarshallingConfiguration();
            config.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)module.getModuleLoader()));
            config.setClassTable((ClassTable)new SimpleClassTable(new Class[]{Serializable.class, Externalizable.class}));
            return config;
        }
    }
    ,
    VERSION_2{

        @Override
        public MarshallingConfiguration apply(Module module) {
            MarshallingConfiguration config = new MarshallingConfiguration();
            config.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)module.getModuleLoader()));
            config.setClassTable((ClassTable)new SimpleClassTable(new Class[]{Serializable.class, Externalizable.class}));
            config.setObjectTable((ObjectTable)new DynamicExternalizerObjectTable((ClassLoader)module.getClassLoader()));
            return config;
        }
    }
    ,
    VERSION_3{

        @Override
        public MarshallingConfiguration apply(Module module) {
            MarshallingConfiguration config = new MarshallingConfiguration();
            config.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)module.getModuleLoader()));
            config.setClassTable((ClassTable)new DynamicClassTable((ClassLoader)module.getClassLoader()));
            config.setObjectTable((ObjectTable)new DynamicExternalizerObjectTable((ClassLoader)module.getClassLoader()));
            return config;
        }
    };

    static final JBossMarshallingVersion CURRENT;

    static {
        CURRENT = VERSION_3;
    }
}

