/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch.impl;

import org.infinispan.configuration.cache.HashConfiguration;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.ch.impl.KeyPartitionerDelegate;
import org.infinispan.distribution.group.impl.GroupManager;
import org.infinispan.distribution.group.impl.GroupingPartitioner;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.annotations.Inject;

@DefaultFactoryFor(classes={KeyPartitioner.class})
public class KeyPartitionerFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    @Inject
    GroupManager groupManager;

    private KeyPartitioner getConfiguredPartitioner() {
        HashConfiguration hashConfiguration = this.configuration.clustering().hash();
        KeyPartitioner partitioner = hashConfiguration.keyPartitioner();
        partitioner.init(hashConfiguration);
        return partitioner;
    }

    @Override
    public Object construct(String componentName) {
        KeyPartitioner partitioner = this.getConfiguredPartitioner();
        if (this.groupManager == null) {
            return new KeyPartitionerDelegate(partitioner, this.configuration);
        }
        this.basicComponentRegistry.wireDependencies(partitioner, false);
        return new KeyPartitionerDelegate(new GroupingPartitioner(partitioner, this.groupManager), this.configuration);
    }
}

