/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered;

import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.IntSet;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;

final class QueryPartitioner {
    private final AdvancedCache<?, ?> cache;
    private final int numSegments;

    public QueryPartitioner(AdvancedCache<?, ?> cache) {
        this.cache = cache;
        ClusteringConfiguration clustering = cache.getCacheConfiguration().clustering();
        this.numSegments = clustering.hash().numSegments();
    }

    public Map<Address, BitSet> split() {
        RpcManager rpcManager = this.cache.getRpcManager();
        List members = rpcManager.getMembers();
        Address localAddress = rpcManager.getAddress();
        LocalizedCacheTopology cacheTopology = this.cache.getDistributionManager().getCacheTopology();
        BitSet bitSet = new BitSet();
        LinkedHashMap<Address, BitSet> segmentsPerMember = new LinkedHashMap<Address, BitSet>(members.size());
        IntSet localSegments = cacheTopology.getLocalReadSegments();
        localSegments.forEach(bitSet::set);
        segmentsPerMember.put(localAddress, bitSet);
        for (int s = 0; s < this.numSegments; ++s) {
            if (bitSet.get(s)) continue;
            Address primary = cacheTopology.getSegmentDistribution(s).primary();
            segmentsPerMember.computeIfAbsent(primary, address -> new BitSet()).set(s);
        }
        return segmentsPerMember;
    }
}

