/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms.bridge;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq._private.MessagingLogger;
import org.wildfly.extension.messaging.activemq.jms.bridge.JMSBridgeService;

class JMSBridgeRemove
extends AbstractRemoveStepHandler {
    static final JMSBridgeRemove INSTANCE = new JMSBridgeRemove();

    private JMSBridgeRemove() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
        context.removeService(MessagingServices.getJMSBridgeServiceName(context.getCurrentAddressValue()));
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ServiceName jmsBridgeServiceName;
        String bridgeName = context.getCurrentAddressValue();
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController jmsBridgeServiceController = registry.getService(jmsBridgeServiceName = MessagingServices.getJMSBridgeServiceName(bridgeName));
        if (jmsBridgeServiceController != null && jmsBridgeServiceController.getState() == ServiceController.State.UP) {
            JMSBridgeService jmsBridgeService = (JMSBridgeService)jmsBridgeServiceController.getService();
            try {
                jmsBridgeService.startBridge();
            }
            catch (Exception e) {
                throw MessagingLogger.ROOT_LOGGER.failedToRecover(e, bridgeName);
            }
        }
    }
}

