/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.ejb;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityServiceNameProvider;
import org.jboss.as.clustering.controller.ResourceServiceConfigurator;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.ejb.bean.BeanDeploymentMarshallingContext;
import org.wildfly.clustering.ejb.bean.BeanManagementConfiguration;
import org.wildfly.clustering.ejb.bean.BeanManagementProvider;
import org.wildfly.clustering.ejb.cache.bean.BeanMarshallerFactory;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.extension.clustering.ejb.BeanManagementResourceDefinition;

public abstract class BeanManagementServiceConfigurator
extends CapabilityServiceNameProvider
implements ResourceServiceConfigurator,
Supplier<BeanManagementProvider>,
Function<String, BeanManagementProvider>,
BeanManagementConfiguration {
    private final String name;
    private volatile Integer maxActiveBeans;

    public BeanManagementServiceConfigurator(PathAddress address) {
        super((Capability)BeanManagementResourceDefinition.Capability.BEAN_MANAGEMENT_PROVIDER, address);
        this.name = address.getLastElement().getValue();
    }

    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.maxActiveBeans = BeanManagementResourceDefinition.Attribute.MAX_ACTIVE_BEANS.resolveModelAttribute((ExpressionResolver)context, model).asIntOrNull();
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceName name = this.getServiceName();
        ServiceBuilder builder = target.addService(name);
        Consumer provider = builder.provides(new ServiceName[]{name});
        FunctionalService service = new FunctionalService(provider, Function.identity(), (Supplier)this);
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    public BeanManagementProvider get() {
        return (BeanManagementProvider)this.apply(this.name);
    }

    public Integer getMaxActiveBeans() {
        return this.maxActiveBeans;
    }

    public Function<BeanDeploymentMarshallingContext, ByteBufferMarshaller> getMarshallerFactory() {
        return BeanMarshallerFactory.JBOSS;
    }
}

