/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.hotrod;

import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.configuration.RemoteCacheConfiguration;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.cache.CacheConfiguration;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.ee.hotrod.RemoteCacheProperties;
import org.wildfly.clustering.ee.hotrod.tx.HotRodBatcher;

public interface HotRodConfiguration
extends CacheConfiguration {
    public <CK, CV> RemoteCache<CK, CV> getCache();

    default public Flag[] getIgnoreReturnFlags() {
        Flag[] flagArray;
        if (this.getNearCacheMode().enabled()) {
            flagArray = new Flag[]{};
        } else {
            Flag[] flagArray2 = new Flag[1];
            flagArray = flagArray2;
            flagArray2[0] = Flag.SKIP_LISTENER_NOTIFICATION;
        }
        return flagArray;
    }

    default public Flag[] getForceReturnFlags() {
        Flag[] flagArray;
        if (this.getNearCacheMode().enabled()) {
            Flag[] flagArray2 = new Flag[1];
            flagArray = flagArray2;
            flagArray2[0] = Flag.FORCE_RETURN_VALUE;
        } else {
            Flag[] flagArray3 = new Flag[2];
            flagArray3[0] = Flag.FORCE_RETURN_VALUE;
            flagArray = flagArray3;
            flagArray3[1] = Flag.SKIP_LISTENER_NOTIFICATION;
        }
        return flagArray;
    }

    default public NearCacheMode getNearCacheMode() {
        RemoteCache cache = this.getCache();
        return ((RemoteCacheConfiguration)cache.getRemoteCacheContainer().getConfiguration().remoteCaches().get(cache.getName())).nearCacheMode();
    }

    default public CacheProperties getCacheProperties() {
        return new RemoteCacheProperties(this.getCache());
    }

    default public Batcher<TransactionBatch> getBatcher() {
        return new HotRodBatcher(this.getCache());
    }
}

