/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.outboxpolling.event.impl;

import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.search.mapper.orm.outboxpolling.cfg.OutboxEventProcessingOrder;
import org.hibernate.search.mapper.orm.outboxpolling.cfg.UuidGenerationStrategy;
import org.hibernate.search.util.common.AssertionFailure;

public enum OutboxEventOrder {
    NONE{

        @Override
        String queryPart(String eventAlias) {
            return "";
        }
    }
    ,
    TIME{

        @Override
        String queryPart(String eventAlias) {
            return " order by " + eventAlias + ".processAfter";
        }
    }
    ,
    ID{

        @Override
        String queryPart(String eventAlias) {
            return " order by " + eventAlias + ".id";
        }
    };


    abstract String queryPart(String var1);

    public static OutboxEventOrder of(OutboxEventProcessingOrder order, UuidGenerationStrategy uuidGenerationStrategy, Dialect dialect) {
        switch (order) {
            case NONE: {
                return NONE;
            }
            case TIME: {
                return TIME;
            }
            case ID: {
                return ID;
            }
            case AUTO: {
                if (UuidGenerationStrategy.TIME.equals((Object)uuidGenerationStrategy)) {
                    return ID;
                }
                if (dialect instanceof SQLServerDialect) {
                    return NONE;
                }
                return TIME;
            }
        }
        throw new AssertionFailure("Unknown order: " + order);
    }
}

