/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.outboxpolling.event.impl;

import java.util.Optional;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.ShardAssignmentDescriptor;
import org.hibernate.search.mapper.orm.outboxpolling.event.impl.EntityIdHashRangeOutboxEventPredicate;
import org.hibernate.search.mapper.orm.outboxpolling.event.impl.OutboxEventFinder;
import org.hibernate.search.mapper.orm.outboxpolling.event.impl.OutboxEventFinderProvider;
import org.hibernate.search.mapper.orm.outboxpolling.event.impl.OutboxEventPredicate;
import org.hibernate.search.util.common.data.Range;
import org.hibernate.search.util.common.data.impl.Murmur3HashFunction;
import org.hibernate.search.util.common.data.impl.RangeCompatibleHashFunction;
import org.hibernate.search.util.common.data.impl.RangeHashTable;
import org.hibernate.search.util.common.spi.ToStringTreeAppendable;
import org.hibernate.search.util.common.spi.ToStringTreeAppender;

final class ShardAssignment {
    public static final RangeCompatibleHashFunction HASH_FUNCTION = Murmur3HashFunction.INSTANCE;
    final ShardAssignmentDescriptor descriptor;
    final OutboxEventFinder eventFinder;

    ShardAssignment(ShardAssignmentDescriptor descriptor, OutboxEventFinder eventFinder) {
        this.descriptor = descriptor;
        this.eventFinder = eventFinder;
    }

    public String toString() {
        return this.descriptor.toString();
    }

    public static class Provider
    implements ToStringTreeAppendable {
        private final OutboxEventFinderProvider finderProvider;

        public Provider(OutboxEventFinderProvider finderProvider) {
            this.finderProvider = finderProvider;
        }

        public String toString() {
            return this.toStringTree();
        }

        public void appendTo(ToStringTreeAppender appender) {
            appender.attribute("finderProvider", (Object)this.finderProvider);
        }

        ShardAssignment create(ShardAssignmentDescriptor descriptor) {
            Optional<OutboxEventPredicate> predicate;
            if (descriptor.totalShardCount == 1) {
                predicate = Optional.empty();
            } else {
                RangeHashTable hashTable = new RangeHashTable(HASH_FUNCTION, descriptor.totalShardCount);
                Range entityIdHashRange = hashTable.rangeForBucket(descriptor.assignedShardIndex);
                predicate = Optional.of(new EntityIdHashRangeOutboxEventPredicate((Range<Integer>)entityIdHashRange));
            }
            return new ShardAssignment(descriptor, this.finderProvider.create(predicate));
        }
    }
}

