/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer;

import aQute.lib.io.IO;
import aQute.lib.utf8properties.UTF8Properties;
import aQute.libg.uri.URIUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.eclipse.transformer.TransformException;
import org.eclipse.transformer.TransformProperties;
import org.eclipse.transformer.TransformerLoggerFactory;
import org.eclipse.transformer.action.ActionType;
import org.eclipse.transformer.action.BundleData;
import org.eclipse.transformer.action.Changes;
import org.eclipse.transformer.action.impl.ActionImpl;
import org.eclipse.transformer.action.impl.BundleDataImpl;
import org.eclipse.transformer.action.impl.ClassActionImpl;
import org.eclipse.transformer.action.impl.CompositeActionImpl;
import org.eclipse.transformer.action.impl.DirectoryActionImpl;
import org.eclipse.transformer.action.impl.EarActionImpl;
import org.eclipse.transformer.action.impl.InputBufferImpl;
import org.eclipse.transformer.action.impl.JarActionImpl;
import org.eclipse.transformer.action.impl.JavaActionImpl;
import org.eclipse.transformer.action.impl.ManifestActionImpl;
import org.eclipse.transformer.action.impl.NullActionImpl;
import org.eclipse.transformer.action.impl.PropertiesActionImpl;
import org.eclipse.transformer.action.impl.RarActionImpl;
import org.eclipse.transformer.action.impl.SelectionRuleImpl;
import org.eclipse.transformer.action.impl.ServiceLoaderConfigActionImpl;
import org.eclipse.transformer.action.impl.SignatureRuleImpl;
import org.eclipse.transformer.action.impl.TextActionImpl;
import org.eclipse.transformer.action.impl.WarActionImpl;
import org.eclipse.transformer.action.impl.ZipActionImpl;
import org.eclipse.transformer.util.FileUtils;
import org.slf4j.Logger;

public class Transformer {
    public static final int SUCCESS_RC = 0;
    public static final int PARSE_ERROR_RC = 1;
    public static final int RULES_ERROR_RC = 2;
    public static final int TRANSFORM_ERROR_RC = 3;
    public static final int FILE_TYPE_ERROR_RC = 4;
    public static final int LOGGER_SETTINGS_ERROR_RC = 5;
    public static String[] RC_DESCRIPTIONS = new String[]{"Success", "Parse Error", "Rules Error", "Transform Error", "File Type Error", "Logger Settings Error"};
    public static final String INPUT_GROUP = "input";
    public static final String LOGGING_GROUP = "logging";
    public static final String HELP_SHORT_TAG = "-h";
    public static final String HELP_LONG_TAG = "--help";
    public static final String USAGE_SHORT_TAG = "-u";
    public static final String USAGE_LONG_TAG = "--usage";
    private static final String[] COPYRIGHT_LINES = new String[]{"Copyright (c) 2020 Contributors to the Eclipse Foundation", "This program and the accompanying materials are made available under the", "terms of the Eclipse Public License 2.0 which is available at", "http://www.eclipse.org/legal/epl-2.0, or the Apache License, Version 2.0", "which is available at https://www.apache.org/licenses/LICENSE-2.0.", "SPDX-License-Identifier: (EPL-2.0 OR Apache-2.0)", ""};
    private static final String SHORT_VERSION_PROPERTY_NAME = "version";
    private static final String TRANSFORMER_BUILD_PROPERTIES = "META-INF/maven/org.eclipse.transformer/org.eclipse.transformer/pom.properties";
    private final Properties buildProperties;
    private final PrintStream sysOut;
    private final PrintStream sysErr;
    private final Options appOptions;
    private Class<?> ruleLoader;
    private Map<AppOption, String> ruleDefaultRefs;
    private String[] args;
    private CommandLine parsedArgs;
    private Changes lastActiveChanges;
    protected static boolean DO_NORMALIZE = true;
    public static final AppOption[] TARGETABLE_RULES = new AppOption[]{AppOption.RULES_SELECTIONS, AppOption.RULES_RENAMES, AppOption.RULES_VERSIONS, AppOption.RULES_DIRECT, AppOption.RULES_PER_CLASS_CONSTANT, AppOption.RULES_BUNDLES, AppOption.RULES_MASTER_TEXT};
    private Logger logger;
    public boolean toSysOut;
    public boolean toSysErr;

    public static void main(String[] args) throws Exception {
        int rc = Transformer.runWith(System.out, System.err, args);
    }

    public static int runWith(PrintStream sysOut, PrintStream sysErr, String ... args) {
        Transformer trans = new Transformer(sysOut, sysErr);
        trans.setArgs(args);
        int rc = trans.run();
        if (rc == 0) {
            System.out.println("Return Code [ 0 ]: Success");
        } else {
            System.err.println("Return Code [ " + rc + " ]: Failure [ " + RC_DESCRIPTIONS[rc] + " ]");
        }
        return rc;
    }

    public static InputStream getResourceStream(String resourceRef) {
        return Transformer.class.getClassLoader().getResourceAsStream(resourceRef);
    }

    public static Properties loadProperties(String resourceRef) throws IOException {
        Properties properties = new Properties();
        try (InputStream inputStream = Transformer.getResourceStream(resourceRef);){
            properties.load(inputStream);
        }
        return properties;
    }

    public Transformer(PrintStream sysOut, PrintStream sysErr) {
        Properties useProperties;
        this.sysOut = sysOut;
        this.sysErr = sysErr;
        try {
            useProperties = Transformer.loadProperties(TRANSFORMER_BUILD_PROPERTIES);
        }
        catch (IOException e) {
            useProperties = new Properties();
            this.error("Failed to load properties [ META-INF/maven/org.eclipse.transformer/org.eclipse.transformer/pom.properties ]", e, new Object[0]);
        }
        this.buildProperties = useProperties;
        this.appOptions = AppOption.build();
    }

    private final Properties getBuildProperties() {
        return this.buildProperties;
    }

    private void preInitDisplay(String message) {
        PrintStream useSysOut = this.getSystemOut();
        useSysOut.println(message);
    }

    private void displayCopyright() {
        for (String copyrightLine : COPYRIGHT_LINES) {
            this.preInitDisplay(copyrightLine);
        }
    }

    private void displayBuildProperties() {
        Properties useBuildProperties = this.getBuildProperties();
        this.preInitDisplay(this.getClass().getName());
        this.preInitDisplay("  Version [ " + useBuildProperties.getProperty(SHORT_VERSION_PROPERTY_NAME) + " ]");
        this.preInitDisplay("");
    }

    protected PrintStream getSystemOut() {
        return this.sysOut;
    }

    protected PrintStream getSystemErr() {
        return this.sysErr;
    }

    public void systemPrint(PrintStream output, String message, Object ... parms) {
        if (parms.length != 0) {
            message = String.format(message, parms);
        }
        output.println(message);
    }

    public void errorPrint(String message, Object ... parms) {
        this.systemPrint(this.getSystemErr(), message, parms);
    }

    public void outputPrint(String message, Object ... parms) {
        this.systemPrint(this.getSystemOut(), message, parms);
    }

    public Options getAppOptions() {
        return this.appOptions;
    }

    public Changes getLastActiveChanges() {
        return this.lastActiveChanges;
    }

    public void setOptionDefaults(Class<?> optionLoader, Map<AppOption, String> optionDefaults) {
        this.ruleLoader = optionLoader;
        this.ruleDefaultRefs = new HashMap<AppOption, String>(optionDefaults);
    }

    public Class<?> getRuleLoader() {
        return this.ruleLoader;
    }

    public Map<AppOption, String> getRuleDefaultRefs() {
        return this.ruleDefaultRefs;
    }

    public String getDefaultReference(AppOption appOption) {
        Map<AppOption, String> useDefaultRefs = this.getRuleDefaultRefs();
        return useDefaultRefs == null ? null : this.getRuleDefaultRefs().get((Object)appOption);
    }

    public void setArgs(String[] args) {
        this.args = args;
    }

    protected String[] getArgs() {
        return this.args;
    }

    public void setParsedArgs() throws ParseException {
        DefaultParser parser = new DefaultParser();
        this.parsedArgs = parser.parse(this.getAppOptions(), this.getArgs());
    }

    protected CommandLine getParsedArgs() {
        return this.parsedArgs;
    }

    protected String getInputFileNameFromCommandLine() {
        String[] useArgs = this.parsedArgs.getArgs();
        if (useArgs != null && useArgs.length > 0) {
            return useArgs[0];
        }
        return null;
    }

    protected String getOutputFileNameFromCommandLine() {
        String[] useArgs = this.parsedArgs.getArgs();
        if (useArgs != null && useArgs.length > 1) {
            return useArgs[1];
        }
        return null;
    }

    protected boolean hasOption(AppOption option) {
        return this.getParsedArgs().hasOption(option.getShortTag());
    }

    protected String getOptionValue(AppOption option) {
        return this.getOptionValue(option, !DO_NORMALIZE);
    }

    protected String getOptionValue(AppOption option, boolean normalize) {
        String useShortTag;
        CommandLine useParsedArgs = this.getParsedArgs();
        if (useParsedArgs.hasOption(useShortTag = option.getShortTag())) {
            String optionValue = useParsedArgs.getOptionValue(useShortTag);
            if (normalize) {
                optionValue = FileUtils.normalize(optionValue);
            }
            return optionValue;
        }
        return null;
    }

    protected String[] getOptionValues(AppOption option) {
        return this.getOptionValues(option, !DO_NORMALIZE);
    }

    protected String[] getOptionValues(AppOption option, boolean normalize) {
        String useShortTag;
        CommandLine useParsedArgs = this.getParsedArgs();
        if (useParsedArgs.hasOption(useShortTag = option.getShortTag())) {
            String[] optionValues = useParsedArgs.getOptionValues(useShortTag);
            if (normalize) {
                for (int optionNo = 0; optionNo < optionValues.length; ++optionNo) {
                    optionValues[optionNo] = FileUtils.normalize(optionValues[optionNo]);
                }
            }
            return optionValues;
        }
        return null;
    }

    private void usage(PrintStream helpStream) {
        helpStream.println("Usage: " + Transformer.class.getName() + " input [ output ] [ options ]");
        helpStream.println();
        helpStream.println("Use option [ -h ] or [ --help ] to display help information.");
        helpStream.flush();
    }

    private void help(PrintStream helpStream) {
        try (PrintWriter helpWriter = new PrintWriter(helpStream);){
            helpWriter.println();
            HelpFormatter helpFormatter = new HelpFormatter();
            boolean AUTO_USAGE = true;
            helpFormatter.printHelp(helpWriter, 79, Transformer.class.getName() + " input [ output ] [ options ]", "Options:", this.getAppOptions(), 1, 3, "", !AUTO_USAGE);
            helpWriter.println();
            helpWriter.println("Actions:");
            for (ActionType actionType : ActionType.values()) {
                helpWriter.println("  [ " + actionType.name() + " ]");
            }
            helpWriter.println();
            helpWriter.println("Logging Properties:");
            for (Enum enum_ : TransformerLoggerFactory.LoggerProperty.values()) {
                helpWriter.println("  [ " + ((TransformerLoggerFactory.LoggerProperty)enum_).getPropertyName() + " ]");
            }
            helpWriter.flush();
        }
    }

    protected UTF8Properties loadProperties(AppOption ruleOption, Set<String> orphanedValues) throws IOException, URISyntaxException {
        String[] rulesReferences = this.getOptionValues(ruleOption, DO_NORMALIZE);
        if (rulesReferences == null) {
            String rulesReference = this.getDefaultReference(ruleOption);
            if (rulesReference == null) {
                this.dual_info("Skipping option [ %s ]", new Object[]{ruleOption});
                return FileUtils.createProperties();
            }
            return this.loadInternalProperties(ruleOption, rulesReference);
        }
        if (rulesReferences.length == 1) {
            return this.loadExternalProperties(ruleOption, rulesReferences[0]);
        }
        UTF8Properties[] properties = new UTF8Properties[rulesReferences.length];
        for (int referenceNo = 0; referenceNo < rulesReferences.length; ++referenceNo) {
            properties[referenceNo] = this.loadExternalProperties(ruleOption, rulesReferences[referenceNo]);
        }
        String baseReference = rulesReferences[0];
        UTF8Properties mergedProperties = properties[0];
        for (int referenceNo = 1; referenceNo < rulesReferences.length; ++referenceNo) {
            this.merge(baseReference, mergedProperties, rulesReferences[referenceNo], properties[referenceNo], orphanedValues);
        }
        return mergedProperties;
    }

    private String relativize(String relativeRef, String baseRef) {
        Path basePath = Paths.get(baseRef, new String[0]);
        Path siblingPath = basePath.resolveSibling(relativeRef);
        return siblingPath.toString();
    }

    protected UTF8Properties loadInternalProperties(AppOption ruleOption, String resourceRef) throws IOException {
        return this.loadInternalProperties(ruleOption.toString(), resourceRef);
    }

    protected UTF8Properties loadInternalProperties(String ruleOption, String resourceRef) throws IOException {
        URL rulesUrl = this.getRuleLoader().getResource(resourceRef);
        if (rulesUrl == null) {
            this.dual_info("Internal [ %s ] were not found [ %s ]", ruleOption, resourceRef);
            throw new IOException("Resource [ " + resourceRef + " ] not found on [ " + this.getRuleLoader() + " ]");
        }
        this.dual_info("Internal [ %s ] URL [ %s ]", ruleOption, rulesUrl);
        return FileUtils.loadProperties(rulesUrl);
    }

    protected UTF8Properties loadExternalProperties(AppOption ruleOption, String resourceRef) throws URISyntaxException, IOException {
        return this.loadExternalProperties(ruleOption.toString(), resourceRef);
    }

    protected UTF8Properties loadExternalProperties(String referenceName, String externalReference) throws URISyntaxException, IOException {
        return this.loadExternalProperties(referenceName, externalReference, IO.work);
    }

    protected UTF8Properties loadExternalProperties(String referenceName, String externalReference, File relativeHome) throws URISyntaxException, IOException {
        URI relativeHomeUri = relativeHome.toURI();
        URL rulesUrl = URIUtil.resolve(relativeHomeUri, externalReference).toURL();
        this.dual_info("External [ %s ] URL [ %s ]", referenceName, rulesUrl);
        return FileUtils.loadProperties(rulesUrl);
    }

    protected void merge(String sinkName, UTF8Properties sink, String sourceName, UTF8Properties source, Set<String> orphanedValues) {
        for (Map.Entry<Object, Object> sourceEntry : source.entrySet()) {
            String key = (String)sourceEntry.getKey();
            String newValue = (String)sourceEntry.getValue();
            String oldValue = (String)sink.put(key, newValue);
            if (orphanedValues != null) {
                this.processOrphan(sourceName, sinkName, key, oldValue, newValue, orphanedValues);
            }
            this.logMerge(sourceName, sinkName, key, oldValue, newValue);
        }
    }

    protected void processOrphan(String sourceName, String sinkName, String key, String oldValue, String newValue, Set<String> orphans) {
        if (oldValue != null) {
            this.dual_debug("Merge of [ %s ] into [ %s ], key [ %s ] orphans [ %s ]", sourceName, sinkName, key, oldValue);
            orphans.add(oldValue);
        }
        if (orphans.remove(newValue)) {
            this.dual_debug("Merge of [ %s ] into [ %s ], key [ %s ] un-orphans [ %s ]", sourceName, sinkName, key, newValue);
        }
    }

    protected void logMerge(String sourceName, String sinkName, Object key, Object oldValue, Object newValue) {
        if (oldValue != null) {
            this.dual_debug("Merge of [ %s ] into [ %s ], key [ %s ] replaces value [ %s ] with [ %s ]", sourceName, sinkName, key, oldValue, newValue);
        }
    }

    protected ImmediateRuleData[] getImmediateData() {
        if (!this.hasOption(AppOption.RULES_IMMEDIATE_DATA)) {
            return new ImmediateRuleData[0];
        }
        String[] immediateArgs = this.getOptionValues(AppOption.RULES_IMMEDIATE_DATA);
        if (immediateArgs.length % 3 != 0) {
            this.dual_error("Incorrect number of arguments to option [ " + AppOption.RULES_IMMEDIATE_DATA.getShortTag() + " ]", new Object[0]);
            return null;
        }
        int argCount = immediateArgs.length / 3;
        ImmediateRuleData[] immediateData = new ImmediateRuleData[argCount];
        for (int argNo = 0; argNo < argCount; ++argNo) {
            int baseNo = argNo * 3;
            String targetText = immediateArgs[baseNo];
            String key = immediateArgs[baseNo + 1];
            String value = immediateArgs[baseNo + 2];
            this.dual_info("Immediate rule data specified; target [ %s ], key [ %s ], value [ %s ]", targetText, key, value);
            AppOption target = this.getTargetOption(targetText);
            if (target == null) {
                this.dual_error("Immediate rules target [ " + targetText + " ] is not valid.", new Object[0]);
                return null;
            }
            immediateData[argNo] = new ImmediateRuleData(target, key, value);
        }
        return immediateData;
    }

    public AppOption getTargetOption(String targetText) {
        for (AppOption appOption : TARGETABLE_RULES) {
            if (!targetText.contentEquals(appOption.getShortTag())) continue;
            return appOption;
        }
        return null;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void info(String message, Object ... parms) {
        this.getLogger().info(message, parms);
    }

    public boolean isDebugEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    public void debug(String message, Object ... parms) {
        this.getLogger().debug(message, parms);
    }

    protected void error(String message, Object ... parms) {
        this.getLogger().error(message, parms);
    }

    protected void error(String message, Throwable th, Object ... parms) {
        Logger useLogger = this.getLogger();
        if (useLogger.isErrorEnabled()) {
            message = String.format(message, parms);
            useLogger.error(message, th);
        }
    }

    protected void detectLogFile() {
        this.toSysOut = TransformerLoggerFactory.logToSysOut();
        if (this.toSysOut) {
            this.outputPrint("Logging is to System.out\n", new Object[0]);
        }
        this.toSysErr = TransformerLoggerFactory.logToSysErr();
        if (this.toSysOut) {
            this.outputPrint("Logging is to System.err\n", new Object[0]);
        }
        this.outputPrint("Log file [ " + System.getProperty(TransformerLoggerFactory.LoggerProperty.LOG_FILE.getPropertyName()) + " ]", new Object[0]);
    }

    public void dual_info(String message, Object ... parms) {
        if (parms.length != 0) {
            message = String.format(message, parms);
        }
        if (!this.toSysOut && !this.toSysErr) {
            this.systemPrint(this.getSystemOut(), message, new Object[0]);
        }
        this.info(message, new Object[0]);
    }

    public void dual_debug(String message, Object ... parms) {
        if (!this.isDebugEnabled()) {
            return;
        }
        if (parms.length != 0) {
            message = String.format(message, parms);
        }
        if (!this.toSysOut && !this.toSysErr) {
            this.systemPrint(this.getSystemOut(), message, new Object[0]);
        }
        this.debug(message, new Object[0]);
    }

    protected void dual_error(String message, Object ... parms) {
        if (parms.length != 0) {
            message = String.format(message, parms);
        }
        if (!this.toSysOut && !this.toSysErr) {
            this.systemPrint(this.getSystemErr(), message, new Object[0]);
        }
        this.info(message, new Object[0]);
    }

    protected void dual_error(String message, Throwable th) {
        if (!this.toSysOut && !this.toSysErr) {
            PrintStream useOutput = this.getSystemErr();
            this.systemPrint(useOutput, message, new Object[0]);
            th.printStackTrace(useOutput);
        }
        this.getLogger().error(message, th);
    }

    public TransformOptions createTransformOptions() {
        return new TransformOptions();
    }

    public int run() {
        boolean loadedRules;
        this.displayCopyright();
        this.displayBuildProperties();
        try {
            this.setParsedArgs();
        }
        catch (ParseException e) {
            this.errorPrint("Exception parsing command line arguments: %s", e);
            this.help(this.getSystemOut());
            return 1;
        }
        if (this.getArgs().length == 0 || this.hasOption(AppOption.USAGE)) {
            this.usage(this.getSystemOut());
            return 0;
        }
        if (this.hasOption(AppOption.HELP)) {
            this.help(this.getSystemOut());
            return 0;
        }
        TransformOptions options = this.createTransformOptions();
        try {
            options.setLogging();
        }
        catch (Exception e) {
            this.errorPrint("Logger settings error: %s", e);
            return 5;
        }
        this.detectLogFile();
        if (!options.setInput()) {
            return 3;
        }
        if (!options.setOutput()) {
            return 3;
        }
        try {
            loadedRules = options.setRules();
        }
        catch (Exception e) {
            this.dual_error("Exception loading rules:", e);
            return 2;
        }
        if (!loadedRules) {
            this.dual_error("Transformation rules cannot be used", new Object[0]);
            return 2;
        }
        if (options.isVerbose) {
            options.logRules();
        }
        if (!options.acceptAction()) {
            this.dual_error("No action selected", new Object[0]);
            return 4;
        }
        try {
            options.transform();
            this.lastActiveChanges = options.getLastActiveChanges();
        }
        catch (TransformException e) {
            this.dual_error("Transform failure:", e);
            return 3;
        }
        catch (Throwable th) {
            this.dual_error("Unexpected failure:", th);
            return 3;
        }
        return 0;
    }

    public class TransformOptions {
        public boolean isVerbose;
        public boolean isTerse;
        public Set<String> includes;
        public Set<String> excludes;
        public boolean invert;
        public Map<String, String> packageRenames;
        public Map<String, String> packageVersions;
        public Map<String, BundleData> bundleUpdates;
        public Map<String, String> masterSubstitutionRefs;
        public Map<String, Map<String, String>> masterTextUpdates;
        public Map<String, String> directStrings;
        public CompositeActionImpl rootAction;
        public ActionImpl acceptedAction;
        public String inputName;
        public String inputPath;
        public File inputFile;
        public boolean allowOverwrite;
        public String outputName;
        public String outputPath;
        public File outputFile;
        public Map<String, Map<String, String>> perClassConstantStrings;
        private InputBufferImpl buffer;
        private SelectionRuleImpl selectionRules;
        private SignatureRuleImpl signatureRules;
        public static final String OUTPUT_PREFIX = "output_";

        public void setLogging() throws TransformException {
            Transformer.this.logger = new TransformerLoggerFactory(Transformer.this).createLogger();
            if (Transformer.this.hasOption(AppOption.LOG_TERSE)) {
                this.isTerse = true;
            } else if (Transformer.this.hasOption(AppOption.LOG_VERBOSE)) {
                this.isVerbose = true;
            }
        }

        protected void info(String message, Object ... parms) {
            Transformer.this.getLogger().info(message, parms);
        }

        protected void error(String message, Object ... parms) {
            Transformer.this.getLogger().error(message, parms);
        }

        protected void error(String message, Throwable th, Object ... parms) {
            Logger useLogger = Transformer.this.getLogger();
            if (useLogger.isErrorEnabled()) {
                message = String.format(message, parms);
                useLogger.error(message, th);
            }
        }

        public String getInputFileName() {
            return this.inputName;
        }

        public String getOutputFileName() {
            return this.outputName;
        }

        protected InputBufferImpl getBuffer() {
            if (this.buffer == null) {
                this.buffer = new InputBufferImpl();
            }
            return this.buffer;
        }

        public boolean setRules() throws IOException, URISyntaxException, IllegalArgumentException {
            String masterTextRef;
            ImmediateRuleData[] immediateData = Transformer.this.getImmediateData();
            if (immediateData == null) {
                return false;
            }
            HashSet<String> orphanedFinalPackages = new HashSet<String>();
            UTF8Properties selectionProperties = Transformer.this.loadProperties(AppOption.RULES_SELECTIONS, null);
            UTF8Properties renameProperties = Transformer.this.loadProperties(AppOption.RULES_RENAMES, orphanedFinalPackages);
            UTF8Properties versionProperties = Transformer.this.loadProperties(AppOption.RULES_VERSIONS, null);
            UTF8Properties updateProperties = Transformer.this.loadProperties(AppOption.RULES_BUNDLES, null);
            UTF8Properties directProperties = Transformer.this.loadProperties(AppOption.RULES_DIRECT, null);
            UTF8Properties textMasterProperties = Transformer.this.loadProperties(AppOption.RULES_MASTER_TEXT, null);
            UTF8Properties perClassConstantProperties = Transformer.this.loadProperties(AppOption.RULES_PER_CLASS_CONSTANT, null);
            this.invert = Transformer.this.hasOption(AppOption.INVERT);
            if (!selectionProperties.isEmpty()) {
                this.includes = new HashSet<String>();
                this.excludes = new HashSet<String>();
                TransformProperties.addSelections(this.includes, this.excludes, selectionProperties);
                Transformer.this.dual_info("Selection rules are in use", new Object[0]);
            } else {
                this.includes = null;
                this.excludes = null;
            }
            if (!renameProperties.isEmpty()) {
                Map<String, String> renames = TransformProperties.getPackageRenames(renameProperties);
                if (this.invert) {
                    renames = TransformProperties.invert(renames);
                }
                this.packageRenames = renames;
                Transformer.this.dual_info("Package renames are in use", new Object[0]);
            } else {
                this.packageRenames = null;
            }
            if (!versionProperties.isEmpty()) {
                this.packageVersions = TransformProperties.getPackageVersions(versionProperties);
                Transformer.this.dual_info("Package versions will be updated", new Object[0]);
            } else {
                this.packageVersions = null;
            }
            if (!updateProperties.isEmpty()) {
                this.bundleUpdates = TransformProperties.getBundleUpdates(updateProperties);
                Transformer.this.dual_info("Bundle identities will be updated", new Object[0]);
            } else {
                this.bundleUpdates = null;
            }
            if (!textMasterProperties.isEmpty()) {
                masterTextRef = Transformer.this.getOptionValue(AppOption.RULES_MASTER_TEXT, DO_NORMALIZE);
                Map<String, String> substitutionRefs = TransformProperties.convertPropertiesToMap(textMasterProperties);
                HashMap<String, Map<String, String>> masterUpdates = new HashMap<String, Map<String, String>>();
                for (Map.Entry<String, String> substitutionRefEntry : substitutionRefs.entrySet()) {
                    String simpleNameSelector = substitutionRefEntry.getKey();
                    String substitutionsRef = FileUtils.normalize(substitutionRefEntry.getValue());
                    Map<String, String> substitutionsMap = this.loadSubstitutions(masterTextRef, simpleNameSelector, substitutionsRef);
                    substitutionRefs.put(simpleNameSelector, substitutionsRef);
                    masterUpdates.put(simpleNameSelector, substitutionsMap);
                }
                this.masterSubstitutionRefs = substitutionRefs;
                this.masterTextUpdates = masterUpdates;
                Transformer.this.dual_info("Text files will be updated", new Object[0]);
            } else {
                masterTextRef = null;
                this.masterTextUpdates = null;
            }
            if (!directProperties.isEmpty()) {
                this.directStrings = TransformProperties.getDirectStrings(directProperties);
                Transformer.this.dual_info("Java direct string updates will be performed", new Object[0]);
            } else {
                this.directStrings = null;
                Transformer.this.dual_info("Java direct string updates will not be performed", new Object[0]);
            }
            if (!perClassConstantProperties.isEmpty()) {
                String masterDirect = Transformer.this.getOptionValue(AppOption.RULES_PER_CLASS_CONSTANT, DO_NORMALIZE);
                Map<String, String> substitutionRefs = TransformProperties.convertPropertiesToMap(perClassConstantProperties);
                HashMap<String, Map<String, String>> masterUpdates = new HashMap<String, Map<String, String>>();
                for (Map.Entry<String, String> substitutionRefEntry : substitutionRefs.entrySet()) {
                    String classSelector = substitutionRefEntry.getKey();
                    String substitutionsRef = FileUtils.normalize(substitutionRefEntry.getValue());
                    UTF8Properties substitutions = new UTF8Properties();
                    if (masterDirect == null) {
                        substitutions = Transformer.this.loadInternalProperties("Substitions matching [ " + classSelector + " ]", substitutionsRef);
                    }
                    Map<String, String> substitutionsMap = TransformProperties.convertPropertiesToMap(substitutions);
                    masterUpdates.put(classSelector, substitutionsMap);
                }
                this.perClassConstantStrings = masterUpdates;
                Transformer.this.dual_info("Per class constant mapping files are enabled", new Object[0]);
            } else {
                this.perClassConstantStrings = null;
                Transformer.this.dual_info("Per class constant mapping files are not enabled", new Object[0]);
            }
            this.processImmediateData(immediateData, masterTextRef, orphanedFinalPackages);
            if (this.includes == null) {
                Transformer.this.dual_info("All resources will be selected", new Object[0]);
            }
            if (this.packageRenames == null) {
                Transformer.this.dual_info("No package renames are available", new Object[0]);
            }
            if (this.packageVersions == null) {
                Transformer.this.dual_info("Package versions will not be updated", new Object[0]);
            }
            if (this.bundleUpdates == null) {
                Transformer.this.dual_info("Bundle identities will not be updated", new Object[0]);
            }
            if (this.masterTextUpdates == null) {
                Transformer.this.dual_info("Text files will not be updated", new Object[0]);
            }
            if (this.directStrings == null) {
                Transformer.this.dual_info("Java direct string updates will not be performed", new Object[0]);
            }
            if (this.perClassConstantStrings == null) {
                Transformer.this.dual_info("Per class constant mapping files are not enabled", new Object[0]);
            }
            return this.validateRules(this.packageRenames, this.packageVersions, orphanedFinalPackages);
        }

        protected void processImmediateData(ImmediateRuleData[] immediateData, String masterTextRef, Set<String> orphanedFinalVersions) throws IOException, URISyntaxException {
            block8: for (ImmediateRuleData nextData : immediateData) {
                switch (nextData.target) {
                    case RULES_SELECTIONS: {
                        this.addImmediateSelection(nextData.key, nextData.value);
                        continue block8;
                    }
                    case RULES_RENAMES: {
                        this.addImmediateRename(nextData.key, nextData.value, orphanedFinalVersions);
                        continue block8;
                    }
                    case RULES_VERSIONS: {
                        this.addImmediateVersion(nextData.key, nextData.value);
                        continue block8;
                    }
                    case RULES_BUNDLES: {
                        this.addImmediateBundleData(nextData.key, nextData.value);
                        continue block8;
                    }
                    case RULES_DIRECT: {
                        this.addImmediateDirect(nextData.key, nextData.value);
                        continue block8;
                    }
                    case RULES_MASTER_TEXT: {
                        this.addImmediateMasterText(masterTextRef, nextData.key, nextData.value);
                        continue block8;
                    }
                    default: {
                        Transformer.this.dual_error("Unrecognized immediate data target [ {} ]", new Object[]{nextData.target});
                    }
                }
            }
        }

        private void addImmediateSelection(String selection, String ignored) {
            if (this.includes == null) {
                this.includes = new HashSet<String>();
                this.excludes = new HashSet<String>();
                Transformer.this.dual_info("Selection rules use forced by immediate data", new Object[0]);
            }
            TransformProperties.addSelection(this.includes, this.excludes, selection);
        }

        private void addImmediateRename(String initialPackageName, String finalPackageName, Set<String> orphanedFinalPackages) {
            if (this.packageRenames == null) {
                this.packageRenames = new HashMap<String, String>();
                Transformer.this.dual_info("Package renames forced by immediate data.", new Object[0]);
            }
            if (this.invert) {
                String initialHold = initialPackageName;
                initialPackageName = finalPackageName;
                finalPackageName = initialHold;
            }
            String oldFinalPackageName = this.packageRenames.put(initialPackageName, finalPackageName);
            Transformer.this.processOrphan("immediate rename data", "renameData", initialPackageName, oldFinalPackageName, finalPackageName, orphanedFinalPackages);
            Transformer.this.logMerge("immediate rename data", "rename data", initialPackageName, oldFinalPackageName, finalPackageName);
        }

        private void addImmediateVersion(String finalPackageName, String versionText) {
            if (this.packageVersions == null) {
                this.packageVersions = new HashMap<String, String>();
                Transformer.this.dual_info("Package version updates forced by immediate data.", new Object[0]);
            }
            String oldVersionText = this.packageVersions.put(finalPackageName, versionText);
            Transformer.this.logMerge("immediate package version data", "package version data", finalPackageName, oldVersionText, versionText);
        }

        private void addImmediateBundleData(String bundleId, String value) {
            BundleDataImpl newBundleData;
            BundleData oldBundleData;
            if (this.bundleUpdates == null) {
                this.bundleUpdates = new HashMap<String, BundleData>();
                Transformer.this.dual_info("Bundle identity updates forced by immediate data.", new Object[0]);
            }
            if ((oldBundleData = this.bundleUpdates.put(bundleId, newBundleData = new BundleDataImpl(value))) != null) {
                Transformer.this.logMerge("immediate bundle data", "bundle data", bundleId, oldBundleData.getPrintString(), newBundleData.getPrintString());
            }
        }

        private void addImmediateDirect(String initialText, String finalText) {
            String oldFinalText;
            if (this.directStrings == null) {
                this.directStrings = new HashMap<String, String>();
                Transformer.this.dual_info("Java direct string updates forced by immediate data", new Object[0]);
            }
            if ((oldFinalText = this.directStrings.put(initialText, finalText)) != null) {
                Transformer.this.logMerge("immediate direct string data", "direct string data", initialText, oldFinalText, finalText);
            }
        }

        private Map<String, String> loadSubstitutions(String masterRef, String selector, String substitutionsRef) throws IOException, URISyntaxException {
            UTF8Properties substitutions;
            if (masterRef == null) {
                substitutions = Transformer.this.loadInternalProperties("Substitions matching [ " + selector + " ]", substitutionsRef);
            } else {
                String relativeSubstitutionsRef = Transformer.this.relativize(substitutionsRef, masterRef);
                if (!relativeSubstitutionsRef.equals(substitutionsRef)) {
                    Transformer.this.dual_info("Adjusted substition reference from [ %s ] to [ %s ]", substitutionsRef, relativeSubstitutionsRef);
                }
                substitutions = Transformer.this.loadExternalProperties("Substitions matching [ " + selector + " ]", relativeSubstitutionsRef);
            }
            Map<String, String> substitutionsMap = TransformProperties.convertPropertiesToMap(substitutions);
            return substitutionsMap;
        }

        private void addImmediateMasterText(String masterTextRef, String simpleNameSelector, String substitutionsRef) throws IOException, URISyntaxException {
            if (this.masterTextUpdates == null) {
                this.masterTextUpdates = new HashMap<String, Map<String, String>>();
                Transformer.this.dual_info("Text files updates forced by immediate data.", new Object[0]);
            }
            substitutionsRef = FileUtils.normalize(substitutionsRef);
            Map<String, String> substitutionsMap = this.loadSubstitutions(masterTextRef, simpleNameSelector, substitutionsRef);
            String oldSubstitutionsRef = this.masterSubstitutionRefs.put(simpleNameSelector, substitutionsRef);
            Map<String, String> oldSubstitutionMap = this.masterTextUpdates.put(simpleNameSelector, substitutionsMap);
            if (oldSubstitutionsRef != null) {
                Transformer.this.logMerge("immediate master text data", "master text data", simpleNameSelector, oldSubstitutionsRef, substitutionsRef);
            }
        }

        protected boolean validateRules(Map<String, String> renamesMap, Map<String, String> versionsMap, Set<String> orphanedFinalPackages) {
            if (versionsMap == null || versionsMap.isEmpty()) {
                return true;
            }
            if (renamesMap == null || renamesMap.isEmpty()) {
                String[] renamesRefs = this.getRuleFileNames(AppOption.RULES_RENAMES);
                if (renamesRefs == null) {
                    Transformer.this.dual_error("Package version updates were specified but no rename rules were specified.", new Object[0]);
                } else {
                    Transformer.this.dual_error("Package version updates were specified but no rename rules were specified.", new Object[0]);
                }
                return false;
            }
            boolean missingFinalPackages = false;
            for (String finalPackage : versionsMap.keySet()) {
                if (renamesMap.containsValue(finalPackage)) continue;
                if (orphanedFinalPackages.contains(finalPackage)) {
                    Transformer.this.dual_debug("Final package [ " + finalPackage + " ] was orphaned.", new Object[0]);
                    continue;
                }
                Transformer.this.dual_error("Version rule package name [ " + finalPackage + " ] was not found as a final package name in the package renames data.", new Object[0]);
                missingFinalPackages = true;
            }
            return !missingFinalPackages;
        }

        protected String[] getRuleFileNames(AppOption ruleOption) {
            String[] stringArray;
            String[] rulesFileNames = Transformer.this.getOptionValues(ruleOption, DO_NORMALIZE);
            if (rulesFileNames != null) {
                return rulesFileNames;
            }
            String defaultReference = Transformer.this.getDefaultReference(ruleOption);
            if (defaultReference == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = defaultReference;
            }
            return stringArray;
        }

        protected void logRules() {
            this.info("Includes:", new Object[0]);
            if (this.includes == null || this.includes.isEmpty()) {
                this.info("  [ ** NONE ** ]", new Object[0]);
            } else {
                for (String string : this.includes) {
                    this.info("  [ " + string + " ]", new Object[0]);
                }
            }
            this.info("Excludes:", new Object[0]);
            if (this.excludes == null || this.excludes.isEmpty()) {
                this.info("  [ ** NONE ** ]", new Object[0]);
            } else {
                for (String string : this.excludes) {
                    this.info("  [ " + string + " ]", new Object[0]);
                }
            }
            if (this.invert) {
                this.info("Package Renames: [ ** INVERTED ** ]", new Object[0]);
            } else {
                this.info("Package Renames:", new Object[0]);
            }
            if (this.packageRenames == null || this.packageRenames.isEmpty()) {
                this.info("  [ ** NONE ** ]", new Object[0]);
            } else {
                for (Map.Entry entry : this.packageRenames.entrySet()) {
                    this.info("  [ " + (String)entry.getKey() + " ]: [ " + (String)entry.getValue() + " ]", new Object[0]);
                }
            }
            this.info("Package Versions:", new Object[0]);
            if (this.packageVersions == null || this.packageVersions.isEmpty()) {
                this.info("  [ ** NONE ** ]", new Object[0]);
            } else {
                for (Map.Entry entry : this.packageVersions.entrySet()) {
                    this.info("  [ " + (String)entry.getKey() + " ]: [ " + (String)entry.getValue() + " ]", new Object[0]);
                }
            }
            this.info("Bundle Updates:", new Object[0]);
            if (this.bundleUpdates == null || this.bundleUpdates.isEmpty()) {
                this.info("  [ ** NONE ** ]", new Object[0]);
            } else {
                for (Map.Entry entry : this.bundleUpdates.entrySet()) {
                    BundleData updateData = (BundleData)entry.getValue();
                    this.info("  [ " + (String)entry.getKey() + " ]: [ " + updateData.getSymbolicName() + " ]", new Object[0]);
                    this.info("    [ Version ]: [ " + updateData.getVersion() + " ]", new Object[0]);
                    if (updateData.getAddName()) {
                        this.info("    [ Name ]: [ +" + updateData.getName() + " ]", new Object[0]);
                    } else {
                        this.info("    [ Name ]: [ " + updateData.getName() + " ]", new Object[0]);
                    }
                    if (updateData.getAddDescription()) {
                        this.info("    [ Description ]: [ +" + updateData.getDescription() + " ]", new Object[0]);
                        continue;
                    }
                    this.info("    [ Description ]: [ " + updateData.getDescription() + " ]", new Object[0]);
                }
            }
            this.info("Java string substitutions:", new Object[0]);
            if (this.directStrings == null || this.directStrings.isEmpty()) {
                this.info("  [ ** NONE ** ]", new Object[0]);
            } else {
                for (Map.Entry entry : this.directStrings.entrySet()) {
                    this.info("  [ " + (String)entry.getKey() + " ]: [ " + (String)entry.getValue() + "]", new Object[0]);
                }
            }
            this.info("Text substitutions:", new Object[0]);
            if (this.masterTextUpdates == null || this.masterTextUpdates.isEmpty()) {
                this.info("  [ ** NONE ** ]", new Object[0]);
            } else {
                for (Map.Entry entry : this.masterTextUpdates.entrySet()) {
                    this.info("  Pattern [ " + (String)entry.getKey() + " ]", new Object[0]);
                    for (Map.Entry substitution : ((Map)entry.getValue()).entrySet()) {
                        this.info("    [ " + (String)substitution.getKey() + " ]: [ " + (String)substitution.getValue() + " ]", new Object[0]);
                    }
                }
            }
        }

        protected SelectionRuleImpl getSelectionRule() {
            if (this.selectionRules == null) {
                this.selectionRules = new SelectionRuleImpl(Transformer.this.logger, this.includes, this.excludes);
            }
            return this.selectionRules;
        }

        protected SignatureRuleImpl getSignatureRule() {
            if (this.signatureRules == null) {
                this.signatureRules = new SignatureRuleImpl(Transformer.this.logger, this.packageRenames, this.packageVersions, this.bundleUpdates, this.masterTextUpdates, this.directStrings, this.perClassConstantStrings);
            }
            return this.signatureRules;
        }

        public boolean setInput() {
            String useInputName = Transformer.this.getInputFileNameFromCommandLine();
            if (useInputName == null) {
                Transformer.this.dual_error("No input file was specified", new Object[0]);
                return false;
            }
            this.inputName = FileUtils.normalize(useInputName);
            this.inputFile = new File(this.inputName);
            this.inputPath = this.inputFile.getAbsolutePath();
            if (!this.inputFile.exists()) {
                Transformer.this.dual_error("Input does not exist [ %s ] [ %s ]", this.inputName, this.inputPath);
                return false;
            }
            Transformer.this.dual_info("Input     [ %s ]", this.inputName);
            Transformer.this.dual_info("          [ %s ]", this.inputPath);
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean setOutput() {
            boolean putIntoDirectory;
            boolean isExplicit;
            String useOutputName = Transformer.this.getOutputFileNameFromCommandLine();
            boolean bl = isExplicit = useOutputName != null;
            if (isExplicit) {
                useOutputName = FileUtils.normalize(useOutputName);
            } else {
                int indexOfLastSlash = this.inputName.lastIndexOf(47);
                if (indexOfLastSlash == -1) {
                    useOutputName = OUTPUT_PREFIX + this.inputName;
                } else {
                    String inputPrefix = this.inputName.substring(0, indexOfLastSlash + 1);
                    String inputSuffix = this.inputName.substring(indexOfLastSlash + 1);
                    useOutputName = inputPrefix + OUTPUT_PREFIX + inputSuffix;
                }
            }
            File useOutputFile = new File(useOutputName);
            String useOutputPath = useOutputFile.getAbsolutePath();
            boolean bl2 = putIntoDirectory = this.inputFile.isFile() && useOutputFile.isDirectory();
            if (putIntoDirectory) {
                useOutputName = useOutputName + '/' + this.inputName;
                if (this.isVerbose) {
                    Transformer.this.dual_info("Output generated using input name and output directory [ %s ]", useOutputName);
                }
                useOutputFile = new File(useOutputName);
                useOutputPath = useOutputFile.getAbsolutePath();
            }
            String outputCase = isExplicit ? (putIntoDirectory ? "Explicit directory" : "Explicit") : (putIntoDirectory ? "Directory generated from input" : "Generated from input");
            Transformer.this.dual_info("Output    [ %s ] (%s)", useOutputName, outputCase);
            Transformer.this.dual_info("          [ %s ]", useOutputPath);
            this.allowOverwrite = Transformer.this.hasOption(AppOption.OVERWRITE);
            if (this.allowOverwrite) {
                Transformer.this.dual_info("Overwrite of output is enabled", new Object[0]);
            }
            if (useOutputFile.exists()) {
                if (!this.allowOverwrite) {
                    Transformer.this.dual_error("Output already exists [ %s ]", useOutputPath);
                    return false;
                }
                Transformer.this.dual_info("Output exists and will be overwritten [ %s ]", useOutputPath);
            } else if (this.allowOverwrite && this.isVerbose) {
                Transformer.this.dual_info("Overwritten specified, but output [ %s ] does not exist", useOutputPath);
            }
            this.outputName = useOutputName;
            this.outputFile = useOutputFile;
            this.outputPath = useOutputPath;
            return true;
        }

        public CompositeActionImpl getRootAction() {
            if (this.rootAction == null) {
                CompositeActionImpl useRootAction = new CompositeActionImpl(Transformer.this.getLogger(), this.isTerse, this.isVerbose, this.getBuffer(), this.getSelectionRule(), this.getSignatureRule());
                DirectoryActionImpl directoryAction = useRootAction.addUsing(DirectoryActionImpl::new);
                ClassActionImpl classAction = useRootAction.addUsing(ClassActionImpl::new);
                JavaActionImpl javaAction = useRootAction.addUsing(JavaActionImpl::new);
                ServiceLoaderConfigActionImpl serviceConfigAction = useRootAction.addUsing(ServiceLoaderConfigActionImpl::new);
                ManifestActionImpl manifestAction = useRootAction.addUsing(ManifestActionImpl::newManifestAction);
                ManifestActionImpl featureAction = useRootAction.addUsing(ManifestActionImpl::newFeatureAction);
                PropertiesActionImpl propertiesAction = useRootAction.addUsing(PropertiesActionImpl::new);
                JarActionImpl jarAction = useRootAction.addUsing(JarActionImpl::new);
                WarActionImpl warAction = useRootAction.addUsing(WarActionImpl::new);
                RarActionImpl rarAction = useRootAction.addUsing(RarActionImpl::new);
                EarActionImpl earAction = useRootAction.addUsing(EarActionImpl::new);
                TextActionImpl textAction = useRootAction.addUsing(TextActionImpl::new);
                ZipActionImpl zipAction = useRootAction.addUsing(ZipActionImpl::new);
                NullActionImpl nullAction = useRootAction.addUsing(NullActionImpl::new);
                directoryAction.addAction(classAction);
                directoryAction.addAction(javaAction);
                directoryAction.addAction(serviceConfigAction);
                directoryAction.addAction(manifestAction);
                directoryAction.addAction(featureAction);
                directoryAction.addAction(zipAction);
                directoryAction.addAction(jarAction);
                directoryAction.addAction(warAction);
                directoryAction.addAction(rarAction);
                directoryAction.addAction(earAction);
                directoryAction.addAction(textAction);
                directoryAction.addAction(nullAction);
                jarAction.addAction(classAction);
                jarAction.addAction(javaAction);
                jarAction.addAction(serviceConfigAction);
                jarAction.addAction(manifestAction);
                jarAction.addAction(featureAction);
                jarAction.addAction(textAction);
                jarAction.addAction(propertiesAction);
                jarAction.addAction(nullAction);
                warAction.addAction(classAction);
                warAction.addAction(javaAction);
                warAction.addAction(serviceConfigAction);
                warAction.addAction(manifestAction);
                warAction.addAction(featureAction);
                warAction.addAction(jarAction);
                warAction.addAction(textAction);
                warAction.addAction(nullAction);
                rarAction.addAction(classAction);
                rarAction.addAction(javaAction);
                rarAction.addAction(serviceConfigAction);
                rarAction.addAction(manifestAction);
                rarAction.addAction(featureAction);
                rarAction.addAction(jarAction);
                rarAction.addAction(textAction);
                rarAction.addAction(nullAction);
                earAction.addAction(manifestAction);
                earAction.addAction(jarAction);
                earAction.addAction(warAction);
                earAction.addAction(rarAction);
                earAction.addAction(textAction);
                earAction.addAction(nullAction);
                zipAction.addAction(classAction);
                zipAction.addAction(javaAction);
                zipAction.addAction(serviceConfigAction);
                zipAction.addAction(manifestAction);
                zipAction.addAction(featureAction);
                zipAction.addAction(jarAction);
                zipAction.addAction(warAction);
                zipAction.addAction(rarAction);
                zipAction.addAction(earAction);
                zipAction.addAction(textAction);
                zipAction.addAction(nullAction);
                this.rootAction = useRootAction;
            }
            return this.rootAction;
        }

        public boolean acceptAction() {
            String actionName = Transformer.this.getOptionValue(AppOption.FILE_TYPE);
            if (actionName != null) {
                for (ActionImpl action : this.getRootAction().getActions()) {
                    if (!action.getActionType().matches(actionName)) continue;
                    Transformer.this.dual_info("Forced action [ %s ] [ %s ]", actionName, action.getName());
                    this.acceptedAction = action;
                    return true;
                }
                Transformer.this.dual_error("No match for forced action [ %s ]", actionName);
                return false;
            }
            this.acceptedAction = this.getRootAction().acceptAction(this.inputName, this.inputFile);
            if (this.acceptedAction == null) {
                Transformer.this.dual_error("No action selected for input [ %s ]", this.inputName);
                return false;
            }
            Transformer.this.dual_info("Action selected for input [ %s ]: %s", this.inputName, this.acceptedAction.getName());
            return true;
        }

        public void transform() throws TransformException {
            this.acceptedAction.apply(this.inputName, this.inputFile, this.outputFile);
            if (this.isTerse) {
                if (!Transformer.this.toSysOut && !Transformer.this.toSysErr) {
                    this.acceptedAction.getLastActiveChanges().displayTerse(Transformer.this.getSystemOut(), this.inputPath, this.outputPath);
                }
                this.acceptedAction.getLastActiveChanges().displayTerse(Transformer.this.getLogger(), this.inputPath, this.outputPath);
            } else if (this.isVerbose) {
                if (!Transformer.this.toSysOut && !Transformer.this.toSysErr) {
                    this.acceptedAction.getLastActiveChanges().displayVerbose(Transformer.this.getSystemOut(), this.inputPath, this.outputPath);
                }
                this.acceptedAction.getLastActiveChanges().displayVerbose(Transformer.this.getLogger(), this.inputPath, this.outputPath);
            } else {
                if (!Transformer.this.toSysOut && !Transformer.this.toSysErr) {
                    this.acceptedAction.getLastActiveChanges().display(Transformer.this.getSystemOut(), this.inputPath, this.outputPath);
                }
                this.acceptedAction.getLastActiveChanges().display(Transformer.this.getLogger(), this.inputPath, this.outputPath);
            }
        }

        public Changes getLastActiveChanges() {
            if (this.acceptedAction != null) {
                return this.acceptedAction.getLastActiveChanges();
            }
            return null;
        }
    }

    public static class ImmediateRuleData {
        public final AppOption target;
        public final String key;
        public final String value;

        public ImmediateRuleData(AppOption target, String key, String value) {
            this.target = target;
            this.key = key;
            this.value = value;
        }
    }

    public static enum AppOption {
        USAGE("u", "usage", "Display usage", false, false, false, OptionSettings.access$000()),
        HELP("h", "help", "Display help", false, false, false, OptionSettings.access$000()),
        LOG_TERSE("q", "quiet", "Display quiet output", false, false, false, OptionSettings.access$000()),
        LOG_VERBOSE("v", "verbose", "Display verbose output", false, false, false, OptionSettings.access$000()),
        LOG_PROPERTY("lp", "logProperty", "Logging property", false, true, false, OptionSettings.access$000()),
        LOG_PROPERTY_FILE("lpf", "logPropertyFile", "Logging properties file", true, false, false, OptionSettings.access$000()),
        LOG_NAME("ln", "logName", "Logger name", true, false, false, OptionSettings.access$000()),
        LOG_LEVEL("ll", "logLevel", "Logging level", true, false, false, OptionSettings.access$000()),
        LOG_FILE("lf", "logFile", "Logging file", true, false, false, OptionSettings.access$000()),
        RULES_SELECTIONS("ts", "selection", "Transformation selections URL", true, false, false, OptionSettings.access$000()),
        RULES_RENAMES("tr", "renames", "Transformation package renames URL", true, false, false, OptionSettings.access$000()),
        RULES_VERSIONS("tv", "versions", "Transformation package versions URL", true, false, false, OptionSettings.access$000()),
        RULES_BUNDLES("tb", "bundles", "Transformation bundle updates URL", true, false, false, OptionSettings.access$000()),
        RULES_DIRECT("td", "direct", "Transformation direct string replacements", true, false, false, OptionSettings.access$000()),
        RULES_MASTER_TEXT("tf", "text", "Map of filenames to property files", true, false, false, OptionSettings.access$000()),
        RULES_IMMEDIATE_DATA("ti", "immediate", "Immediate rule data", false, false, true, 3, false, OptionSettings.access$000()),
        INVERT("i", "invert", "Invert transformation rules", false, false, false, OptionSettings.access$000()),
        FILE_TYPE("t", "type", "Input file type", true, false, false, OptionSettings.access$000()),
        OVERWRITE("o", "overwrite", "Overwrite", false, false, false, OptionSettings.access$000()),
        DRYRUN("d", "dryrun", "Dry run", false, false, false, OptionSettings.access$000()),
        RULES_PER_CLASS_CONSTANT("tp", "per-class-constant", "Transformation per class constant string replacements", true, false, false, OptionSettings.access$000());

        private final OptionSettings settings;

        private AppOption(String shortTag, String longTag, String description, boolean hasArg, boolean hasArgs, boolean hasArgCount, int argCount, boolean isRequired, String groupTag) {
            this.settings = new OptionSettings(shortTag, longTag, description, hasArg, hasArgs, hasArgCount, argCount, isRequired, groupTag);
        }

        private AppOption(String shortTag, String longTag, String description, boolean hasArg, boolean hasArgs, boolean isRequired, String groupTag) {
            this.settings = new OptionSettings(shortTag, longTag, description, hasArg, hasArgs, isRequired, groupTag);
        }

        public OptionSettings getSettings() {
            return this.settings;
        }

        public String getShortTag() {
            return this.getSettings().getShortTag();
        }

        public String getLongTag() {
            return this.getSettings().getLongTag();
        }

        public String getDescription() {
            return this.getSettings().getDescription();
        }

        public boolean getIsRequired() {
            return this.getSettings().getIsRequired();
        }

        public boolean getHasArg() {
            return this.getSettings().getHasArg();
        }

        public String getGroupTag() {
            return this.getSettings().getGroupTag();
        }

        private static OptionSettings[] getAllSettings() {
            AppOption[] allAppOptions = AppOption.values();
            OptionSettings[] allSettings = new OptionSettings[allAppOptions.length];
            for (int optionNo = 0; optionNo < allAppOptions.length; ++optionNo) {
                allSettings[optionNo] = allAppOptions[optionNo].getSettings();
            }
            return allSettings;
        }

        public static Options build() {
            return OptionSettings.build(AppOption.getAllSettings());
        }
    }

    public static class OptionSettings {
        private static final boolean HAS_ARG = true;
        private static final boolean HAS_ARGS = true;
        private static final boolean HAS_ARG_COUNT = true;
        private static final boolean IS_REQUIRED = true;
        private static final String NO_GROUP = null;
        private final String shortTag;
        private final String longTag;
        private final String description;
        private final boolean isRequired;
        private final boolean hasArg;
        private final boolean hasArgs;
        private final boolean hasArgCount;
        private final int argCount;
        private final String groupTag;

        private OptionSettings(String shortTag, String longTag, String description, boolean hasArg, boolean hasArgs, boolean isRequired, String groupTag) {
            this(shortTag, longTag, description, hasArg, hasArgs, false, -1, isRequired, groupTag);
        }

        private OptionSettings(String shortTag, String longTag, String description, boolean hasArg, boolean hasArgs, boolean hasArgCount, int argCount, boolean isRequired, String groupTag) {
            this.shortTag = shortTag;
            this.longTag = longTag;
            this.description = description;
            this.isRequired = isRequired;
            this.hasArg = hasArg;
            this.hasArgs = hasArgs;
            this.hasArgCount = hasArgCount;
            this.argCount = argCount;
            this.groupTag = groupTag;
        }

        public String getShortTag() {
            return this.shortTag;
        }

        public String getLongTag() {
            return this.longTag;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean getHasArg() {
            return this.hasArg;
        }

        public boolean getHasArgs() {
            return this.hasArgs;
        }

        public boolean getHasArgCount() {
            return this.hasArgCount;
        }

        public int getArgCount() {
            return this.argCount;
        }

        public String getGroupTag() {
            return this.groupTag;
        }

        public boolean getIsRequired() {
            return this.isRequired;
        }

        public static Options build(OptionSettings[] settings) {
            Options options = new Options();
            HashMap<String, OptionGroup> groups = new HashMap<String, OptionGroup>();
            for (OptionSettings optionSettings : settings) {
                OptionGroup group;
                String groupTag = optionSettings.getGroupTag();
                if (groupTag != null) {
                    group = (OptionGroup)groups.get(groupTag);
                    if (group == null) {
                        group = new OptionGroup();
                        if (optionSettings.getIsRequired()) {
                            group.setRequired(true);
                        }
                        groups.put(groupTag, group);
                        options.addOptionGroup(group);
                    }
                } else {
                    group = null;
                }
                Option.Builder builder = Option.builder(optionSettings.getShortTag());
                builder.longOpt(optionSettings.getLongTag());
                builder.desc(optionSettings.getDescription());
                if (optionSettings.getHasArgs()) {
                    builder.hasArg(false);
                    builder.hasArgs();
                } else if (optionSettings.getHasArg()) {
                    builder.hasArg();
                } else if (optionSettings.getHasArgCount()) {
                    builder.numberOfArgs(optionSettings.getArgCount());
                }
                builder.required(group == null && optionSettings.getIsRequired());
                Option option = builder.build();
                if (group != null) {
                    group.addOption(option);
                    continue;
                }
                options.addOption(option);
            }
            return options;
        }

        static /* synthetic */ String access$000() {
            return NO_GROUP;
        }
    }
}

