/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.graphics;

import org.aesh.graphics.Graphics;
import org.aesh.graphics.GraphicsConfiguration;
import org.aesh.readline.terminal.formatting.TerminalColor;
import org.aesh.readline.terminal.formatting.TerminalTextStyle;
import org.aesh.terminal.Connection;
import org.aesh.terminal.tty.Capability;
import org.aesh.terminal.tty.Size;

public class AeshGraphics
implements Graphics {
    private static final String CURSOR_DOWN = "\u001b[1B\u001b[1D";
    private final Connection connection;
    private final GraphicsConfiguration graphicsConfiguration;
    private TerminalColor currentColor;
    private TerminalTextStyle currentStyle;

    AeshGraphics(Connection connection, GraphicsConfiguration graphicsConfiguration) {
        this.connection = connection;
        this.graphicsConfiguration = graphicsConfiguration;
        this.currentColor = new TerminalColor();
        connection.put(Capability.cursor_invisible, new Object[0]);
    }

    @Override
    public void flush() {
    }

    @Override
    public void clear() {
        this.printColor(new TerminalColor());
        this.connection.put(Capability.clear_screen, new Object[0]);
    }

    @Override
    public void clearAndShowCursor() {
        this.clear();
        this.connection.put(Capability.cursor_normal, new Object[0]);
    }

    @Override
    public TerminalColor getColor() {
        return this.currentColor;
    }

    @Override
    public void setColor(TerminalColor color) {
        this.currentColor = color;
    }

    @Override
    public TerminalTextStyle getTextStyle() {
        return this.currentStyle;
    }

    @Override
    public void setTextStyle(TerminalTextStyle textStyle) {
        this.currentStyle = textStyle;
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        this.printColor(this.currentColor);
        this.drawHorizontalLine(x, y, width);
        this.drawHorizontalLine(x, y + height, width);
        this.drawVerticalLine(x, y + 1, height - 1);
        this.drawVerticalLine(x + width - 1, y + 1, height - 1);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.printColor(this.currentColor);
        int dx = x2 - x1;
        int dy = y2 - y1;
        for (int i = x1; i < x2; ++i) {
            int y = y1 + dy * (i - x1) / dx;
            this.connection.put(Capability.cursor_address, new Object[]{y, i});
            this.connection.write("x");
        }
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.printColor(this.currentColor);
        this.connection.put(Capability.cursor_address, new Object[]{y, x});
        this.connection.write(str);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.printColor(this.currentColor);
        for (int j = 0; j < height; ++j) {
            this.connection.put(Capability.cursor_address, new Object[]{y + j, x});
            for (int i = 0; i < width; ++i) {
                this.connection.write(" ");
            }
        }
    }

    @Override
    public void drawCircle(int x0, int y0, int radius) {
        this.printColor(this.currentColor);
        int x = radius;
        int radiusError = 1 - x;
        for (int y = 0; x >= y; ++y) {
            this.drawPixel(x + x0, y + y0);
            this.drawPixel(y + x0, x + y0);
            this.drawPixel(-x + x0, y + y0);
            this.drawPixel(-y + x0, x + y0);
            this.drawPixel(-x + x0, -y + y0);
            this.drawPixel(-y + x0, -x + y0);
            this.drawPixel(x + x0, -y + y0);
            this.drawPixel(y + x0, -x + y0);
            if (radiusError < 0) {
                radiusError += 2 * y + 1;
                continue;
            }
            radiusError += 2 * (y - --x + 1);
        }
    }

    private void printColor(TerminalColor color) {
        if (color != null) {
            this.connection.write(color.fullString());
        }
    }

    private void drawPixel(int x, int y) {
        this.connection.put(Capability.cursor_address, new Object[]{y, x});
        this.connection.write("x");
    }

    private void drawHorizontalLine(int x, int y, int width) {
        Size terminalSize = this.graphicsConfiguration.getBounds();
        if (terminalSize.getHeight() > y && terminalSize.getWidth() > y) {
            if (terminalSize.getWidth() < x + width) {
                width = terminalSize.getWidth() - x - 1;
            }
            this.connection.put(Capability.cursor_address, new Object[]{y, x});
            char[] line = new char[width];
            for (int i = 0; i < line.length; ++i) {
                line[i] = i == 0 || i == line.length - 1 ? 120 : 45;
            }
            this.connection.write(new String(line));
        }
    }

    private void drawVerticalLine(int x, int y, int length) {
        Size terminalSize = this.graphicsConfiguration.getBounds();
        if (terminalSize.getHeight() > y && terminalSize.getWidth() > y) {
            if (terminalSize.getHeight() < y + length) {
                length = terminalSize.getHeight() - y - 1;
            }
            this.connection.put(Capability.cursor_address, new Object[]{y, x});
            for (int i = 0; i < length; ++i) {
                this.connection.write("|");
                this.connection.write(CURSOR_DOWN);
            }
        }
    }
}

