/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import jakarta.jms.CompletionListener;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.ra.ActiveMQRASession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQRAMessageProducer
implements MessageProducer {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected MessageProducer producer;
    protected ActiveMQRASession session;

    public ActiveMQRAMessageProducer(MessageProducer producer, ActiveMQRASession session) {
        this.producer = producer;
        this.session = session;
        if (logger.isTraceEnabled()) {
            logger.trace("new ActiveMQMessageProducer {}  producer={} session={}", new Object[]{this, producer, session});
        }
    }

    public void close() throws JMSException {
        logger.trace("close {}", (Object)this);
        try {
            this.closeProducer();
        }
        finally {
            this.session.removeProducer(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.session.lock();
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("send {} destination={} message={} deliveryMode={} priority={} ttl={}", new Object[]{this, destination, message, deliveryMode, priority, timeToLive});
            }
            this.checkState();
            this.producer.send(destination, message, deliveryMode, priority, timeToLive);
            logger.trace("sent {} result={}", (Object)this, (Object)message);
        }
        finally {
            this.session.unlock();
        }
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.session.lock();
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("send {} destination={} message={}", new Object[]{this, destination, message});
            }
            this.checkState();
            this.producer.send(destination, message);
            logger.trace("sent {} result={}", (Object)this, (Object)message);
        }
        finally {
            this.session.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.session.lock();
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("send {} message={} deliveryMode={} priority={} ttl={}", new Object[]{this, message, deliveryMode, priority, timeToLive});
            }
            this.checkState();
            this.producer.send(message, deliveryMode, priority, timeToLive);
            logger.trace("sent {} result={}", (Object)this, (Object)message);
        }
        finally {
            this.session.unlock();
        }
    }

    public void send(Message message) throws JMSException {
        this.session.lock();
        try {
            logger.trace("send {} result={}", (Object)this, (Object)message);
            this.checkState();
            this.producer.send(message);
            logger.trace("sent {} result={}", (Object)this, (Object)message);
        }
        finally {
            this.session.unlock();
        }
    }

    public int getDeliveryMode() throws JMSException {
        logger.trace("getRoutingType()");
        return this.producer.getDeliveryMode();
    }

    public Destination getDestination() throws JMSException {
        logger.trace("getDestination()");
        return this.producer.getDestination();
    }

    public boolean getDisableMessageID() throws JMSException {
        logger.trace("getDisableMessageID()");
        return this.producer.getDisableMessageID();
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        logger.trace("getDisableMessageTimestamp()");
        return this.producer.getDisableMessageTimestamp();
    }

    public int getPriority() throws JMSException {
        logger.trace("getPriority()");
        return this.producer.getPriority();
    }

    public long getTimeToLive() throws JMSException {
        logger.trace("getTimeToLive()");
        return this.producer.getTimeToLive();
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("setRoutingType({})", (Object)deliveryMode);
        }
        this.producer.setDeliveryMode(deliveryMode);
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("setDisableMessageID({})", (Object)value);
        }
        this.producer.setDisableMessageID(value);
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("setDisableMessageTimestamp({})", (Object)value);
        }
        this.producer.setDisableMessageTimestamp(value);
    }

    public void setPriority(int defaultPriority) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("setPriority({})", (Object)defaultPriority);
        }
        this.producer.setPriority(defaultPriority);
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("setTimeToLive({})", (Object)timeToLive);
        }
        this.producer.setTimeToLive(timeToLive);
    }

    public void setDeliveryDelay(long deliveryDelay) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("setDeliveryDelay({})", (Object)deliveryDelay);
        }
        this.producer.setDeliveryDelay(deliveryDelay);
    }

    public long getDeliveryDelay() throws JMSException {
        logger.trace("getDeliveryDelay()");
        return this.producer.getDeliveryDelay();
    }

    public void send(Message message, CompletionListener completionListener) throws JMSException {
        logger.trace("send({}, {})", (Object)message, (Object)completionListener);
        this.producer.send(message, completionListener);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("send({}, {}, {}, {}, {})", new Object[]{message, deliveryMode, priority, timeToLive, completionListener});
        }
        this.producer.send(message, deliveryMode, priority, timeToLive, completionListener);
    }

    public void send(Destination destination, Message message, CompletionListener completionListener) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("send({}, {}, {})", new Object[]{destination, message, completionListener});
        }
        this.producer.send(destination, message, completionListener);
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("send({}, {}, {}, {}, {}, {})", new Object[]{destination, message, deliveryMode, priority, timeToLive, completionListener});
        }
        this.producer.send(destination, message, deliveryMode, priority, timeToLive, completionListener);
    }

    void checkState() throws JMSException {
        this.session.checkState();
    }

    void closeProducer() throws JMSException {
        this.producer.close();
    }
}

