/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchDocumentReference;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionExtractionHelper;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionRequestContext;
import org.hibernate.search.engine.backend.common.DocumentReference;

public final class DocumentReferenceExtractionHelper
implements ProjectionExtractionHelper<DocumentReference> {
    private final ProjectionExtractionHelper<String> mappedTypeNameHelper;
    private final ProjectionExtractionHelper<String> idHelper;

    public DocumentReferenceExtractionHelper(ProjectionExtractionHelper<String> mappedTypeNameHelper, ProjectionExtractionHelper<String> idHelper) {
        this.mappedTypeNameHelper = mappedTypeNameHelper;
        this.idHelper = idHelper;
    }

    @Override
    public void request(JsonObject requestBody, ProjectionRequestContext context) {
        this.mappedTypeNameHelper.request(requestBody, context);
        this.idHelper.request(requestBody, context);
    }

    @Override
    public DocumentReference extract(JsonObject hit, ProjectionExtractContext context) {
        String mappedTypeName = this.mappedTypeNameHelper.extract(hit, context);
        String id = this.idHelper.extract(hit, context);
        return new ElasticsearchDocumentReference(mappedTypeName, id);
    }
}

