/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.dmr.ModelNode;

class OperationImpl
implements Operation {
    private final boolean autoCloseStreams;
    private final ModelNode operation;
    private final List<InputStream> inputStreams;

    OperationImpl(ModelNode operation, List<InputStream> inputStreams) {
        this(operation, inputStreams, false);
    }

    OperationImpl(ModelNode operation, List<InputStream> inputStreams, boolean autoCloseStreams) {
        this.operation = operation;
        this.inputStreams = inputStreams;
        this.autoCloseStreams = autoCloseStreams;
    }

    @Override
    public boolean isAutoCloseStreams() {
        return this.autoCloseStreams;
    }

    @Override
    public ModelNode getOperation() {
        return this.operation;
    }

    @Override
    public List<InputStream> getInputStreams() {
        if (this.inputStreams == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.inputStreams);
    }

    @Override
    public void close() throws IOException {
        List<InputStream> streams = this.getInputStreams();
        for (InputStream stream : streams) {
            StreamUtils.safeClose((Closeable)stream);
        }
    }
}

