/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crtcore;

import java.util.Objects;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.utils.ProxySystemSetting;

@SdkPublicApi
public abstract class CrtProxyConfiguration {
    private static final String HTTPS = "https";
    private final String scheme;
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private final Boolean useSystemPropertyValues;

    protected CrtProxyConfiguration(DefaultBuilder<?> builder) {
        this.useSystemPropertyValues = ((DefaultBuilder)builder).useSystemPropertyValues;
        this.scheme = ((DefaultBuilder)builder).scheme;
        this.host = this.resolveHost(((DefaultBuilder)builder).host);
        this.port = this.resolvePort(((DefaultBuilder)builder).port);
        this.username = ((DefaultBuilder)builder).username;
        this.password = ((DefaultBuilder)builder).password;
    }

    public final String scheme() {
        return this.scheme;
    }

    public final String host() {
        return this.host;
    }

    public final int port() {
        return this.port;
    }

    public final String username() {
        if (Objects.equals(this.scheme(), HTTPS)) {
            return this.resolveValue(this.username, ProxySystemSetting.HTTPS_PROXY_USERNAME);
        }
        return this.resolveValue(this.username, ProxySystemSetting.PROXY_USERNAME);
    }

    public final String password() {
        if (Objects.equals(this.scheme(), HTTPS)) {
            return this.resolveValue(this.password, ProxySystemSetting.HTTPS_PROXY_PASSWORD);
        }
        return this.resolveValue(this.password, ProxySystemSetting.PROXY_PASSWORD);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CrtProxyConfiguration that = (CrtProxyConfiguration)o;
        if (this.port != that.port) {
            return false;
        }
        if (!Objects.equals(this.scheme, that.scheme)) {
            return false;
        }
        if (!Objects.equals(this.host, that.host)) {
            return false;
        }
        if (!Objects.equals(this.username, that.username)) {
            return false;
        }
        if (!Objects.equals(this.password, that.password)) {
            return false;
        }
        return Objects.equals(this.useSystemPropertyValues, that.useSystemPropertyValues);
    }

    public int hashCode() {
        int result = this.scheme != null ? this.scheme.hashCode() : 0;
        result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
        result = 31 * result + this.port;
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.useSystemPropertyValues != null ? this.useSystemPropertyValues.hashCode() : 0);
        return result;
    }

    private String resolveHost(String host) {
        if (Objects.equals(this.scheme(), HTTPS)) {
            return this.resolveValue(host, ProxySystemSetting.HTTPS_PROXY_HOST);
        }
        return this.resolveValue(host, ProxySystemSetting.PROXY_HOST);
    }

    private int resolvePort(int port) {
        if (port == 0 && Boolean.TRUE.equals(this.useSystemPropertyValues)) {
            if (Objects.equals(this.scheme(), HTTPS)) {
                return ProxySystemSetting.HTTPS_PROXY_PORT.getStringValue().map(Integer::parseInt).orElse(0);
            }
            return ProxySystemSetting.PROXY_PORT.getStringValue().map(Integer::parseInt).orElse(0);
        }
        return port;
    }

    private String resolveValue(String value, ProxySystemSetting systemSetting) {
        return value == null && Boolean.TRUE.equals(this.useSystemPropertyValues) ? (String)systemSetting.getStringValue().orElse(null) : value;
    }

    protected static abstract class DefaultBuilder<B extends Builder>
    implements Builder {
        private String scheme;
        private String host;
        private int port = 0;
        private String username;
        private String password;
        private Boolean useSystemPropertyValues = Boolean.TRUE;

        protected DefaultBuilder() {
        }

        protected DefaultBuilder(CrtProxyConfiguration proxyConfiguration) {
            this.useSystemPropertyValues = proxyConfiguration.useSystemPropertyValues;
            this.scheme = proxyConfiguration.scheme;
            this.host = proxyConfiguration.host;
            this.port = proxyConfiguration.port;
            this.username = proxyConfiguration.username;
            this.password = proxyConfiguration.password;
        }

        public B scheme(String scheme) {
            this.scheme = scheme;
            return (B)this;
        }

        public B host(String host) {
            this.host = host;
            return (B)this;
        }

        public B port(int port) {
            this.port = port;
            return (B)this;
        }

        public B username(String username) {
            this.username = username;
            return (B)this;
        }

        public B password(String password) {
            this.password = password;
            return (B)this;
        }

        public B useSystemPropertyValues(Boolean useSystemPropertyValues) {
            this.useSystemPropertyValues = useSystemPropertyValues;
            return (B)this;
        }

        public void setUseSystemPropertyValues(Boolean useSystemPropertyValues) {
            this.useSystemPropertyValues(useSystemPropertyValues);
        }
    }

    public static interface Builder {
        public Builder host(String var1);

        public Builder port(int var1);

        public Builder scheme(String var1);

        public Builder username(String var1);

        public Builder password(String var1);

        public Builder useSystemPropertyValues(Boolean var1);

        public CrtProxyConfiguration build();
    }
}

