/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron.oidc;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.Feature;
import org.jboss.as.controller.PersistentResourceXMLDescription;
import org.jboss.as.controller.PersistentSubsystemSchema;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SubsystemSchema;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.xml.VersionedFeature;
import org.jboss.as.controller.xml.VersionedNamespace;
import org.jboss.as.version.Stability;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.IntVersion;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.extension.elytron.oidc.CredentialDefinition;
import org.wildfly.extension.elytron.oidc.ElytronOidcSubsystemDefinition;
import org.wildfly.extension.elytron.oidc.ProviderAttributeDefinitions;
import org.wildfly.extension.elytron.oidc.ProviderDefinition;
import org.wildfly.extension.elytron.oidc.RealmDefinition;
import org.wildfly.extension.elytron.oidc.RedirectRewriteRuleDefinition;
import org.wildfly.extension.elytron.oidc.SecureDeploymentDefinition;
import org.wildfly.extension.elytron.oidc.SecureServerDefinition;

public enum ElytronOidcSubsystemSchema implements PersistentSubsystemSchema<ElytronOidcSubsystemSchema>
{
    VERSION_1_0(1, Stability.DEFAULT),
    VERSION_2_0(2, Stability.DEFAULT),
    VERSION_2_0_PREVIEW(2, 0, Stability.PREVIEW);

    static final Map<Stability, ElytronOidcSubsystemSchema> CURRENT;
    private static final AttributeParser SIMPLE_ATTRIBUTE_PARSER;
    private static final AttributeMarshaller SIMPLE_ATTRIBUTE_MARSHALLER;
    private final VersionedNamespace<IntVersion, ElytronOidcSubsystemSchema> namespace;

    private ElytronOidcSubsystemSchema(int major, Stability stability) {
        this.namespace = SubsystemSchema.createSubsystemURN((String)"elytron-oidc-client", (Stability)stability, (IntVersion)new IntVersion(new int[]{major}));
    }

    private ElytronOidcSubsystemSchema(int major, int minor, Stability stability) {
        this.namespace = SubsystemSchema.createSubsystemURN((String)"elytron-oidc-client", (Stability)stability, (IntVersion)new IntVersion(new int[]{major, minor}));
    }

    public VersionedNamespace<IntVersion, ElytronOidcSubsystemSchema> getNamespace() {
        return this.namespace;
    }

    public PersistentResourceXMLDescription getXMLDescription() {
        PersistentResourceXMLDescription.Factory factory = PersistentResourceXMLDescription.factory((PersistentSubsystemSchema)this);
        PersistentResourceXMLDescription.Builder elytronOidcClientBuilder = factory.builder(ElytronOidcSubsystemDefinition.PATH);
        PersistentResourceXMLDescription.Builder realmDefinitionBuilder = factory.builder(RealmDefinition.PATH);
        PersistentResourceXMLDescription.Builder providerDefinitionBuilder = factory.builder(ProviderDefinition.PATH);
        PersistentResourceXMLDescription.Builder secureServerDefinitionBuilder = factory.builder(SecureServerDefinition.PATH);
        PersistentResourceXMLDescription.Builder credentialDefinitionBuilder = factory.builder(CredentialDefinition.PATH);
        PersistentResourceXMLDescription.Builder redirectRewriteRuleDefinitionBuilder = factory.builder(RedirectRewriteRuleDefinition.PATH);
        PersistentResourceXMLDescription.Builder secureDeploymentDefinitionBuilder = factory.builder(SecureDeploymentDefinition.PATH);
        SimpleAttributeDefinition[] secureDeploymentDefaultAttributes = new SimpleAttributeDefinition[]{SecureDeploymentDefinition.ADAPTER_STATE_COOKIE_PATH, SecureDeploymentDefinition.BEARER_ONLY, SecureDeploymentDefinition.CLIENT_ID, SecureDeploymentDefinition.ENABLE_BASIC_AUTH, SecureDeploymentDefinition.MIN_TIME_BETWEEN_JWKS_REQUESTS, SecureDeploymentDefinition.PROVIDER, SecureDeploymentDefinition.PUBLIC_CLIENT, SecureDeploymentDefinition.PUBLIC_KEY_CACHE_TTL, SecureDeploymentDefinition.REALM, SecureDeploymentDefinition.RESOURCE, SecureDeploymentDefinition.TOKEN_MINIMUM_TIME_TO_LIVE, SecureDeploymentDefinition.TURN_OFF_CHANGE_SESSION_ID_ON_LOGIN, SecureDeploymentDefinition.USE_RESOURCE_ROLE_MAPPINGS};
        redirectRewriteRuleDefinitionBuilder.addAttribute((AttributeDefinition)RedirectRewriteRuleDefinition.REPLACEMENT, SIMPLE_ATTRIBUTE_PARSER, SIMPLE_ATTRIBUTE_MARSHALLER);
        Stream.of(CredentialDefinition.ATTRIBUTES).forEach(attribute -> credentialDefinitionBuilder.addAttribute((AttributeDefinition)attribute, SIMPLE_ATTRIBUTE_PARSER, SIMPLE_ATTRIBUTE_MARSHALLER));
        Stream.of(ProviderAttributeDefinitions.ATTRIBUTES).forEach(attribute -> realmDefinitionBuilder.addAttribute((AttributeDefinition)attribute, SIMPLE_ATTRIBUTE_PARSER, SIMPLE_ATTRIBUTE_MARSHALLER));
        Stream.of(ProviderAttributeDefinitions.ATTRIBUTES).forEach(attribute -> providerDefinitionBuilder.addAttribute((AttributeDefinition)attribute, SIMPLE_ATTRIBUTE_PARSER, SIMPLE_ATTRIBUTE_MARSHALLER));
        Stream.of(secureDeploymentDefaultAttributes).forEach(attribute -> secureDeploymentDefinitionBuilder.addAttribute((AttributeDefinition)attribute, SIMPLE_ATTRIBUTE_PARSER, SIMPLE_ATTRIBUTE_MARSHALLER));
        Stream.of(secureDeploymentDefaultAttributes).forEach(attribute -> secureServerDefinitionBuilder.addAttribute((AttributeDefinition)attribute, SIMPLE_ATTRIBUTE_PARSER, SIMPLE_ATTRIBUTE_MARSHALLER));
        Stream.of(ProviderAttributeDefinitions.ATTRIBUTES).forEach(attribute -> secureDeploymentDefinitionBuilder.addAttribute((AttributeDefinition)attribute, SIMPLE_ATTRIBUTE_PARSER, SIMPLE_ATTRIBUTE_MARSHALLER));
        Stream.of(ProviderAttributeDefinitions.ATTRIBUTES).forEach(attribute -> secureServerDefinitionBuilder.addAttribute((AttributeDefinition)attribute, SIMPLE_ATTRIBUTE_PARSER, SIMPLE_ATTRIBUTE_MARSHALLER));
        if (this.since((VersionedFeature)VERSION_2_0_PREVIEW) && this.enables((Feature)SecureDeploymentDefinition.SCOPE)) {
            secureDeploymentDefinitionBuilder.addAttribute((AttributeDefinition)SecureDeploymentDefinition.SCOPE, SIMPLE_ATTRIBUTE_PARSER, SIMPLE_ATTRIBUTE_MARSHALLER);
            secureServerDefinitionBuilder.addAttribute((AttributeDefinition)SecureDeploymentDefinition.SCOPE, SIMPLE_ATTRIBUTE_PARSER, SIMPLE_ATTRIBUTE_MARSHALLER);
        }
        elytronOidcClientBuilder.addChild(realmDefinitionBuilder.build()).addChild(providerDefinitionBuilder.build());
        elytronOidcClientBuilder.addChild(secureDeploymentDefinitionBuilder.addChild(credentialDefinitionBuilder.build()).addChild(redirectRewriteRuleDefinitionBuilder.build()).build());
        if (this.since((VersionedFeature)VERSION_2_0)) {
            elytronOidcClientBuilder.addChild(secureServerDefinitionBuilder.addChild(credentialDefinitionBuilder.build()).addChild(redirectRewriteRuleDefinitionBuilder.build()).build());
        }
        return elytronOidcClientBuilder.build();
    }

    static {
        CURRENT = Feature.map(EnumSet.of(VERSION_2_0_PREVIEW, VERSION_2_0));
        SIMPLE_ATTRIBUTE_PARSER = new AttributeElementParser();
        SIMPLE_ATTRIBUTE_MARSHALLER = new AttributeElementMarshaller();
    }

    static class AttributeElementParser
    extends AttributeParser {
        AttributeElementParser() {
        }

        public boolean isParseAsElement() {
            return true;
        }

        public void parseElement(AttributeDefinition attribute, XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
            assert (attribute instanceof SimpleAttributeDefinition);
            if (operation.hasDefined(attribute.getName())) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            if (!attribute.getXmlName().equals(reader.getLocalName())) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader, Collections.singleton(attribute.getXmlName()));
            }
            ((SimpleAttributeDefinition)attribute).parseAndSetParameter(reader.getElementText(), operation, (XMLStreamReader)reader);
        }
    }

    static class AttributeElementMarshaller
    extends AttributeMarshaller.AttributeElementMarshaller {
        AttributeElementMarshaller() {
        }

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            writer.writeStartElement(attribute.getXmlName());
            AttributeElementMarshaller.marshallElementContent((String)resourceModel.get(attribute.getName()).asString(), (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
    }
}

