/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public abstract class RestartParentResourceHandlerBase
implements OperationStepHandler {
    private final String parentKeyName;

    protected RestartParentResourceHandlerBase(String parentKeyName) {
        this.parentKeyName = parentKeyName;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.updateModel(context, operation);
        if (!context.isBooting() && this.requiresRuntime(context)) {
            context.addStep(new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ModelNode parentModel;
                    PathAddress address = RestartParentResourceHandlerBase.this.getParentAddress(context.getCurrentAddress());
                    final ServiceName serviceName = RestartParentResourceHandlerBase.this.getParentServiceName(address);
                    ServiceController service = serviceName != null ? context.getServiceRegistry(false).getService(serviceName) : null;
                    boolean servicesRestarted = false;
                    final boolean reloadRequired = service != null && !RestartParentResourceHandlerBase.this.isResourceServiceRestartAllowed(context, service);
                    ModelNode modelNode = parentModel = reloadRequired || service != null ? RestartParentResourceHandlerBase.this.getModel(context, address) : null;
                    if (reloadRequired) {
                        if (parentModel != null) {
                            context.reloadRequired();
                        }
                    } else if (service != null && parentModel != null && context.markResourceRestarted(address, RestartParentResourceHandlerBase.this)) {
                        context.addStep(Util.getReadResourceOperation(address), new OperationStepHandler(){

                            @Override
                            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                                RestartParentResourceHandlerBase.this.removeServices(context, serviceName, parentModel);
                                RestartParentResourceHandlerBase.this.recreateParentService(context, parentModel);
                            }
                        }, OperationContext.Stage.RUNTIME, true);
                        servicesRestarted = true;
                    }
                    final ModelNode invalidatedParentModel = servicesRestarted ? parentModel : null;
                    context.completeStep(new OperationContext.RollbackHandler(){

                        @Override
                        public void handleRollback(OperationContext context, ModelNode operation) {
                            Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
                            RestartParentResourceHandlerBase.this.rollbackRuntime(context, operation, resource);
                            if (reloadRequired) {
                                context.revertReloadRequired();
                            } else if (invalidatedParentModel != null) {
                                RestartParentResourceHandlerBase.this.recoverServices(context, invalidatedParentModel);
                            }
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    protected boolean requiresRuntime(OperationContext context) {
        return !context.getProcessType().isHostController();
    }

    protected boolean isResourceServiceRestartAllowed(OperationContext context, ServiceController<?> service) {
        return context.isResourceServiceRestartAllowed();
    }

    protected void removeServices(OperationContext context, ServiceName parentService, ModelNode parentModel) throws OperationFailedException {
        context.removeService(parentService);
    }

    protected abstract void updateModel(OperationContext var1, ModelNode var2) throws OperationFailedException;

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
    }

    protected void recreateParentService(OperationContext context, ModelNode parentModel) throws OperationFailedException {
        this.recreateParentService(context, context.getCurrentAddress(), parentModel);
    }

    @Deprecated(forRemoval=true)
    protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
    }

    protected abstract ServiceName getParentServiceName(PathAddress var1);

    protected PathAddress getParentAddress(PathAddress address) {
        return Util.getParentAddressByKey(address, this.parentKeyName);
    }

    private void recoverServices(OperationContext context, final ModelNode invalidatedParentModel) {
        PathAddress address = this.getParentAddress(context.getCurrentAddress());
        final ServiceName serviceName = this.getParentServiceName(address);
        final ModelNode parentModel = this.getOriginalModel(context, address);
        if (parentModel != null && context.revertResourceRestarted(address, this)) {
            context.addStep(Util.getReadResourceOperation(address), new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    RestartParentResourceHandlerBase.this.removeServices(context, serviceName, invalidatedParentModel);
                    RestartParentResourceHandlerBase.this.recreateParentService(context, parentModel);
                }
            }, OperationContext.Stage.RUNTIME, true);
        }
    }

    private ModelNode getModel(OperationContext ctx, PathAddress address) {
        try {
            Resource resource = ctx.readResourceFromRoot(address);
            return Resource.Tools.readModel(resource);
        }
        catch (Resource.NoSuchResourceException e) {
            return null;
        }
    }

    private ModelNode getOriginalModel(OperationContext ctx, PathAddress address) {
        try {
            Resource resource = ctx.getOriginalRootResource().navigate(address);
            return Resource.Tools.readModel(resource);
        }
        catch (Resource.NoSuchResourceException e) {
            return null;
        }
    }
}

