/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.msc.service.ServiceName;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;
import org.wildfly.service.descriptor.QuaternaryServiceDescriptor;
import org.wildfly.service.descriptor.TernaryServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;

public final class ServiceNameFactory {
    private static final Map<ServiceName, ServiceName> cache = new ConcurrentHashMap<ServiceName, ServiceName>();

    public static ServiceName parseServiceName(String toParse) {
        ServiceName original = ServiceName.parse((String)toParse);
        int length = original.length();
        ServiceName[] ancestry = new ServiceName[length];
        ServiceName sn = original;
        for (int i = length - 1; i >= 0; --i) {
            ancestry[i] = sn;
            sn = sn.getParent();
        }
        int max = length > 4 ? length - 1 : length;
        for (int i = 0; i < max; ++i) {
            ServiceName interned = cache.putIfAbsent(ancestry[i], ancestry[i]);
            if (interned == null || ancestry[i] == interned) continue;
            ServiceName parent = ancestry[i] = interned;
            boolean checkCache = true;
            for (int j = i + 1; j < length; ++j) {
                parent = parent.append(new String[]{ancestry[j].getSimpleName()});
                if (checkCache && j < max) {
                    ServiceName cached = cache.get(parent);
                    if (cached != null) {
                        parent = cached;
                        i = j;
                    } else {
                        checkCache = false;
                    }
                }
                ancestry[j] = parent;
            }
        }
        return ancestry[length - 1];
    }

    public static ServiceName resolveServiceName(NullaryServiceDescriptor<?> descriptor) {
        return ServiceNameFactory.parseServiceName(descriptor.getName());
    }

    public static ServiceName resolveServiceName(UnaryServiceDescriptor<?> descriptor, String name) {
        return ServiceNameFactory.parseServiceName(descriptor.resolve(name));
    }

    public static ServiceName resolveServiceName(BinaryServiceDescriptor<?> descriptor, String parent, String child) {
        return ServiceNameFactory.parseServiceName(descriptor.resolve(parent, child));
    }

    public static ServiceName resolveServiceName(TernaryServiceDescriptor<?> descriptor, String grandparent, String parent, String child) {
        return ServiceNameFactory.parseServiceName(descriptor.resolve(grandparent, parent, child));
    }

    public static ServiceName resolveServiceName(QuaternaryServiceDescriptor<?> descriptor, String ancestor, String grandparent, String parent, String child) {
        return ServiceNameFactory.parseServiceName(descriptor.resolve(ancestor, grandparent, parent, child));
    }

    private static ServiceName parseServiceName(Map.Entry<String, String[]> resolved) {
        return ServiceNameFactory.parseServiceName(resolved.getKey()).append(resolved.getValue());
    }

    static void clearCache() {
        cache.clear();
    }
}

