/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access.constraint;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.HostEffect;
import org.jboss.as.controller.access.JmxAction;
import org.jboss.as.controller.access.JmxTarget;
import org.jboss.as.controller.access.ServerGroupEffect;
import org.jboss.as.controller.access.TargetAttribute;
import org.jboss.as.controller.access.TargetResource;
import org.jboss.as.controller.access.constraint.AbstractConstraint;
import org.jboss.as.controller.access.constraint.AbstractConstraintFactory;
import org.jboss.as.controller.access.constraint.Constraint;
import org.jboss.as.controller.access.constraint.ScopingConstraint;
import org.jboss.as.controller.access.constraint.ScopingConstraintFactory;
import org.jboss.as.controller.access.rbac.StandardRole;
import org.jboss.as.controller.logging.ControllerLogger;

public class ServerGroupEffectConstraint
extends AbstractConstraint
implements Constraint,
ScopingConstraint {
    public static final ScopingConstraintFactory FACTORY = new Factory();
    private static final ServerGroupEffectConstraint GLOBAL_USER = new ServerGroupEffectConstraint(true, false);
    private static final ServerGroupEffectConstraint DOMAIN_GLOBAL_REQUIRED = new ServerGroupEffectConstraint(false, false);
    private static final ServerGroupEffectConstraint HOST_GLOBAL_REQUIRED = new ServerGroupEffectConstraint(false, true);
    private static final ServerGroupEffectConstraint UNASSIGNED = new ServerGroupEffectConstraint();
    private final boolean user;
    private final boolean global;
    private final boolean nonServerHost;
    private final boolean unassigned;
    private final GroupsHolder groupsHolder;
    private final boolean readOnly;
    private final boolean groupAdd;
    private final boolean groupRemove;
    private final ServerGroupEffectConstraint readOnlyConstraint;

    private ServerGroupEffectConstraint() {
        this.user = false;
        this.global = false;
        this.nonServerHost = false;
        this.unassigned = true;
        this.readOnly = false;
        this.readOnlyConstraint = null;
        this.groupAdd = false;
        this.groupRemove = false;
        this.groupsHolder = new GroupsHolder();
    }

    private ServerGroupEffectConstraint(boolean user, boolean nonServerHost) {
        this.user = user;
        this.global = true;
        this.nonServerHost = nonServerHost;
        this.unassigned = false;
        this.readOnly = false;
        this.readOnlyConstraint = null;
        this.groupAdd = false;
        this.groupRemove = false;
        this.groupsHolder = new GroupsHolder();
    }

    private ServerGroupEffectConstraint(Set<String> allowed, boolean nonServerHost, boolean groupAdd, boolean groupRemove) {
        this.user = false;
        this.global = false;
        this.nonServerHost = nonServerHost;
        this.unassigned = false;
        this.groupsHolder = new GroupsHolder(allowed);
        this.readOnly = false;
        this.groupAdd = groupAdd;
        this.groupRemove = groupRemove;
        this.readOnlyConstraint = null;
    }

    public ServerGroupEffectConstraint(List<String> allowed) {
        this.user = true;
        this.global = false;
        this.nonServerHost = false;
        this.unassigned = false;
        this.groupsHolder = new GroupsHolder(allowed);
        this.readOnly = false;
        this.groupAdd = false;
        this.groupRemove = false;
        this.readOnlyConstraint = new ServerGroupEffectConstraint(this.groupsHolder);
    }

    private ServerGroupEffectConstraint(GroupsHolder groupsHolder) {
        this.user = true;
        this.global = false;
        this.nonServerHost = false;
        this.unassigned = false;
        this.groupsHolder = groupsHolder;
        this.readOnly = true;
        this.groupAdd = false;
        this.groupRemove = false;
        this.readOnlyConstraint = null;
    }

    public void setAllowedGroups(List<String> allowed) {
        assert (!this.global) : "constraint is global";
        assert (this.readOnlyConstraint != null) : "invalid cast";
        this.groupsHolder.specific = new LinkedHashSet<String>(allowed);
    }

    @Override
    public boolean violates(Constraint other, Action.ActionEffect actionEffect) {
        if (other instanceof ServerGroupEffectConstraint) {
            ServerGroupEffectConstraint sgec = (ServerGroupEffectConstraint)other;
            Set<String> ourSpecific = this.groupsHolder.specific;
            Set<String> sgecSpecific = sgec.groupsHolder.specific;
            if (this.user) {
                assert (!sgec.user) : "illegal comparison";
                if (this.readOnly) {
                    if (!sgec.global && !sgec.nonServerHost) {
                        boolean anyMatch = this.anyMatch(ourSpecific, sgecSpecific);
                        if (!anyMatch) {
                            ControllerLogger.ACCESS_LOGGER.tracef("read-only server-group constraint violated for action %s due to no match between groups %s and allowed groups %s", (Object)actionEffect, sgecSpecific, ourSpecific);
                        }
                        return !anyMatch;
                    }
                } else if (!this.global) {
                    if (sgec.global) {
                        ControllerLogger.ACCESS_LOGGER.tracef("server-group constraint violated for action %s due to requirement for access to global resources", (Object)actionEffect);
                        return true;
                    }
                    if (!sgec.unassigned) {
                        if (actionEffect == Action.ActionEffect.WRITE_RUNTIME || actionEffect == Action.ActionEffect.WRITE_CONFIG) {
                            boolean containsAll = ourSpecific.containsAll(sgecSpecific);
                            if (!containsAll) {
                                ControllerLogger.ACCESS_LOGGER.tracef("server-group constraint violated for action %s due to mismatch of groups %s vs allowed %s", (Object)actionEffect, sgecSpecific, ourSpecific);
                            } else if (sgec.groupAdd) {
                                ControllerLogger.ACCESS_LOGGER.tracef("server-group constraint violated for action %s due to attempt to add the server group", (Object)actionEffect);
                            } else if (sgec.groupRemove) {
                                ControllerLogger.ACCESS_LOGGER.tracef("server-group constraint violated for action %s due to attempt to remove the server group", (Object)actionEffect);
                            }
                            return !containsAll || sgec.groupAdd || sgec.groupRemove;
                        }
                        boolean anyMatch = this.anyMatch(ourSpecific, sgecSpecific);
                        if (!anyMatch) {
                            if (sgec.groupAdd && actionEffect == Action.ActionEffect.ADDRESS) {
                                return false;
                            }
                            ControllerLogger.ACCESS_LOGGER.tracef("server-group constraint violated for action %s due to no match between groups %s and allowed groups %s", (Object)actionEffect, sgecSpecific, ourSpecific);
                        }
                        return !anyMatch;
                    }
                }
            } else {
                assert (sgec.user) : "illegal comparison";
                return other.violates(this, actionEffect);
            }
        }
        return false;
    }

    private boolean anyMatch(Set<String> ourSpecific, Set<String> sgecSpecific) {
        boolean matched = false;
        for (String ourGroup : ourSpecific) {
            if (!sgecSpecific.contains(ourGroup)) continue;
            matched = true;
            break;
        }
        if (!matched) {
            matched = sgecSpecific.size() == 1 && sgecSpecific.contains("*");
        }
        return matched;
    }

    @Override
    public boolean replaces(Constraint other) {
        return other instanceof ServerGroupEffectConstraint && (this.readOnly || this.readOnlyConstraint != null);
    }

    @Override
    public ScopingConstraintFactory getFactory() {
        assert (this.readOnlyConstraint != null) : "invalid cast";
        return FACTORY;
    }

    @Override
    public Constraint getStandardConstraint() {
        assert (this.readOnlyConstraint != null) : "invalid cast";
        return this;
    }

    @Override
    public Constraint getOutofScopeReadConstraint() {
        assert (this.readOnlyConstraint != null) : "invalid cast";
        return this.readOnlyConstraint;
    }

    private static class Factory
    extends AbstractConstraintFactory
    implements ScopingConstraintFactory {
        private Factory() {
        }

        @Override
        public Constraint getStandardUserConstraint(StandardRole role, Action.ActionEffect actionEffect) {
            return GLOBAL_USER;
        }

        @Override
        public Constraint getRequiredConstraint(Action.ActionEffect actionEffect, Action action, TargetAttribute target) {
            return this.getRequiredConstraint(target.getServerGroupEffect(), target.getHostEffect());
        }

        @Override
        public Constraint getRequiredConstraint(Action.ActionEffect actionEffect, Action action, TargetResource target) {
            return this.getRequiredConstraint(target.getServerGroupEffect(), target.getHostEffect());
        }

        @Override
        public Constraint getRequiredConstraint(Action.ActionEffect actionEffect, JmxAction action, JmxTarget target) {
            return this.getRequiredConstraint(target.getServerGroupEffect(), target.getHostEffect());
        }

        private Constraint getRequiredConstraint(ServerGroupEffect serverGroupEffect, HostEffect hostEffect) {
            boolean nonServerHost;
            boolean bl = nonServerHost = hostEffect != null && !hostEffect.isHostEffectGlobal() && !hostEffect.isServerEffect();
            if (serverGroupEffect == null || serverGroupEffect.isServerGroupEffectGlobal()) {
                if (nonServerHost) {
                    return HOST_GLOBAL_REQUIRED;
                }
                return DOMAIN_GLOBAL_REQUIRED;
            }
            if (serverGroupEffect.isServerGroupEffectUnassigned()) {
                return UNASSIGNED;
            }
            return new ServerGroupEffectConstraint(serverGroupEffect.getAffectedServerGroups(), nonServerHost, serverGroupEffect.isServerGroupAdd(), serverGroupEffect.isServerGroupRemove());
        }

        @Override
        protected int internalCompare(AbstractConstraintFactory other) {
            return this.equals(other) ? 0 : -1;
        }
    }

    private static class GroupsHolder {
        private volatile Set<String> specific = new LinkedHashSet<String>();

        private GroupsHolder() {
        }

        private GroupsHolder(Collection<String> groups) {
            this.specific.addAll(groups);
        }
    }
}

