/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.global;

import java.util.Set;
import java.util.TreeSet;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.global.GlobalOperationAttributes;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ReadChildrenTypesHandler
implements OperationStepHandler {
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("read-children-types", ControllerResolver.getResolver("global")).setParameters(GlobalOperationAttributes.INCLUDE_ALIASES, GlobalOperationAttributes.INCLUDE_SINGLETONS).setReadOnly().setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).build();
    public static final OperationStepHandler INSTANCE = new ReadChildrenTypesHandler();

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ImmutableManagementResourceRegistration registry = context.getResourceRegistration();
        if (registry == null) {
            throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.noSuchResourceType(context.getCurrentAddress()));
        }
        boolean aliases = GlobalOperationAttributes.INCLUDE_ALIASES.resolveModelAttribute(context, operation).asBoolean(false);
        boolean singletons = GlobalOperationAttributes.INCLUDE_SINGLETONS.resolveModelAttribute(context, operation).asBoolean(false);
        Set<PathElement> childTypes = registry.getChildAddresses(PathAddress.EMPTY_ADDRESS);
        TreeSet<Object> children = new TreeSet<Object>();
        for (PathElement child : childTypes) {
            boolean isSingletonResource;
            PathAddress pathAddress = PathAddress.pathAddress(child);
            ImmutableManagementResourceRegistration childReg = registry.getSubModel(pathAddress);
            boolean bl = isSingletonResource = childReg == null || !child.isWildcard();
            if (childReg != null && childReg.isAlias() && !aliases) continue;
            if (singletons && isSingletonResource) {
                children.add(child.getKey() + "=" + child.getValue());
                continue;
            }
            children.add(child.getKey());
        }
        ModelNode result = context.getResult();
        result.setEmptyList();
        for (String string : children) {
            result.add(string);
        }
    }
}

