/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.docvalues.impl;

import java.io.IOException;
import org.apache.lucene.index.SortedNumericDocValues;

public abstract class LongMultiValues {
    public static final LongMultiValues EMPTY = new LongMultiValues(){

        @Override
        public boolean advanceExact(int doc) {
            return false;
        }

        @Override
        public boolean hasNextValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long nextValue() {
            throw new UnsupportedOperationException();
        }
    };

    protected LongMultiValues() {
    }

    public abstract boolean advanceExact(int var1) throws IOException;

    public abstract boolean hasNextValue() throws IOException;

    public abstract long nextValue() throws IOException;

    public static LongMultiValues fromDocValues(SortedNumericDocValues docValues) {
        return new DocValuesLongMultiValues(docValues);
    }

    protected static class DocValuesLongMultiValues
    extends LongMultiValues {
        private final SortedNumericDocValues values;
        private int remaining;

        DocValuesLongMultiValues(SortedNumericDocValues values) {
            this.values = values;
        }

        @Override
        public boolean advanceExact(int doc) throws IOException {
            boolean found = this.values.advanceExact(doc);
            this.updateRemaining(found);
            return found;
        }

        protected final void updateRemaining(boolean hasDocValue) {
            this.remaining = hasDocValue ? this.values.docValueCount() : 0;
        }

        @Override
        public boolean hasNextValue() throws IOException {
            return this.remaining > 0;
        }

        @Override
        public long nextValue() throws IOException {
            --this.remaining;
            return this.values.nextValue();
        }
    }
}

