/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.QueryBitSetProducer;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.lucene.search.join.ToParentBlockJoinQuery;
import org.hibernate.search.backend.lucene.lowlevel.query.impl.Queries;
import org.hibernate.search.backend.lucene.search.common.impl.AbstractLuceneCompositeNodeSearchQueryElementFactory;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexCompositeNodeContext;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneSingleFieldPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.NestedPredicateBuilder;

public class LuceneNestedPredicate
extends AbstractLuceneSingleFieldPredicate {
    private final LuceneSearchPredicate nestedPredicate;

    private LuceneNestedPredicate(Builder builder) {
        super(builder);
        this.nestedPredicate = builder.nestedPredicate;
    }

    @Override
    protected Query doToQuery(PredicateRequestContext context) {
        PredicateRequestContext childContext = context.withNestedPath(this.absoluteFieldPath);
        return LuceneNestedPredicate.createNestedQuery(context.getNestedPath(), this.absoluteFieldPath, this.nestedPredicate.toQuery(childContext));
    }

    public static Query createNestedQuery(String parentNestedDocumentPath, String nestedDocumentPath, Query nestedQuery) {
        if (nestedDocumentPath.equals(parentNestedDocumentPath)) {
            return nestedQuery;
        }
        BooleanQuery.Builder childQueryBuilder = new BooleanQuery.Builder();
        childQueryBuilder.add(Queries.childDocumentQuery(), BooleanClause.Occur.FILTER);
        childQueryBuilder.add(Queries.nestedDocumentPathQuery(nestedDocumentPath), BooleanClause.Occur.FILTER);
        childQueryBuilder.add(nestedQuery, BooleanClause.Occur.MUST);
        QueryBitSetProducer parentFilter = new QueryBitSetProducer(Queries.parentsFilterQuery(parentNestedDocumentPath));
        return new ToParentBlockJoinQuery((Query)childQueryBuilder.build(), (BitSetProducer)parentFilter, ScoreMode.Avg);
    }

    private static class Builder
    extends AbstractLuceneSingleFieldPredicate.AbstractBuilder
    implements NestedPredicateBuilder {
        private LuceneSearchPredicate nestedPredicate;

        Builder(LuceneSearchIndexScope<?> scope, LuceneSearchIndexCompositeNodeContext node) {
            super(scope, node.absolutePath(), node.nestedPathHierarchy().subList(0, node.nestedPathHierarchy().size() - 1));
        }

        public void nested(SearchPredicate nestedPredicate) {
            LuceneSearchPredicate luceneNestedPredicate = LuceneSearchPredicate.from(this.scope, nestedPredicate);
            luceneNestedPredicate.checkNestableWithin(this.absoluteFieldPath);
            this.nestedPredicate = luceneNestedPredicate;
        }

        public SearchPredicate build() {
            return new LuceneNestedPredicate(this);
        }
    }

    public static class Factory
    extends AbstractLuceneCompositeNodeSearchQueryElementFactory<NestedPredicateBuilder> {
        public static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        public NestedPredicateBuilder create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexCompositeNodeContext node) {
            return new Builder(scope, node);
        }
    }
}

