/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.predicate.parse.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.AnalyzerConstants;

public class LuceneWildcardExpressionHelper {
    private static final Pattern WILDCARD_PATTERN = Pattern.compile("(\\\\.)|([?*]+)");

    private LuceneWildcardExpressionHelper() {
    }

    public static BytesRef analyzeWildcard(Analyzer analyzer, String field, String termStr) {
        BytesRef normalized;
        String chunk;
        if (analyzer == AnalyzerConstants.KEYWORD_ANALYZER) {
            return new BytesRef((CharSequence)termStr);
        }
        Matcher wildcardMatcher = WILDCARD_PATTERN.matcher(termStr);
        BytesRefBuilder sb = new BytesRefBuilder();
        int last = 0;
        while (wildcardMatcher.find()) {
            if (wildcardMatcher.start() > 0) {
                chunk = termStr.substring(last, wildcardMatcher.start());
                normalized = analyzer.normalize(field, chunk);
                sb.append(normalized);
            }
            sb.append(new BytesRef((CharSequence)wildcardMatcher.group()));
            last = wildcardMatcher.end();
        }
        if (last < termStr.length()) {
            chunk = termStr.substring(last);
            normalized = analyzer.normalize(field, chunk);
            sb.append(normalized);
        }
        return sb.toBytesRef();
    }
}

