/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.infinispan.commands.functional.functions.InjectableComponent;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.hibernate.cache.commons.InfinispanDataRegion;

public class VersionedEntry
implements Function<EntryView.ReadWriteEntryView<Object, Object>, Void>,
InjectableComponent {
    private static final Log log = LogFactory.getLog(VersionedEntry.class);
    public static final ExcludeEmptyFilter EXCLUDE_EMPTY_VERSIONED_ENTRY = new ExcludeEmptyFilter();
    private final Object value;
    private final Object version;
    private final long timestamp;
    private transient InfinispanDataRegion region;

    public VersionedEntry(long timestamp) {
        this(null, null, timestamp);
    }

    public VersionedEntry(Object value, Object version, long timestamp) {
        this.value = value;
        this.version = version;
        this.timestamp = timestamp;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getVersion() {
        return this.version;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VersionedEntry{");
        sb.append("value=").append(this.value);
        sb.append(", version=").append(this.version);
        sb.append(", timestamp=").append(this.timestamp);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public Void apply(EntryView.ReadWriteEntryView<Object, Object> view) {
        if (log.isTraceEnabled()) {
            log.tracef("Applying %s to %s", (Object)this, view.find().orElse(null));
        }
        if (this.version == null) {
            view.set((Object)this, new MetaParam.Writable[]{this.region.getExpiringMetaParam()});
            return null;
        }
        Object oldValue = view.find().orElse(null);
        Object oldVersion = null;
        long oldTimestamp = Long.MIN_VALUE;
        if (oldValue instanceof VersionedEntry) {
            VersionedEntry oldVersionedEntry = (VersionedEntry)oldValue;
            oldVersion = oldVersionedEntry.version;
            oldTimestamp = oldVersionedEntry.timestamp;
            oldValue = oldVersionedEntry.value;
        } else {
            oldVersion = this.findVersion(oldValue);
        }
        if (oldVersion == null) {
            assert (oldValue == null || oldTimestamp != Long.MIN_VALUE) : oldValue;
            if (this.timestamp <= oldTimestamp) {
                assert (oldValue == null);
            } else {
                view.set(this.value instanceof CacheEntry ? this.value : this, new MetaParam.Writable[0]);
            }
            return null;
        }
        Comparator<Object> versionComparator = null;
        String subclass = this.findSubclass(this.value);
        if (subclass != null && (versionComparator = this.region.getComparator(subclass)) == null) {
            log.errorf("Cannot find comparator for %s", (Object)subclass);
        }
        if (versionComparator == null) {
            view.set((Object)new VersionedEntry(null, null, this.timestamp), new MetaParam.Writable[]{this.region.getExpiringMetaParam()});
        } else {
            int compareResult = versionComparator.compare(this.version, oldVersion);
            if (log.isTraceEnabled()) {
                log.tracef("Comparing %s and %s -> %d (using %s)", new Object[]{this.version, oldVersion, compareResult, versionComparator});
            }
            if (this.value == null && compareResult >= 0) {
                view.set((Object)this, new MetaParam.Writable[]{this.region.getExpiringMetaParam()});
            } else if (compareResult > 0) {
                view.set(this.value instanceof CacheEntry ? this.value : this, new MetaParam.Writable[0]);
            }
        }
        return null;
    }

    private Object findVersion(Object entry) {
        if (entry instanceof CacheEntry) {
            return ((CacheEntry)entry).getVersion();
        }
        if (entry instanceof Map) {
            return ((Map)entry).get("_version");
        }
        return null;
    }

    private String findSubclass(Object entry) {
        if (entry instanceof CacheEntry) {
            return ((CacheEntry)this.value).getSubclass();
        }
        if (entry instanceof Map) {
            Object maybeSubclass = ((Map)entry).get("_subclass");
            return maybeSubclass instanceof String ? (String)maybeSubclass : null;
        }
        return null;
    }

    public void inject(ComponentRegistry registry) {
        this.region = (InfinispanDataRegion)registry.getComponent(InfinispanDataRegion.class);
    }

    private static class ExcludeEmptyFilter
    implements Predicate<Map.Entry<Object, Object>> {
        private ExcludeEmptyFilter() {
        }

        @Override
        public boolean test(Map.Entry<Object, Object> entry) {
            if (entry.getValue() instanceof VersionedEntry) {
                return ((VersionedEntry)entry.getValue()).getValue() != null;
            }
            return true;
        }
    }

    public static class ExcludeEmptyVersionedEntryExternalizer
    implements AdvancedExternalizer<ExcludeEmptyFilter> {
        public Set<Class<? extends ExcludeEmptyFilter>> getTypeClasses() {
            return Collections.singleton(ExcludeEmptyFilter.class);
        }

        public Integer getId() {
            return 1207;
        }

        public void writeObject(ObjectOutput output, ExcludeEmptyFilter object) throws IOException {
        }

        public ExcludeEmptyFilter readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return EXCLUDE_EMPTY_VERSIONED_ENTRY;
        }
    }

    public static class Externalizer
    implements AdvancedExternalizer<VersionedEntry> {
        public Set<Class<? extends VersionedEntry>> getTypeClasses() {
            return Collections.singleton(VersionedEntry.class);
        }

        public Integer getId() {
            return 1206;
        }

        public void writeObject(ObjectOutput output, VersionedEntry object) throws IOException {
            output.writeObject(object.value);
            output.writeObject(object.version);
            output.writeLong(object.timestamp);
        }

        public VersionedEntry readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object value = input.readObject();
            Object version = input.readObject();
            long timestamp = input.readLong();
            return new VersionedEntry(value, version, timestamp);
        }
    }
}

