/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent.handle;

import jakarta.enterprise.concurrent.ContextService;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import org.jboss.as.ee.concurrent.handle.EE10ContextHandleFactory;
import org.jboss.as.ee.concurrent.handle.ResetContextHandle;
import org.jboss.as.ee.concurrent.handle.SetupContextHandle;
import org.jboss.as.ee.logging.EeLogger;
import org.wildfly.transaction.client.ContextTransactionManager;

public class TransactionContextHandleFactory
implements EE10ContextHandleFactory {
    public static final String NAME = "Transaction";

    @Override
    public String getContextType() {
        return NAME;
    }

    @Override
    public SetupContextHandle clearedContext(ContextService contextService, Map<String, String> contextObjectProperties) {
        if (contextObjectProperties != null && "USE_TRANSACTION_OF_EXECUTION_THREAD".equals(contextObjectProperties.get("jakarta.enterprise.concurrent.TRANSACTION"))) {
            return null;
        }
        return new ClearedSetupContextHandle((TransactionManager)ContextTransactionManager.getInstance());
    }

    @Override
    public SetupContextHandle propagatedContext(ContextService contextService, Map<String, String> contextObjectProperties) {
        return this.unchangedContext(contextService, contextObjectProperties);
    }

    @Override
    public SetupContextHandle unchangedContext(ContextService contextService, Map<String, String> contextObjectProperties) {
        if (contextObjectProperties != null && "SUSPEND".equals(contextObjectProperties.get("jakarta.enterprise.concurrent.TRANSACTION"))) {
            return new ClearedSetupContextHandle((TransactionManager)ContextTransactionManager.getInstance());
        }
        return null;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getChainPriority() {
        return 10;
    }

    @Override
    public void writeSetupContextHandle(SetupContextHandle contextHandle, ObjectOutputStream out) throws IOException {
    }

    @Override
    public SetupContextHandle readSetupContextHandle(ObjectInputStream in) throws IOException, ClassNotFoundException {
        return new ClearedSetupContextHandle((TransactionManager)ContextTransactionManager.getInstance());
    }

    private static class ClearedSetupContextHandle
    implements SetupContextHandle {
        private static final long serialVersionUID = 5751959084132309889L;
        private final TransactionManager transactionManager;

        private ClearedSetupContextHandle(TransactionManager transactionManager) {
            this.transactionManager = transactionManager;
        }

        @Override
        public ResetContextHandle setup() throws IllegalStateException {
            Transaction transactionOnSetup = null;
            if (this.transactionManager != null) {
                try {
                    transactionOnSetup = this.transactionManager.suspend();
                }
                catch (SystemException e) {
                    EeLogger.ROOT_LOGGER.failedToSuspendTransaction(e);
                }
            }
            return new ClearedResetContextHandle(this.transactionManager, transactionOnSetup);
        }

        @Override
        public String getFactoryName() {
            return TransactionContextHandleFactory.NAME;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            throw EeLogger.ROOT_LOGGER.serializationMustBeHandledByTheFactory();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw EeLogger.ROOT_LOGGER.serializationMustBeHandledByTheFactory();
        }
    }

    private static class ClearedResetContextHandle
    implements ResetContextHandle {
        private static final long serialVersionUID = 6601621971677254974L;
        private final TransactionManager transactionManager;
        private final Transaction transactionOnSetup;

        private ClearedResetContextHandle(TransactionManager transactionManager, Transaction transactionOnSetup) {
            this.transactionManager = transactionManager;
            this.transactionOnSetup = transactionOnSetup;
        }

        @Override
        public void reset() {
            try {
                this.transactionManager.resume(this.transactionOnSetup);
            }
            catch (Throwable e) {
                EeLogger.ROOT_LOGGER.failedToResumeTransaction(e);
            }
        }

        @Override
        public String getFactoryName() {
            return TransactionContextHandleFactory.NAME;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            throw EeLogger.ROOT_LOGGER.serializationMustBeHandledByTheFactory();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw EeLogger.ROOT_LOGGER.serializationMustBeHandledByTheFactory();
        }
    }
}

