/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.bean;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Executor;
import org.infinispan.Cache;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.clustering.ee.infinispan.InfinispanConfiguration;
import org.wildfly.clustering.ejb.bean.BeanInstance;
import org.wildfly.clustering.ejb.cache.bean.BeanGroupKey;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanMetaDataKey;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;
import org.wildfly.clustering.infinispan.listener.ListenerRegistration;
import org.wildfly.clustering.infinispan.listener.PostActivateBlockingListener;
import org.wildfly.clustering.infinispan.listener.PrePassivateBlockingListener;
import org.wildfly.clustering.marshalling.spi.MarshalledValue;
import org.wildfly.clustering.service.AsyncServiceConfigurator;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;

public class InfinispanBeanGroupListenerServiceConfigurator<K, V extends BeanInstance<K>, C>
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
Service,
InfinispanConfiguration {
    private final SupplierDependency<Cache<?, ?>> cache;
    private final SupplierDependency<C> context;
    private volatile Executor executor;
    private volatile ListenerRegistration postActivateListenerRegistration;
    private volatile ListenerRegistration prePassivateListenerRegistration;
    private volatile ListenerRegistration postPassivateListenerRegistration;

    InfinispanBeanGroupListenerServiceConfigurator(ServiceName name, SupplierDependency<Cache<?, ?>> cache, SupplierDependency<C> context) {
        super(name);
        this.cache = cache;
        this.context = context;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = new AsyncServiceConfigurator(this.getServiceName()).build(target);
        new CompositeDependency(new Dependency[]{this.context, this.cache}).register(builder);
        return builder.setInstance((Service)this);
    }

    public void start(StartContext context) throws StartException {
        if (!this.getCacheProperties().isPersistent()) {
            this.executor = this.getBlockingManager().asExecutor(((Object)((Object)this)).getClass().getName());
            this.postActivateListenerRegistration = new PostActivateBlockingListener(this.getCache(), this::postActivate).register(BeanGroupKey.class);
            this.prePassivateListenerRegistration = new PrePassivateBlockingListener(this.getCache(), this::prePassivate).register(BeanGroupKey.class);
        }
    }

    public void stop(StopContext context) {
        if (this.executor != null) {
            this.postPassivateListenerRegistration.close();
            this.prePassivateListenerRegistration.close();
            this.postActivateListenerRegistration.close();
        }
    }

    void postActivate(BeanGroupKey<K> key, MarshalledValue<Map<K, V>, C> value) {
        Object context = this.context.get();
        InfinispanEjbLogger.ROOT_LOGGER.tracef("Received post-activate event for bean group %s", key.getId());
        try {
            Map instances = (Map)value.get(context);
            for (BeanInstance instance : instances.values()) {
                InfinispanEjbLogger.ROOT_LOGGER.tracef("Invoking post-activate callback for bean %s", instance.getId());
                instance.postActivate();
            }
        }
        catch (IOException e) {
            InfinispanEjbLogger.ROOT_LOGGER.warn(e.getLocalizedMessage(), e);
        }
    }

    void prePassivate(BeanGroupKey<K> key, MarshalledValue<Map<K, V>, C> value) {
        Object context = this.context.get();
        InfinispanEjbLogger.ROOT_LOGGER.tracef("Received pre-passivate event for bean group %s", key.getId());
        Cache cache = (Cache)this.cache.get();
        try {
            Map instances = (Map)value.get(context);
            ArrayList<BeanInstance> passivated = new ArrayList<BeanInstance>(instances.size());
            try {
                for (BeanInstance instance : instances.values()) {
                    Object id = instance.getId();
                    InfinispanEjbLogger.ROOT_LOGGER.tracef("Invoking pre-passivate callback for bean %s", id);
                    instance.prePassivate();
                    passivated.add(instance);
                    this.executor.execute(() -> cache.evict(new InfinispanBeanMetaDataKey<Object>(id)));
                }
            }
            catch (Error | RuntimeException e) {
                for (BeanInstance instance : passivated) {
                    InfinispanEjbLogger.ROOT_LOGGER.tracef("Invoking post-activate callback for bean %s", instance.getId());
                    try {
                        instance.postActivate();
                    }
                    catch (Error | RuntimeException t) {
                        InfinispanEjbLogger.ROOT_LOGGER.warn(e.getLocalizedMessage(), e);
                    }
                }
                throw e;
            }
        }
        catch (IOException e) {
            InfinispanEjbLogger.ROOT_LOGGER.warn(e.getLocalizedMessage(), e);
        }
    }

    public <KK, VV> Cache<KK, VV> getCache() {
        return (Cache)this.cache.get();
    }
}

