/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc.extensions.mysql;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import org.jboss.jca.adapters.jdbc.CheckValidConnectionSQL;
import org.jboss.jca.adapters.jdbc.extensions.mysql.SecurityActions;

public class MySQLValidConnectionChecker
extends CheckValidConnectionSQL {
    private static final long serialVersionUID = 1323747853035005642L;
    private static final String QUERY = "SELECT 1";

    public MySQLValidConnectionChecker() {
        super(QUERY);
    }

    @Override
    public SQLException isValidConnection(Connection c) {
        Method ping = null;
        try {
            ping = SecurityActions.getMethod(c.getClass(), "ping", null);
            SecurityActions.setAccessible(ping);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (ping != null) {
            try {
                ping.invoke((Object)c, (Object[])null);
            }
            catch (Exception e) {
                if (e instanceof SQLException) {
                    return (SQLException)e;
                }
                return new SQLException("Ping failed: " + e.toString(), e);
            }
        } else {
            return super.isValidConnection(c);
        }
        return null;
    }
}

