/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.OptionalInt;
import java.util.function.Function;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufTagMarshaller;
import org.infinispan.protostream.impl.TagWriterImpl;
import org.wildfly.clustering.marshalling.protostream.AbstractProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.DefaultProtoStreamSizeOperation;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamOperation;
import org.wildfly.clustering.marshalling.spi.ByteBufferOutputStream;

public class DefaultProtoStreamWriter
extends AbstractProtoStreamWriter
implements Function<Object, OptionalInt> {
    private final AbstractProtoStreamWriter.ProtoStreamWriterContext context;

    public DefaultProtoStreamWriter(ProtobufTagMarshaller.WriteContext context) {
        this(context, new AbstractProtoStreamWriter.DefaultProtoStreamWriterContext());
    }

    private DefaultProtoStreamWriter(ProtobufTagMarshaller.WriteContext context, AbstractProtoStreamWriter.ProtoStreamWriterContext writerContext) {
        super(context, writerContext);
        this.context = writerContext;
    }

    @Override
    public ProtoStreamOperation.Context getContext() {
        return this.context;
    }

    @Override
    public void writeObjectNoTag(Object value) throws IOException {
        ImmutableSerializationContext context = this.getSerializationContext();
        ProtoStreamMarshaller marshaller = this.findMarshaller(value.getClass());
        OptionalInt size = this.context.computeSize(value, this);
        if (size.isPresent()) {
            int length = size.getAsInt();
            this.writeVarint32(length);
            if (length > 0) {
                marshaller.writeTo(this, value);
            }
        } else {
            try (ByteBufferOutputStream output = new ByteBufferOutputStream();){
                TagWriterImpl writer = TagWriterImpl.newInstanceNoBuffer((ImmutableSerializationContext)context, (OutputStream)output);
                marshaller.writeTo(new DefaultProtoStreamWriter((ProtobufTagMarshaller.WriteContext)writer, this.context), value);
                ByteBuffer buffer = output.getBuffer();
                int offset = buffer.arrayOffset();
                int length = buffer.limit() - offset;
                this.writeVarint32(length);
                if (length > 0) {
                    this.writeRawBytes(buffer.array(), offset, length);
                }
            }
        }
    }

    @Override
    public OptionalInt apply(Object value) {
        ProtoStreamMarshaller marshaller = this.findMarshaller(value.getClass());
        return marshaller.size(new DefaultProtoStreamSizeOperation(this.getSerializationContext(), this.context.clone()), value);
    }
}

