/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.cdi;

import io.smallrye.jwt.JsonUtils;
import io.smallrye.jwt.auth.cdi.CDILogging;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Inject;
import jakarta.json.JsonValue;
import java.lang.annotation.Annotation;
import java.util.Optional;
import org.eclipse.microprofile.jwt.Claim;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.JsonWebToken;

@RequestScoped
public class CommonJwtProducer {
    @Inject
    JsonWebToken currentToken;

    public JsonValue generalJsonValueProducer(InjectionPoint ip) {
        String name = this.getName(ip);
        Object value = this.getValue(name, false);
        return JsonUtils.wrapValue(value);
    }

    public <T> T getValue(String name, boolean isOptional) {
        if (this.currentToken == null) {
            CDILogging.log.getValue(name);
            return null;
        }
        Optional claimValue = this.currentToken.claim(name);
        if (!isOptional && !claimValue.isPresent()) {
            CDILogging.log.failedToFindClaim(name);
        }
        CDILogging.log.getValueResult(name, isOptional, claimValue);
        return claimValue.orElse(null);
    }

    public String getName(InjectionPoint ip) {
        String name = null;
        for (Annotation ann : ip.getQualifiers()) {
            if (!(ann instanceof Claim)) continue;
            Claim claim = (Claim)ann;
            name = claim.standard() == Claims.UNKNOWN ? claim.value() : claim.standard().name();
        }
        return name;
    }
}

