/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.io.aio;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.util.PriorityQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQNativeIOError;
import org.apache.activemq.artemis.core.io.AbstractSequentialFile;
import org.apache.activemq.artemis.core.io.DummyCallback;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.aio.AIOSequentialFileFactory;
import org.apache.activemq.artemis.core.journal.impl.SimpleWaitIOCallback;
import org.apache.activemq.artemis.nativo.jlibaio.LibaioFile;
import org.apache.activemq.artemis.nativo.jlibaio.SubmitInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AIOSequentialFile
extends AbstractSequentialFile {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean opened = false;
    private LibaioFile aioFile;
    private final AIOSequentialFileFactory aioFactory;
    private final AtomicLong nextWritingSequence = new AtomicLong(0L);
    final PriorityQueue<AIOSequentialFileFactory.AIOSequentialCallback> pendingCallbackList = new PriorityQueue();
    private long nextReadSequence = 0L;

    public AIOSequentialFile(AIOSequentialFileFactory factory, int bufferSize, long bufferTimeoutMilliseconds, File directory, String fileName, Executor writerExecutor) {
        super(directory, fileName, factory, writerExecutor);
        this.aioFactory = factory;
    }

    @Override
    public ByteBuffer map(int position, long size) throws IOException {
        return null;
    }

    @Override
    public boolean isOpen() {
        return this.opened;
    }

    @Override
    public int calculateBlockStart(int position) {
        return this.factory.calculateBlockSize(position);
    }

    @Override
    public SequentialFile cloneFile() {
        return new AIOSequentialFile(this.aioFactory, -1, -1L, this.getFile().getParentFile(), this.getFile().getName(), null);
    }

    @Override
    public void close() throws IOException, InterruptedException, ActiveMQException {
        this.close(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close(boolean waitSync, boolean blockOnWait) throws IOException, InterruptedException, ActiveMQException {
        if (!this.opened) {
            return;
        }
        this.aioFactory.beforeClose();
        super.close();
        this.opened = false;
        this.timedBuffer = null;
        try {
            this.aioFile.close();
        }
        catch (Throwable e) {
            logger.debug("Exeption while closing file", e);
        }
        finally {
            this.aioFile = null;
            this.aioFactory.afterClose();
        }
    }

    @Override
    public synchronized void fill(int size) throws Exception {
        logger.trace("Filling file: {}", (Object)this.getFileName());
        this.checkOpened();
        this.aioFile.fill(this.aioFactory.getAlignment(), (long)size);
        this.fileSize = this.aioFile.getSize();
    }

    @Override
    public void open() throws Exception {
        this.open(this.aioFactory.getMaxIO(), true);
    }

    @Override
    public synchronized void open(int maxIO, boolean useExecutor) throws ActiveMQException {
        if (this.opened) {
            return;
        }
        this.opened = true;
        logger.trace("Opening file: {}", (Object)this.getFileName());
        try {
            this.aioFile = this.aioFactory.libaioContext.openFile(this.getFile(), this.factory.isDatasync());
        }
        catch (IOException e) {
            logger.error("Error opening file: {}", (Object)this.getFileName());
            this.factory.onIOError((Throwable)e, e.getMessage(), this);
            throw new ActiveMQNativeIOError(e.getMessage(), (Throwable)e);
        }
        this.position.set(0L);
        this.fileSize = this.aioFile.getSize();
    }

    @Override
    public int read(ByteBuffer bytes, IOCallback callback) throws ActiveMQException {
        this.checkOpened();
        int bytesToRead = bytes.limit();
        long positionToRead = this.position.getAndAdd(bytesToRead);
        bytes.rewind();
        try {
            this.aioFile.read(positionToRead, bytesToRead, bytes, (SubmitInfo)this.getCallback(callback, null));
        }
        catch (IOException e) {
            logger.error("IOError reading file: {}", (Object)this.getFileName(), (Object)e);
            this.factory.onIOError((Throwable)e, e.getMessage(), this);
            throw new ActiveMQNativeIOError(e.getMessage(), (Throwable)e);
        }
        return bytesToRead;
    }

    @Override
    public int read(ByteBuffer bytes) throws Exception {
        SimpleWaitIOCallback waitCompletion = new SimpleWaitIOCallback();
        int bytesRead = this.read(bytes, waitCompletion);
        waitCompletion.waitCompletion();
        return bytesRead;
    }

    @Override
    public void writeDirect(ByteBuffer bytes, boolean sync) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("Write Direct, Sync: {} File: {}", (Object)sync, (Object)this.getFileName());
        }
        if (sync) {
            SimpleWaitIOCallback completion = new SimpleWaitIOCallback();
            this.writeDirect(bytes, true, completion);
            completion.waitCompletion();
        } else {
            this.writeDirect(bytes, false, DummyCallback.getInstance());
        }
    }

    @Override
    public void blockingWriteDirect(ByteBuffer bytes, boolean sync, boolean releaseBuffer) throws Exception {
        logger.trace("Write Direct, Sync: true File: {}", (Object)this.getFileName());
        SimpleWaitIOCallback completion = new SimpleWaitIOCallback();
        try {
            this.checkOpened();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            completion.onError(-1, e.getMessage());
            return;
        }
        int bytesToWrite = this.factory.calculateBlockSize(bytes.limit());
        long positionToWrite = this.position.getAndAdd(bytesToWrite);
        AIOSequentialFileFactory.AIOSequentialCallback runnableCallback = this.getCallback(completion, bytes, releaseBuffer);
        runnableCallback.initWrite(positionToWrite, bytesToWrite);
        runnableCallback.run();
        completion.waitCompletion();
    }

    @Override
    public void writeDirect(ByteBuffer bytes, boolean sync, IOCallback callback) {
        try {
            this.checkOpened();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            callback.onError(-1, e.getMessage());
            return;
        }
        int bytesToWrite = this.factory.calculateBlockSize(bytes.limit());
        long positionToWrite = this.position.getAndAdd(bytesToWrite);
        AIOSequentialFileFactory.AIOSequentialCallback runnableCallback = this.getCallback(callback, bytes);
        runnableCallback.initWrite(positionToWrite, bytesToWrite);
        runnableCallback.run();
    }

    AIOSequentialFileFactory.AIOSequentialCallback getCallback(IOCallback originalCallback, ByteBuffer buffer) {
        return this.getCallback(originalCallback, buffer, true);
    }

    AIOSequentialFileFactory.AIOSequentialCallback getCallback(IOCallback originalCallback, ByteBuffer buffer, boolean releaseBuffer) {
        AIOSequentialFileFactory.AIOSequentialCallback callback = this.aioFactory.getCallback();
        callback.init(this.nextWritingSequence.getAndIncrement(), originalCallback, this.aioFile, this, buffer, releaseBuffer);
        return callback;
    }

    void done(AIOSequentialFileFactory.AIOSequentialCallback callback) {
        if (callback.writeSequence == -1L) {
            callback.sequentialDone();
        }
        if (callback.writeSequence == this.nextReadSequence) {
            ++this.nextReadSequence;
            try {
                callback.sequentialDone();
            }
            finally {
                this.flushCallbacks();
            }
        } else {
            this.pendingCallbackList.add(callback);
        }
    }

    private void flushCallbacks() {
        while (!this.pendingCallbackList.isEmpty() && this.pendingCallbackList.peek().writeSequence == this.nextReadSequence) {
            AIOSequentialFileFactory.AIOSequentialCallback callback = this.pendingCallbackList.poll();
            try {
                callback.sequentialDone();
            }
            finally {
                ++this.nextReadSequence;
            }
        }
    }

    @Override
    public void sync() {
        throw new UnsupportedOperationException("This method is not supported on AIO");
    }

    @Override
    public long size() throws Exception {
        if (this.aioFile == null) {
            return this.getFile().length();
        }
        return this.aioFile.getSize();
    }

    public String toString() {
        return "AIOSequentialFile{" + this.getFileName() + ", opened=" + this.opened + "}";
    }

    private void checkOpened() {
        if (this.aioFile == null || !this.opened) {
            throw new NullPointerException("File not opened, file=null on fileName = " + this.getFileName());
        }
    }
}

