/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class AddOffsetsToTxnRequestData
implements ApiMessage {
    String transactionalId;
    long producerId;
    short producerEpoch;
    String groupId;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 3;

    public AddOffsetsToTxnRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public AddOffsetsToTxnRequestData() {
        this.transactionalId = "";
        this.producerId = 0L;
        this.producerEpoch = 0;
        this.groupId = "";
    }

    @Override
    public short apiKey() {
        return 25;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 3;
    }

    @Override
    public final void read(Readable _readable, short _version) {
        int length = _version >= 3 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
        if (length < 0) {
            throw new RuntimeException("non-nullable field transactionalId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field transactionalId had invalid length " + length);
        }
        this.transactionalId = _readable.readString(length);
        this.producerId = _readable.readLong();
        this.producerEpoch = _readable.readShort();
        length = _version >= 3 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
        if (length < 0) {
            throw new RuntimeException("non-nullable field groupId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field groupId had invalid length " + length);
        }
        this.groupId = _readable.readString(length);
        this._unknownTaggedFields = null;
        if (_version >= 3) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        byte[] _stringBytes = _cache.getSerializedValue(this.transactionalId);
        if (_version >= 3) {
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
        } else {
            _writable.writeShort((short)_stringBytes.length);
        }
        _writable.writeByteArray(_stringBytes);
        _writable.writeLong(this.producerId);
        _writable.writeShort(this.producerEpoch);
        _stringBytes = _cache.getSerializedValue(this.groupId);
        if (_version >= 3) {
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
        } else {
            _writable.writeShort((short)_stringBytes.length);
        }
        _writable.writeByteArray(_stringBytes);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 3) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        byte[] _stringBytes = this.transactionalId.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'transactionalId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.transactionalId, _stringBytes);
        if (_version >= 3) {
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        } else {
            _size.addBytes(_stringBytes.length + 2);
        }
        _size.addBytes(8);
        _size.addBytes(2);
        _stringBytes = this.groupId.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'groupId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.groupId, _stringBytes);
        if (_version >= 3) {
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        } else {
            _size.addBytes(_stringBytes.length + 2);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 3) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AddOffsetsToTxnRequestData)) {
            return false;
        }
        AddOffsetsToTxnRequestData other = (AddOffsetsToTxnRequestData)obj;
        if (this.transactionalId == null ? other.transactionalId != null : !this.transactionalId.equals(other.transactionalId)) {
            return false;
        }
        if (this.producerId != other.producerId) {
            return false;
        }
        if (this.producerEpoch != other.producerEpoch) {
            return false;
        }
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.transactionalId == null ? 0 : this.transactionalId.hashCode());
        hashCode = 31 * hashCode + ((int)(this.producerId >> 32) ^ (int)this.producerId);
        hashCode = 31 * hashCode + this.producerEpoch;
        hashCode = 31 * hashCode + (this.groupId == null ? 0 : this.groupId.hashCode());
        return hashCode;
    }

    @Override
    public AddOffsetsToTxnRequestData duplicate() {
        AddOffsetsToTxnRequestData _duplicate = new AddOffsetsToTxnRequestData();
        _duplicate.transactionalId = this.transactionalId;
        _duplicate.producerId = this.producerId;
        _duplicate.producerEpoch = this.producerEpoch;
        _duplicate.groupId = this.groupId;
        return _duplicate;
    }

    public String toString() {
        return "AddOffsetsToTxnRequestData(transactionalId=" + (this.transactionalId == null ? "null" : "'" + this.transactionalId.toString() + "'") + ", producerId=" + this.producerId + ", producerEpoch=" + this.producerEpoch + ", groupId=" + (this.groupId == null ? "null" : "'" + this.groupId.toString() + "'") + ")";
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public long producerId() {
        return this.producerId;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public String groupId() {
        return this.groupId;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public AddOffsetsToTxnRequestData setTransactionalId(String v) {
        this.transactionalId = v;
        return this;
    }

    public AddOffsetsToTxnRequestData setProducerId(long v) {
        this.producerId = v;
        return this;
    }

    public AddOffsetsToTxnRequestData setProducerEpoch(short v) {
        this.producerEpoch = v;
        return this;
    }

    public AddOffsetsToTxnRequestData setGroupId(String v) {
        this.groupId = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("transactional_id", Type.STRING, "The transactional id corresponding to the transaction."), new Field("producer_id", Type.INT64, "Current producer id in use by the transactional id."), new Field("producer_epoch", Type.INT16, "Current epoch associated with the producer id."), new Field("group_id", Type.STRING, "The unique group identifier.")));
        SCHEMA_3 = new Schema(new Field("transactional_id", Type.COMPACT_STRING, "The transactional id corresponding to the transaction."), new Field("producer_id", Type.INT64, "Current producer id in use by the transactional id."), new Field("producer_epoch", Type.INT16, "Current epoch associated with the producer id."), new Field("group_id", Type.COMPACT_STRING, "The unique group identifier."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
    }
}

