/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.servlet;

import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.CaseInsensitiveMap;

public class HttpServletResponseHeaders
implements MultivaluedMap<String, Object> {
    private CaseInsensitiveMap<Object> cachedHeaders = new CaseInsensitiveMap();
    private HttpServletResponse response;
    private ResteasyProviderFactory factory;

    public HttpServletResponseHeaders(HttpServletResponse response, ResteasyProviderFactory factory) {
        this.response = response;
        this.factory = factory;
    }

    public void addAll(String key, Object ... newValues) {
        for (Object value : newValues) {
            this.add(key, value);
        }
    }

    public void addAll(String key, List<Object> valueList) {
        for (Object value : valueList) {
            this.add(key, value);
        }
    }

    public void addFirst(String key, Object value) {
        Object list = this.get(key);
        if (list == null) {
            this.add(key, value);
            return;
        }
        list.add(0, value);
    }

    public void putSingle(String key, Object value) {
        if (value == null) {
            return;
        }
        this.cachedHeaders.putSingle(key, value);
        RuntimeDelegate.HeaderDelegate delegate = this.factory.getHeaderDelegate(value.getClass());
        if (delegate != null) {
            this.response.setHeader(key, delegate.toString(value));
        } else {
            this.response.setHeader(key, value.toString());
        }
    }

    public void add(String key, Object value) {
        this.cachedHeaders.add(key, value);
        this.addResponseHeader(key, value);
    }

    protected void addResponseHeader(String key, Object value) {
        if (value == null) {
            return;
        }
        RuntimeDelegate.HeaderDelegate delegate = this.factory.getHeaderDelegate(value.getClass());
        if (delegate != null) {
            this.response.addHeader(key, delegate.toString(value));
        } else {
            this.response.addHeader(key, value.toString());
        }
    }

    public Object getFirst(String key) {
        return this.cachedHeaders.getFirst(key);
    }

    public int size() {
        return this.cachedHeaders.size();
    }

    public boolean isEmpty() {
        return this.cachedHeaders.isEmpty();
    }

    public boolean containsKey(Object o) {
        return this.cachedHeaders.containsKey(o);
    }

    public boolean containsValue(Object o) {
        return this.cachedHeaders.containsValue(o);
    }

    public List<Object> get(Object o) {
        return this.cachedHeaders.get(o);
    }

    public List<Object> put(String s, List<Object> objs) {
        for (Object obj : objs) {
            this.addResponseHeader(s, obj);
        }
        return this.cachedHeaders.put(s, objs);
    }

    public List<Object> remove(Object o) {
        throw new RuntimeException(Messages.MESSAGES.removingHeaderIllegal());
    }

    public void putAll(Map<? extends String, ? extends List<Object>> map) {
        for (Map.Entry<? extends String, ? extends List<Object>> entry : map.entrySet()) {
            List<Object> objs = entry.getValue();
            if (objs.isEmpty()) continue;
            this.putResponseHeader(entry.getKey(), objs.get(0));
            for (int i = 1; i < objs.size(); ++i) {
                this.add(entry.getKey(), objs.get(i));
            }
        }
    }

    protected void putResponseHeader(String key, Object value) {
        if (value == null) {
            return;
        }
        RuntimeDelegate.HeaderDelegate delegate = this.factory.getHeaderDelegate(value.getClass());
        if (delegate != null) {
            this.response.setHeader(key, delegate.toString(value));
        } else {
            this.response.setHeader(key, value.toString());
        }
        this.cachedHeaders.add(key, value);
    }

    public void clear() {
        throw new RuntimeException(Messages.MESSAGES.removingHeaderIllegal());
    }

    public Set<String> keySet() {
        return this.cachedHeaders.keySet();
    }

    public Collection<List<Object>> values() {
        return this.cachedHeaders.values();
    }

    public Set<Map.Entry<String, List<Object>>> entrySet() {
        return this.cachedHeaders.entrySet();
    }

    public boolean equals(Object o) {
        return this.cachedHeaders.equals(o);
    }

    public int hashCode() {
        return this.cachedHeaders.hashCode();
    }

    public boolean equalsIgnoreValueOrder(MultivaluedMap<String, Object> otherMap) {
        return this.cachedHeaders.equalsIgnoreValueOrder(otherMap);
    }
}

