/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.coordinator.domain.model;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import io.narayana.lra.Current;
import io.narayana.lra.LRAData;
import io.narayana.lra.coordinator.domain.model.LongRunningAction;
import io.narayana.lra.coordinator.domain.service.LRAService;
import io.narayana.lra.logging.LRALogger;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.client.AsyncInvoker;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.microprofile.lra.annotation.LRAStatus;
import org.eclipse.microprofile.lra.annotation.ParticipantStatus;

public class LRAParticipantRecord
extends AbstractRecord
implements Comparable<AbstractRecord> {
    private static final String TYPE_NAME = "/StateManager/AbstractRecord/LRARecord";
    private static final String COMPENSATE_REL = "compensate";
    private static final String COMPLETE_REL = "complete";
    private URI lraId;
    private URI parentId;
    private URI recoveryURI;
    private String participantPath;
    private URI completeURI;
    private URI compensateURI;
    private URI statusURI;
    private URI forgetURI;
    private URI afterURI;
    private String responseData;
    private String compensatorData;
    private String previousCompensatorData;
    private LRAService lraService;
    private ParticipantStatus status;
    private boolean accepted;
    private LongRunningAction lra;

    public LRAParticipantRecord() {
    }

    LRAParticipantRecord(LongRunningAction lra, LRAService lraService, String linkURI, String compensatorData) {
        super(new Uid());
        this.lra = lra;
        try {
            if (linkURI.startsWith("<")) {
                Exception[] parseException = new Exception[]{null};
                Arrays.stream(linkURI.split(",")).forEach(linkStr -> {
                    URISyntaxException e = this.parseLink((String)linkStr);
                    if (e != null) {
                        parseException[0] = e;
                    }
                });
                if (parseException[0] != null) {
                    String errorMsg = LRALogger.i18nLogger.error_invalidCompensator(lra.getId(), parseException[0].getMessage(), linkURI);
                    LRALogger.logger.error((Object)errorMsg);
                    if (LRALogger.logger.isTraceEnabled()) {
                        this.trace_progress(errorMsg);
                    }
                    throw new WebApplicationException(errorMsg, (Throwable)parseException[0], Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMsg).build());
                }
                if (this.compensateURI == null && this.afterURI == null) {
                    String errorMsg = LRALogger.i18nLogger.error_missingCompensator(lra.getId(), linkURI);
                    LRALogger.logger.error((Object)errorMsg);
                    if (LRALogger.logger.isTraceEnabled()) {
                        this.trace_progress(errorMsg);
                    }
                    throw new WebApplicationException(errorMsg, Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMsg).build());
                }
            } else {
                this.compensateURI = new URI(String.format("%s/compensate", linkURI));
                this.completeURI = new URI(String.format("%s/complete", linkURI));
                this.statusURI = new URI(String.format("%s", linkURI));
                this.forgetURI = new URI(String.format("%s", linkURI));
            }
            this.lraId = lra.getId();
            this.parentId = lra.getParentId();
            this.status = ParticipantStatus.Active;
            this.lraService = lraService;
            this.participantPath = linkURI;
            this.recoveryURI = null;
            this.compensatorData = compensatorData;
            if (LRALogger.logger.isTraceEnabled()) {
                this.trace_progress("created");
            }
        }
        catch (URISyntaxException e) {
            String logMsg = LRALogger.i18nLogger.error_invalidFormatToCreateLRAParticipantRecord(this.lraId.toASCIIString(), linkURI, e.getMessage());
            LRALogger.logger.error((Object)logMsg);
            if (LRALogger.logger.isTraceEnabled()) {
                this.trace_progress(logMsg);
            }
            throw new WebApplicationException(logMsg, (Throwable)e, Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)logMsg).build());
        }
    }

    void setLRA(LongRunningAction lra) {
        this.lra = lra;
        this.parentId = lra.getParentId();
    }

    String getParticipantPath() {
        return this.participantPath;
    }

    static String cannonicalForm(String linkStr) throws URISyntaxException {
        if (!linkStr.contains(">;")) {
            return new URI(linkStr).toASCIIString();
        }
        TreeMap<String, String> lm = new TreeMap<String, String>();
        Arrays.stream(linkStr.split(",")).forEach(link -> lm.put(Link.valueOf((String)link).getRel(), (String)link));
        StringBuilder sb = new StringBuilder();
        lm.forEach((k, v) -> LRAParticipantRecord.appendLink(sb, v));
        return sb.toString();
    }

    private static void appendLink(StringBuilder b, String value) {
        if (b.length() != 0) {
            b.append(',');
        }
        b.append(value);
    }

    static String extractCompensator(String linkStr) throws URISyntaxException {
        for (String lnk : linkStr.split(",")) {
            Link link;
            try {
                link = Link.valueOf((String)lnk);
            }
            catch (IllegalArgumentException e) {
                throw new URISyntaxException(lnk, e.getMessage());
            }
            if (!COMPENSATE_REL.equals(link.getRel())) continue;
            return LRAParticipantRecord.cannonicalForm(link.getUri().toString());
        }
        return linkStr;
    }

    private static URI cannonicalURI(URI uri) throws URISyntaxException {
        return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath().replaceAll("//", "/"), uri.getQuery(), uri.getFragment());
    }

    private URISyntaxException parseLink(String linkStr) {
        Link link = Link.valueOf((String)linkStr);
        String rel = link.getRel();
        try {
            URI uri = LRAParticipantRecord.cannonicalURI(link.getUri());
            if (COMPENSATE_REL.equals(rel)) {
                this.compensateURI = uri;
            } else if (COMPLETE_REL.equals(rel)) {
                this.completeURI = uri;
            } else if ("status".equals(rel)) {
                this.statusURI = uri;
            } else if ("after".equals(rel)) {
                this.afterURI = uri;
            } else if ("forget".equals(rel)) {
                this.forgetURI = uri;
            } else if ("participant".equals(rel)) {
                this.compensateURI = new URI(uri.toASCIIString() + "/compensate");
                this.completeURI = new URI(uri.toASCIIString() + "/complete");
                this.statusURI = this.forgetURI = uri;
            }
            return null;
        }
        catch (URISyntaxException e) {
            return e;
        }
    }

    public int topLevelPrepare() {
        return 0;
    }

    public int topLevelAbort() {
        return this.doEnd(this.lra.isCancel());
    }

    public int topLevelOnePhaseCommit() {
        return this.topLevelCommit();
    }

    public int topLevelCommit() {
        return this.doEnd(this.lra.isCancel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doEnd(boolean compensate) {
        assert (this.lraService != null);
        ReentrantLock lock = this.lraService.lockTransaction(this.lraId);
        try {
            int n = this.tryDoEnd(compensate);
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int tryDoEnd(boolean compensate) {
        URI endPath;
        Client client = null;
        if (LRALogger.logger.isTraceEnabled()) {
            this.trace_progress("finishing");
        }
        if (this.isFinished()) {
            return this.atEnd(this.status == ParticipantStatus.FailedToComplete || this.status == ParticipantStatus.FailedToCompensate ? 8 : 7);
        }
        if (ParticipantStatus.Compensating.equals((Object)this.status)) {
            compensate = true;
        }
        if (this.compensateURI == null) {
            return this.atEnd(7);
        }
        if (compensate) {
            if (this.isCompensated()) {
                return this.atEnd(7);
            }
            endPath = this.compensateURI;
            this.status = ParticipantStatus.Compensating;
        } else {
            if (this.isCompelete() || this.completeURI == null) {
                this.status = ParticipantStatus.Completed;
                return this.atEnd(7);
            }
            endPath = this.completeURI;
            this.status = ParticipantStatus.Completing;
        }
        int httpStatus = -1;
        if (this.accepted) {
            int twoPhaseOutcome = this.retryGetEndStatus(endPath, compensate);
            if (twoPhaseOutcome != -1) {
                return this.atEnd(twoPhaseOutcome);
            }
        } else {
            httpStatus = this.tryLocalEndInvocation(endPath);
        }
        if (httpStatus == -1) {
            if (LRALogger.logger.isTraceEnabled()) {
                this.trace_progress("notifying participant");
            }
            try {
                client = ClientBuilder.newClient();
                Response response = (Response)client.target(endPath).request().header("Long-Running-Action", (Object)this.lraId.toASCIIString()).header("Long-Running-Action-Parent", (Object)this.parentId).header("Long-Running-Action-Recovery", (Object)this.recoveryURI.toASCIIString()).header("Narayana-LRA-Participant-Data", (Object)this.compensatorData).async().put(Entity.text((Object)"")).get(2L, TimeUnit.SECONDS);
                httpStatus = response.getStatus();
                boolean bl = this.accepted = httpStatus == Response.Status.ACCEPTED.getStatusCode();
                if (this.accepted && this.statusURI == null && response.getHeaderString("Location") != null) {
                    this.statusURI = URI.create(response.getHeaderString("Location"));
                }
                if (httpStatus == Response.Status.GONE.getStatusCode()) {
                    this.updateStatus(compensate);
                    int n = this.atEnd(7);
                    return n;
                }
                if (response.hasEntity()) {
                    this.responseData = (String)response.readEntity(String.class);
                }
            }
            catch (Exception e) {
                if (LRALogger.logger.isInfoEnabled()) {
                    LRALogger.logger.infof("LRAParticipantRecord.doEnd(%s) HTTP PUT at %s failed for LRA %s (reason: %s)", new Object[]{compensate ? COMPENSATE_REL : COMPLETE_REL, endPath, this.lraId, e.getMessage()});
                    if (LRALogger.logger.isDebugEnabled()) {
                        LRALogger.logger.debug((Object)"LRAParticipantRecord.doEnd stacktrace", (Throwable)e);
                    }
                }
            }
            finally {
                if (LRALogger.logger.isTraceEnabled()) {
                    this.trace_progress("notified participant");
                }
                if (client != null) {
                    client.close();
                }
            }
        }
        if (this.responseData != null && httpStatus == Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()) {
            try {
                return this.atEnd(this.reportFailure(compensate, endPath, ParticipantStatus.valueOf((String)this.responseData).name()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (httpStatus != Response.Status.OK.getStatusCode() && httpStatus != Response.Status.NO_CONTENT.getStatusCode() && !this.accepted) {
            if (LRALogger.logger.isDebugEnabled()) {
                LRALogger.logger.debugf("LRAParticipantRecord.doEnd put %s failed with status: %d", (Object)endPath, (Object)httpStatus);
            }
            this.status = compensate ? ParticipantStatus.Compensating : ParticipantStatus.Completing;
            this.accepted = true;
            if (LRALogger.logger.isTraceEnabled()) {
                this.trace_progress("notify participant failed");
            }
        }
        this.updateStatus(compensate);
        return this.atEnd(this.accepted ? 6 : 7);
    }

    boolean isFinished() {
        if (this.compensateURI == null) {
            return this.afterURI != null;
        }
        switch (this.status) {
            case Completed: 
            case FailedToComplete: {
                return this.parentId == null;
            }
            case Compensated: 
            case FailedToCompensate: {
                return true;
            }
        }
        return false;
    }

    boolean isFailed() {
        return this.status == ParticipantStatus.FailedToCompensate || this.status == ParticipantStatus.FailedToComplete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean afterLRARequest(URI target, String payload) {
        try (Client client = ClientBuilder.newClient();){
            Future responseFuture;
            Response response;
            Invocation.Builder builder = client.target(target).request().header("Long-Running-Action-Recovery", (Object)this.recoveryURI.toASCIIString()).header("Narayana-LRA-Participant-Data", (Object)this.compensatorData);
            if (target.equals(this.afterURI)) {
                builder.header("Long-Running-Action-Ended", (Object)this.lra.getId().toASCIIString());
                if (this.lra.getParentId() != null) {
                    builder.header("Long-Running-Action-Parent", (Object)this.lra.getParentId().toASCIIString());
                }
            } else {
                builder.header("Long-Running-Action", (Object)this.lra.getId().toASCIIString());
            }
            if ((response = (Response)(responseFuture = target.equals(this.forgetURI) ? builder.async().delete() : builder.async().put(Entity.text((Object)payload))).get(2L, TimeUnit.SECONDS)).getStatus() == 200) {
                if (LRALogger.logger.isTraceEnabled()) {
                    this.trace_progress("notified participant");
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            LRALogger.i18nLogger.warn_cannotNotifyAfterLRAURI(target, (Throwable)e);
        }
        finally {
            if (LRALogger.logger.isTraceEnabled()) {
                this.trace_progress("finished notifying participant");
            }
        }
        return false;
    }

    private int atEnd(int res) {
        if (this.parentId != null && (this.status == ParticipantStatus.Completed || this.status == ParticipantStatus.FailedToComplete)) {
            if (this.lraService.getLRA(this.parentId).getStatus() == LRAStatus.Active) {
                return 6;
            }
            return this.runPostLRAActions();
        }
        if (!this.isFinished() || !this.lra.isFinished()) {
            if (this.afterURI != null) {
                return 6;
            }
            return res;
        }
        return this.runPostLRAActions();
    }

    private int runPostLRAActions() {
        LRAStatus lraStatus = this.lra.getLRAStatus();
        boolean report = false;
        if (lraStatus == LRAStatus.Cancelling) {
            report = this.isFailed();
            lraStatus = report ? LRAStatus.FailedToCancel : LRAStatus.Cancelled;
        } else if (lraStatus == LRAStatus.Closing) {
            report = this.isFailed();
            LRAStatus lRAStatus = lraStatus = report ? LRAStatus.FailedToClose : LRAStatus.Closed;
        }
        if (this.afterURI == null || this.afterLRARequest(this.afterURI, lraStatus.name())) {
            this.afterURI = null;
            if (LRALogger.logger.isTraceEnabled()) {
                this.trace_progress("runPostLRAActions with afterURI");
            }
            return report ? this.reportFailure(lraStatus.name()) : 7;
        }
        if (LRALogger.logger.isTraceEnabled()) {
            this.trace_progress("runPostLRAActions");
        }
        return report ? this.reportFailure(lraStatus.name()) : 6;
    }

    private void updateStatus(boolean compensate) {
        this.status = compensate ? (this.accepted ? ParticipantStatus.Compensating : ParticipantStatus.Compensated) : (this.accepted ? ParticipantStatus.Completing : ParticipantStatus.Completed);
    }

    private int reportFailure(String failureReason) {
        if (this.status == ParticipantStatus.FailedToCompensate) {
            return this.reportFailure(true, this.compensateURI, failureReason);
        }
        return this.reportFailure(false, this.completeURI, failureReason);
    }

    private int reportFailure(boolean compensate, URI endPath, String failureReason) {
        ParticipantStatus participantStatus = this.status = compensate ? ParticipantStatus.FailedToCompensate : ParticipantStatus.FailedToComplete;
        if (LRALogger.logger.isTraceEnabled()) {
            this.trace_progress("reportFailure");
        }
        LRALogger.logger.warnf("LRAParticipantRecord: participant %s reported a failure to %s (cause %s)", (Object)endPath, (Object)(compensate ? COMPENSATE_REL : COMPLETE_REL), (Object)failureReason);
        return 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int retryGetEndStatus(URI endPath, boolean compensate) {
        assert (this.accepted);
        URI nestedLraId = this.extractParentLRA(endPath);
        if (LRALogger.logger.isTraceEnabled()) {
            this.trace_progress("retryGetEndStatus");
        }
        if (nestedLraId != null && this.lraService != null) {
            LongRunningAction transaction = this.lraService.getTransaction(nestedLraId);
            if (transaction == null) return -1;
            LRAStatus cStatus = transaction.getLRAStatus();
            if (LRALogger.logger.isTraceEnabled()) {
                this.trace_progress("retryGetEndStatus: local status " + cStatus);
            }
            if (cStatus == null) {
                LRALogger.logger.warnf("LRAParticipantRecord.retryGetEndStatus: local LRA %s accepted but has a null status", (Object)endPath);
                return -1;
            }
            switch (cStatus) {
                case Closed: 
                case Cancelled: {
                    return 7;
                }
                case Closing: 
                case Cancelling: {
                    return 6;
                }
                case FailedToClose: 
                case FailedToCancel: {
                    return this.reportFailure(compensate, endPath, "unknown");
                }
            }
            return 6;
        }
        if (this.statusURI == null) return -1;
        try (Client client = ClientBuilder.newClient();){
            Response response = (Response)client.target(this.statusURI).request().header("Long-Running-Action", (Object)this.lraId.toASCIIString()).header("Long-Running-Action-Recovery", (Object)this.recoveryURI.toASCIIString()).header("Long-Running-Action-Parent", (Object)this.parentId).header("Narayana-LRA-Participant-Data", (Object)this.compensatorData).async().get().get(2L, TimeUnit.SECONDS);
            if (response.getStatus() == Response.Status.GONE.getStatusCode()) {
                this.status = compensate ? ParticipantStatus.Compensated : ParticipantStatus.Completed;
                int n = 7;
                return n;
            }
            if (response.getStatus() == Response.Status.ACCEPTED.getStatusCode() || Response.Status.Family.familyOf((int)response.getStatus()).equals((Object)Response.Status.Family.SERVER_ERROR)) {
                int n = 6;
                return n;
            }
            if (response.getStatus() != Response.Status.OK.getStatusCode()) return -1;
            if (!response.hasEntity()) return -1;
            this.status = ParticipantStatus.valueOf((String)((String)response.readEntity(String.class)));
            switch (this.status) {
                case Completed: 
                case Compensated: {
                    int n = 7;
                    return n;
                }
                case Completing: 
                case Compensating: {
                    int n = 6;
                    return n;
                }
                case FailedToComplete: 
                case FailedToCompensate: {
                    LRALogger.logger.warnf("LRAParticipantRecord.doEnd(compensate %b) get status %s did not finish: %s: WILL NOT RETRY", (Object)compensate, (Object)endPath, (Object)this.status);
                    if (this.forgetURI != null && !this.forget()) {
                        int n = 6;
                        return n;
                    }
                    int n = this.reportFailure(compensate, endPath, "Unknown");
                    return n;
                }
            }
            int n = 6;
            return n;
        }
        catch (Throwable e) {
            if (LRALogger.logger.isInfoEnabled()) {
                LRALogger.logger.infof("LRAParticipantRecord.doEnd status URI %s is invalid (%s)", (Object)this.statusURI, (Object)e.getMessage());
            }
            int n = 6;
            return n;
        }
        finally {
            if (LRALogger.logger.isTraceEnabled()) {
                this.trace_progress("retryGetEndStatus");
            }
            Current.pop();
        }
    }

    private Future<Response> getAsyncResponse(WebTarget target, String method, AsyncInvoker asyncInvoker, String cData) {
        String queryString = target.getUri().getQuery();
        if (queryString != null) {
            String[] queries;
            for (String pair : queries = queryString.split("&")) {
                String[] qp;
                if (!pair.contains("=") || !(qp = pair.split("="))[0].equals("method")) continue;
                switch (qp[1]) {
                    case "jakarta.ws.rs.GET": {
                        return asyncInvoker.get();
                    }
                    case "jakarta.ws.rs.PUT": {
                        return asyncInvoker.put(Entity.entity((Object)cData, (String)"text/plain"));
                    }
                    case "jakarta.ws.rs.POST": {
                        return asyncInvoker.post(Entity.entity((Object)cData, (String)"text/plain"));
                    }
                    case "jakarta.ws.rs.DELETE": {
                        return asyncInvoker.delete();
                    }
                }
            }
        }
        switch (method) {
            case "jakarta.ws.rs.GET": {
                return asyncInvoker.get();
            }
            case "jakarta.ws.rs.PUT": {
                return asyncInvoker.put(Entity.entity((Object)this.compensatorData, (String)"text/plain"));
            }
            case "jakarta.ws.rs.POST": {
                return asyncInvoker.post(Entity.entity((Object)this.compensatorData, (String)"text/plain"));
            }
            case "jakarta.ws.rs.DELETE": {
                return asyncInvoker.delete();
            }
        }
        return asyncInvoker.get();
    }

    private URI extractParentLRA(URI endPath) {
        if (this.lraService != null) {
            String[] segments = endPath.getPath().split("/");
            int pCnt = segments.length;
            if (pCnt > 1) {
                try {
                    String cId = URLDecoder.decode(segments[pCnt - 2], StandardCharsets.UTF_8);
                    return this.lraService.hasTransaction(cId) ? new URI(cId) : null;
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            if (LRALogger.logger.isTraceEnabled()) {
                this.trace_progress("extractParentLRA: not local");
            }
        }
        return null;
    }

    private int tryLocalEndInvocation(URI endPath) {
        URI cId = this.extractParentLRA(endPath);
        if (cId != null) {
            int httpStatus;
            String[] segments = endPath.getPath().split("/");
            int pCnt = segments.length;
            boolean isCompensate = COMPENSATE_REL.equals(segments[pCnt - 1]);
            boolean isComplete = COMPLETE_REL.equals(segments[pCnt - 1]);
            if (!isCompensate && !isComplete) {
                if (LRALogger.logger.isInfoEnabled()) {
                    LRALogger.logger.infof("LRAParticipantRecord.doEnd invalid nested participant url %s(should be compensate or complete)", (Object)endPath);
                }
                httpStatus = Response.Status.BAD_REQUEST.getStatusCode();
            } else {
                LRAData inVMStatus = this.lraService.endLRA(cId, isCompensate, true);
                httpStatus = inVMStatus.getHttpStatus();
            }
            return httpStatus;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean forget() {
        block10: {
            Client client = null;
            if (this.forgetURI != null) {
                try {
                    client = ClientBuilder.newClient();
                    Response response = (Response)client.target(this.forgetURI).request().header("Long-Running-Action", (Object)this.lraId).header("Long-Running-Action-Recovery", (Object)this.recoveryURI).header("Long-Running-Action-Parent", (Object)this.parentId).header("Narayana-LRA-Participant-Data", (Object)this.compensatorData).async().delete().get(2L, TimeUnit.SECONDS);
                    if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                        this.forgetURI = null;
                        boolean bl = true;
                        return bl;
                    }
                    break block10;
                }
                catch (Exception e) {
                    Throwable exception = e;
                    Throwable cause = exception.getCause();
                    if (!(exception instanceof WebApplicationException) && cause instanceof WebApplicationException) {
                        exception = (WebApplicationException)cause;
                    }
                    LRALogger.logger.infof("LRAParticipantRecord.forget delete %s failed for LRA %s (reason %s)", (Object)this.forgetURI, (Object)this.lraId, (Object)exception.getMessage());
                    boolean bl = false;
                    return bl;
                }
                finally {
                    if (LRALogger.logger.isTraceEnabled()) {
                        this.trace_progress("forget");
                    }
                    Current.pop();
                    if (client != null) {
                        client.close();
                    }
                }
            }
            LRALogger.logger.warnf("LRAParticipantRecord.forget() LRA: %s: cannot forget %s: missing forget URI, status: %s", (Object)this.lraId, (Object)this.recoveryURI, (Object)this.status);
        }
        return true;
    }

    private boolean isCompelete() {
        return this.status != null && this.status == ParticipantStatus.Completed;
    }

    private boolean isCompensated() {
        return this.status != null && this.status == ParticipantStatus.Compensated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save_state(OutputObjectState os, int t) {
        if (super.save_state(os, t)) {
            try {
                this.packURI(os, this.lraId);
                this.packURI(os, this.compensateURI);
                this.packURI(os, this.recoveryURI);
                this.packURI(os, this.completeURI);
                this.packURI(os, this.afterURI);
                this.packURI(os, this.statusURI);
                this.packURI(os, this.forgetURI);
                this.packStatus(os);
                os.packString(this.participantPath);
                os.packString(this.compensatorData);
            }
            catch (IOException e) {
                LRALogger.i18nLogger.warn_saveState(e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                if (LRALogger.logger.isTraceEnabled()) {
                    this.trace_progress("saved");
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restore_state(InputObjectState os, int t) {
        if (super.restore_state(os, t)) {
            try {
                this.lraId = this.unpackURI(os);
                this.compensateURI = this.unpackURI(os);
                this.recoveryURI = this.unpackURI(os);
                this.completeURI = this.unpackURI(os);
                this.afterURI = this.unpackURI(os);
                this.statusURI = this.unpackURI(os);
                this.forgetURI = this.unpackURI(os);
                this.unpackStatus(os);
                this.participantPath = os.unpackString();
                this.compensatorData = os.unpackString();
                this.accepted = this.status == ParticipantStatus.Completing || this.status == ParticipantStatus.Compensating;
            }
            catch (IOException | URISyntaxException e) {
                LRALogger.i18nLogger.warn_restoreState(e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                if (LRALogger.logger.isTraceEnabled()) {
                    this.trace_progress("restored");
                }
            }
        }
        return true;
    }

    private void packStatus(OutputObjectState os) throws IOException {
        if (this.status == null) {
            os.packBoolean(false);
        } else {
            os.packBoolean(true);
            os.packInt(this.status.ordinal());
        }
    }

    private void unpackStatus(InputObjectState os) throws IOException {
        this.status = os.unpackBoolean() ? ParticipantStatus.values()[os.unpackInt()] : null;
    }

    private void packURI(OutputObjectState os, URI url) throws IOException {
        if (url == null) {
            os.packBoolean(false);
        } else {
            os.packBoolean(true);
            os.packString(url.toASCIIString());
        }
    }

    private URI unpackURI(InputObjectState os) throws IOException, URISyntaxException {
        return os.unpackBoolean() ? new URI(Objects.requireNonNull(os.unpackString())) : null;
    }

    private static int getTypeId() {
        return 166;
    }

    public int typeIs() {
        return LRAParticipantRecord.getTypeId();
    }

    public int nestedAbort() {
        return 7;
    }

    public int nestedCommit() {
        return 7;
    }

    public int nestedPrepare() {
        return 0;
    }

    public int nestedOnePhaseCommit() {
        return 8;
    }

    public String type() {
        return TYPE_NAME;
    }

    public boolean doSave() {
        return true;
    }

    public void merge(AbstractRecord a) {
    }

    public void alter(AbstractRecord a) {
    }

    public boolean shouldAdd(AbstractRecord a) {
        return a.typeIs() == this.typeIs();
    }

    public boolean shouldAlter(AbstractRecord a) {
        return false;
    }

    public boolean shouldMerge(AbstractRecord a) {
        return false;
    }

    public boolean shouldReplace(AbstractRecord a) {
        return false;
    }

    public Object value() {
        return null;
    }

    public void setValue(Object o) {
    }

    @Override
    public int compareTo(AbstractRecord other) {
        if (this.lessThan(other)) {
            return -1;
        }
        if (this.greaterThan(other)) {
            return 1;
        }
        return 0;
    }

    public URI getRecoveryURI() {
        return this.recoveryURI;
    }

    public String getParticipantURI() {
        return this.participantPath;
    }

    void setRecoveryURI(String recoveryURI) {
        try {
            this.recoveryURI = new URI(recoveryURI);
        }
        catch (URISyntaxException e) {
            String errorMsg = LRALogger.i18nLogger.error_invalidRecoveryUrlToJoinLRAURI(recoveryURI, this.lraId);
            LRALogger.logger.info((Object)errorMsg);
            throw new WebApplicationException(errorMsg, (Throwable)e, Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMsg).build());
        }
    }

    void setRecoveryURI(String recoveryUrlBase, String txId, String coordinatorId) {
        this.setRecoveryURI(recoveryUrlBase + txId + "/" + coordinatorId);
    }

    public String getCompensator() {
        return this.compensateURI != null ? this.compensateURI.toASCIIString() : null;
    }

    void setLRAService(LRAService lraService) {
        this.lraService = lraService;
    }

    public void setLraService(LRAService lraService) {
        this.lraService = lraService;
    }

    public URI getEndNotificationUri() {
        return this.afterURI;
    }

    public ParticipantStatus getStatus() {
        return this.status;
    }

    public void setCompensatorData(String compensatorData) {
        this.previousCompensatorData = this.compensatorData;
        this.compensatorData = compensatorData;
    }

    public String getPreviousCompensatorData() {
        return this.previousCompensatorData;
    }

    private void trace_progress(String reason) {
        LRALogger.logger.tracef("%s: LRA id: %s, Participant id: %s, reason: %s, state: %s, accepted: %b", new Object[]{LocalDateTime.now(ZoneOffset.UTC), this.lraId, this.participantPath, reason, this.status, this.accepted});
    }
}

