/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.cache.timer;

import java.time.Duration;
import java.time.Instant;
import org.wildfly.clustering.ejb.cache.timer.AbstractTimerMetaDataEntry;
import org.wildfly.clustering.ejb.cache.timer.ImmutableIntervalTimerMetaDataEntry;
import org.wildfly.clustering.ejb.cache.timer.RemappableTimerMetaDataEntry;
import org.wildfly.clustering.ejb.timer.IntervalTimerConfiguration;

public class IntervalTimerMetaDataEntry<C>
extends AbstractTimerMetaDataEntry<C>
implements ImmutableIntervalTimerMetaDataEntry<C> {
    private final Duration interval;

    public IntervalTimerMetaDataEntry(C context, IntervalTimerConfiguration config) {
        this(context, config.getStart(), config.getInterval());
    }

    public IntervalTimerMetaDataEntry(C context, Instant start, Duration interval) {
        super(context, start);
        this.interval = interval;
    }

    public Duration getInterval() {
        return this.interval;
    }

    @Override
    public Instant apply(Instant lastTimeout) {
        return this.interval != null ? lastTimeout.plus(this.interval) : null;
    }

    @Override
    protected RemappableTimerMetaDataEntry<C> clone() {
        return new IntervalTimerMetaDataEntry(this.getContext(), this.getStart(), this.interval);
    }
}

