/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.ds;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.metadata.api.common.Credential;
import org.jboss.as.connector.metadata.api.ds.DsSecurity;
import org.jboss.as.connector.metadata.common.CredentialImpl;
import org.jboss.as.connector.metadata.ds.DsSecurityImpl;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.ParserException;
import org.jboss.jca.common.metadata.ds.DsParser;
import org.jboss.metadata.property.PropertyReplacer;

public class DsXmlParser
extends DsParser {
    private final PropertyReplacer propertyReplacer;

    public DsXmlParser(PropertyReplacer propertyReplacer) {
        this.propertyReplacer = propertyReplacer;
    }

    protected DsSecurity parseDsSecurity(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        String userName = null;
        String password = null;
        String authenticationContext = null;
        Extension reauthPlugin = null;
        block12: while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.SECURITY) {
                        return new DsSecurityImpl(userName, password, authenticationContext, null, reauthPlugin);
                    }
                    if (DsSecurity.Tag.forName(reader.getLocalName()) != DsSecurity.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    DsSecurity.Tag tag = DsSecurity.Tag.forName(reader.getLocalName());
                    switch (tag) {
                        case PASSWORD: {
                            password = this.elementAsString(reader);
                            boolean resolved = false;
                            if (this.propertyReplacer == null || password == null || password.trim().length() == 0) break block0;
                            String resolvedPassword = this.propertyReplacer.replaceProperties(password);
                            if (resolvedPassword == null) continue block12;
                            password = resolvedPassword;
                            resolved = true;
                            break block0;
                        }
                        case USER_NAME: {
                            userName = this.elementAsString(reader);
                            break block0;
                        }
                        case SECURITY_DOMAIN: {
                            throw new ParserException(ConnectorLogger.DS_DEPLOYER_LOGGER.legacySecurityNotSupported());
                        }
                        case ELYTRON_ENABLED: {
                            this.elementAsBoolean(reader);
                            break block0;
                        }
                        case AUTHENTICATION_CONTEXT: {
                            authenticationContext = this.elementAsString(reader);
                            break block0;
                        }
                        case REAUTH_PLUGIN: {
                            reauthPlugin = this.parseExtension(reader, tag.getLocalName());
                            break block0;
                        }
                        default: {
                            throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                        }
                    }
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected Credential parseCredential(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        String userName = null;
        String password = null;
        String authenticationContext = null;
        block11: while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.SECURITY || Recovery.Tag.forName((String)reader.getLocalName()) == Recovery.Tag.RECOVER_CREDENTIAL) {
                        return new CredentialImpl(userName, password, authenticationContext, null);
                    }
                    if (Credential.Tag.forName(reader.getLocalName()) != Credential.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (Credential.Tag.forName(reader.getLocalName())) {
                        case PASSWORD: {
                            password = this.elementAsString(reader);
                            if (this.propertyReplacer == null || password == null) break block0;
                            String resolvedPassword = this.propertyReplacer.replaceProperties(password);
                            if (resolvedPassword == null) continue block11;
                            password = resolvedPassword;
                            break block0;
                        }
                        case USER_NAME: {
                            userName = this.elementAsString(reader);
                            break block0;
                        }
                        case SECURITY_DOMAIN: {
                            throw new ParserException((Throwable)ConnectorLogger.SUBSYSTEM_RA_LOGGER.legacySecurityNotAvailable());
                        }
                        case ELYTRON_ENABLED: {
                            this.elementAsBoolean(reader);
                            break block0;
                        }
                        case AUTHENTICATION_CONTEXT: {
                            authenticationContext = this.elementAsString(reader);
                            break block0;
                        }
                        default: {
                            throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                        }
                    }
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }
}

