/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.impl;

import io.opentelemetry.api.OpenTelemetry;
import io.smallrye.common.annotation.Identifier;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.health.HealthReport;
import io.smallrye.reactive.messaging.kafka.DeserializationFailureHandler;
import io.smallrye.reactive.messaging.kafka.IncomingKafkaRecord;
import io.smallrye.reactive.messaging.kafka.IncomingKafkaRecordBatch;
import io.smallrye.reactive.messaging.kafka.KafkaCDIEvents;
import io.smallrye.reactive.messaging.kafka.KafkaConnectorIncomingConfiguration;
import io.smallrye.reactive.messaging.kafka.KafkaConsumerRebalanceListener;
import io.smallrye.reactive.messaging.kafka.KafkaRecord;
import io.smallrye.reactive.messaging.kafka.commit.ContextHolder;
import io.smallrye.reactive.messaging.kafka.commit.KafkaCommitHandler;
import io.smallrye.reactive.messaging.kafka.fault.KafkaDeadLetterQueue;
import io.smallrye.reactive.messaging.kafka.fault.KafkaDelayedRetryTopic;
import io.smallrye.reactive.messaging.kafka.fault.KafkaFailureHandler;
import io.smallrye.reactive.messaging.kafka.health.KafkaSourceHealth;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaExceptions;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaLogging;
import io.smallrye.reactive.messaging.kafka.impl.ReactiveKafkaConsumer;
import io.smallrye.reactive.messaging.kafka.impl.RebalanceListeners;
import io.smallrye.reactive.messaging.kafka.impl.TopicPartitions;
import io.smallrye.reactive.messaging.kafka.tracing.KafkaOpenTelemetryInstrumenter;
import io.smallrye.reactive.messaging.kafka.tracing.KafkaTrace;
import io.vertx.core.Context;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.mutiny.core.Vertx;
import jakarta.enterprise.inject.Instance;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Flow;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.RebalanceInProgressException;
import org.apache.kafka.common.errors.RecordDeserializationException;
import org.apache.kafka.common.header.Header;

public class KafkaSource<K, V> {
    private final Multi<IncomingKafkaRecord<K, V>> stream;
    private final Multi<IncomingKafkaRecordBatch<K, V>> batchStream;
    private final KafkaFailureHandler failureHandler;
    private final KafkaCommitHandler commitHandler;
    private final KafkaConnectorIncomingConfiguration configuration;
    private final List<Throwable> failures = new ArrayList<Throwable>();
    private final Set<String> topics;
    private final boolean isTracingEnabled;
    private final boolean isHealthEnabled;
    private final boolean isHealthReadinessEnabled;
    private final boolean isCloudEventEnabled;
    private final String channel;
    private volatile boolean subscribed;
    private final KafkaSourceHealth health;
    private final String group;
    private final Instance<KafkaCommitHandler.Factory> commitHandlerFactory;
    private final Instance<KafkaFailureHandler.Factory> failureHandlerFactories;
    private final int index;
    private final Instance<DeserializationFailureHandler<?>> deserializationFailureHandlers;
    private final Instance<KafkaConsumerRebalanceListener> consumerRebalanceListeners;
    private final ReactiveKafkaConsumer<K, V> client;
    private final ContextInternal context;
    private final KafkaOpenTelemetryInstrumenter kafkaInstrumenter;

    public KafkaSource(Vertx vertx, String consumerGroup, KafkaConnectorIncomingConfiguration config, Instance<OpenTelemetry> openTelemetryInstance, Instance<KafkaCommitHandler.Factory> commitHandlerFactories, Instance<KafkaFailureHandler.Factory> failureHandlerFactories, Instance<KafkaConsumerRebalanceListener> consumerRebalanceListeners, KafkaCDIEvents kafkaCDIEvents, Instance<DeserializationFailureHandler<?>> deserializationFailureHandlers, int index) {
        Pattern pattern;
        this.group = consumerGroup;
        this.commitHandlerFactory = commitHandlerFactories;
        this.failureHandlerFactories = failureHandlerFactories;
        this.index = index;
        this.deserializationFailureHandlers = deserializationFailureHandlers;
        this.consumerRebalanceListeners = consumerRebalanceListeners;
        this.topics = KafkaSource.getTopics(config);
        String seekToOffset = config.getAssignSeek().orElse(null);
        Map<TopicPartition, Optional<Long>> offsetSeeks = KafkaSource.getOffsetSeeks(seekToOffset, config.getChannel(), this.topics);
        if (config.getPattern().booleanValue()) {
            pattern = Pattern.compile(config.getTopic().orElseThrow(() -> new IllegalArgumentException("Invalid Kafka incoming configuration for channel `" + config.getChannel() + "`, `pattern` must be used with the `topic` attribute")));
            KafkaLogging.log.configuredPattern(config.getChannel(), pattern.toString());
        } else {
            KafkaLogging.log.configuredTopics(config.getChannel(), this.topics);
            pattern = null;
        }
        this.configuration = config;
        this.context = ((VertxInternal)vertx.getDelegate()).createEventLoopContext();
        this.client = new ReactiveKafkaConsumer(config, deserializationFailureHandlers, consumerGroup, index, this::reportFailure, this.getContext().getDelegate(), c -> kafkaCDIEvents.consumer().fire(c));
        String commitStrategy = config.getCommitStrategy().orElse(Boolean.parseBoolean(this.client.get("enable.auto.commit")) ? "ignore" : "throttled");
        this.commitHandler = this.createCommitHandler(vertx, commitStrategy);
        this.failureHandler = this.createFailureHandler(vertx);
        this.health = this.configuration.getHealthEnabled() != false ? new KafkaSourceHealth(this, this.configuration, this.client, this.topics, pattern) : null;
        this.isTracingEnabled = this.configuration.getTracingEnabled();
        this.isHealthEnabled = this.configuration.getHealthEnabled();
        this.isHealthReadinessEnabled = this.configuration.getHealthReadinessEnabled();
        this.isCloudEventEnabled = this.configuration.getCloudEvents();
        this.channel = this.configuration.getChannel();
        if (this.commitHandler instanceof ContextHolder) {
            ((ContextHolder)((Object)this.commitHandler)).capture((Context)this.context);
        }
        if (this.failureHandler instanceof ContextHolder) {
            ((ContextHolder)((Object)this.failureHandler)).capture((Context)this.context);
        }
        this.client.setRebalanceListener(RebalanceListeners.findMatchingListener(config, consumerGroup, consumerRebalanceListeners), this.commitHandler);
        if (!config.getBatch().booleanValue()) {
            Multi<ConsumerRecord<K, V>> multi = pattern != null ? this.client.subscribe(pattern) : (offsetSeeks.isEmpty() ? this.client.subscribe(this.topics) : this.client.assignAndSeek(offsetSeeks));
            multi = multi.onSubscription().invoke(() -> {
                this.subscribed = true;
                String groupId = this.client.get("group.id");
                String clientId = this.client.get("client.id");
                KafkaLogging.log.connectedToKafka(clientId, config.getBootstrapServers(), groupId, this.topics);
            });
            multi = multi.onFailure().invoke(t -> {
                KafkaLogging.log.unableToReadRecord(this.topics, (Throwable)t);
                this.reportFailure((Throwable)t, false);
            });
            Multi incomingMulti = multi.onItem().transformToUni(rec -> {
                IncomingKafkaRecord record = new IncomingKafkaRecord(rec, this.channel, index, this.commitHandler, this.failureHandler, this.isCloudEventEnabled, this.isTracingEnabled);
                if (this.failureHandler instanceof KafkaDeadLetterQueue && rec.headers() != null && rec.headers().lastHeader("deserialization-failure-dlq") != null) {
                    Header reasonMsgHeader = rec.headers().lastHeader("deserialization-failure-reason");
                    String message = reasonMsgHeader != null ? new String(reasonMsgHeader.value()) : null;
                    RecordDeserializationException reason = new RecordDeserializationException(TopicPartitions.getTopicPartition(record), record.getOffset(), message, null);
                    return this.failureHandler.handle(record, (Throwable)reason, record.getMetadata()).onItem().transform(ignore -> null);
                }
                return this.commitHandler.received(record);
            }).concatenate();
            if (config.getTracingEnabled().booleanValue()) {
                incomingMulti = incomingMulti.onItem().invoke(record -> this.incomingTrace((IncomingKafkaRecord<K, V>)record, false));
            }
            if (this.failureHandler instanceof KafkaDelayedRetryTopic) {
                Multi<? extends IncomingKafkaRecord<?, ?>> retryStream = ((KafkaDelayedRetryTopic)this.failureHandler).retryStream();
                incomingMulti = Multi.createBy().merging().withConcurrency(2).streams(new Flow.Publisher[]{incomingMulti, retryStream});
            }
            this.stream = incomingMulti.onFailure().invoke(t -> this.reportFailure((Throwable)t, false));
            this.batchStream = null;
        } else {
            Multi<ConsumerRecords<K, V>> multi = pattern != null ? this.client.subscribeBatch(pattern) : (offsetSeeks.isEmpty() ? this.client.subscribeBatch(this.topics) : this.client.assignAndSeekBatch(offsetSeeks));
            multi = multi.onSubscription().invoke(() -> {
                this.subscribed = true;
                String groupId = this.client.get("group.id");
                String clientId = this.client.get("client.id");
                KafkaLogging.log.connectedToKafka(clientId, config.getBootstrapServers(), groupId, this.topics);
            });
            multi = multi.onFailure().invoke(t -> {
                KafkaLogging.log.unableToReadRecord(this.topics, (Throwable)t);
                this.reportFailure((Throwable)t, false);
            });
            Multi incomingMulti = multi.onItem().transformToUni(rec -> {
                IncomingKafkaRecordBatch batch = new IncomingKafkaRecordBatch(rec, this.channel, index, this.commitHandler, this.failureHandler, this.isCloudEventEnabled, this.isTracingEnabled);
                return this.receiveBatchRecord(batch);
            }).concatenate();
            if (config.getTracingEnabled().booleanValue()) {
                incomingMulti = incomingMulti.onItem().invoke(this::incomingTrace);
            }
            this.batchStream = incomingMulti.onFailure().invoke(t -> this.reportFailure((Throwable)t, false));
            this.stream = null;
        }
        this.kafkaInstrumenter = this.isTracingEnabled ? KafkaOpenTelemetryInstrumenter.createForSource(openTelemetryInstance) : null;
    }

    public static Set<String> getTopics(KafkaConnectorIncomingConfiguration config) {
        String list = config.getTopics().orElse(null);
        String top = config.getTopic().orElse(null);
        String channel = config.getChannel();
        boolean isPattern = config.getPattern();
        if (list != null && top != null) {
            throw KafkaExceptions.ex.invalidTopics(channel, "topic");
        }
        if (list != null && isPattern) {
            throw KafkaExceptions.ex.invalidTopics(channel, "pattern");
        }
        if (list != null) {
            String[] strings = list.split(",");
            return Arrays.stream(strings).map(String::trim).collect(Collectors.toSet());
        }
        if (top != null) {
            return Collections.singleton(top);
        }
        return Collections.singleton(channel);
    }

    public static Map<TopicPartition, Optional<Long>> getOffsetSeeks(String seekToOffset, String channel, Set<String> topics) {
        String[] tpOffsets;
        if (seekToOffset == null || seekToOffset.isBlank()) {
            return Collections.emptyMap();
        }
        HashMap<TopicPartition, Optional<Long>> offsetSeeks = new HashMap<TopicPartition, Optional<Long>>();
        for (String tpOffset : tpOffsets = seekToOffset.split(",")) {
            String[] tpo = tpOffset.strip().split(":");
            try {
                if (tpo.length == 3) {
                    String topic = tpo[0];
                    int partition = Integer.parseInt(tpo[1]);
                    long offset = Long.parseLong(tpo[2]);
                    offsetSeeks.put(TopicPartitions.getTopicPartition(topic, partition), Optional.of(offset));
                    continue;
                }
                if (tpo.length == 2) {
                    try {
                        int partition = Integer.parseInt(tpo[0]);
                        long offset = Long.parseLong(tpo[1]);
                        if (topics.size() > 1) {
                            throw KafkaExceptions.ex.invalidAssignSeekTopic(channel, tpOffset);
                        }
                        String topic = topics.iterator().next();
                        offsetSeeks.put(TopicPartitions.getTopicPartition(topic, partition), Optional.of(offset));
                    }
                    catch (NumberFormatException e) {
                        String topic = tpo[0];
                        int partition = Integer.parseInt(tpo[1]);
                        offsetSeeks.put(TopicPartitions.getTopicPartition(topic, partition), Optional.empty());
                    }
                    continue;
                }
                int partition = Integer.parseInt(tpo[0]);
                if (topics.size() > 1) {
                    throw KafkaExceptions.ex.invalidAssignSeekTopic(channel, tpOffset);
                }
                String topic = topics.iterator().next();
                offsetSeeks.put(TopicPartitions.getTopicPartition(topic, partition), Optional.empty());
            }
            catch (Throwable t) {
                throw KafkaExceptions.ex.invalidAssignSeek(channel, tpOffset, t);
            }
        }
        if (offsetSeeks.keySet().stream().map(TopicPartition::topic).anyMatch(s -> !topics.contains(s))) {
            KafkaLogging.log.topicsConfigurationIgnored(topics.toString(), channel, offsetSeeks.keySet().toString());
        }
        return offsetSeeks;
    }

    public synchronized void reportFailure(Throwable failure, boolean fatal) {
        if (failure instanceof RebalanceInProgressException) {
            KafkaLogging.log.failureReportedDuringRebalance(this.topics, failure);
            return;
        }
        KafkaLogging.log.failureReported(this.topics, failure);
        if (this.failures.size() == 10) {
            this.failures.remove(0);
        }
        this.failures.add(failure);
        if (fatal && this.client != null) {
            this.client.close();
        }
    }

    public void incomingTrace(IncomingKafkaRecord<K, V> kafkaRecord, boolean insideBatch) {
        if (this.isTracingEnabled) {
            KafkaTrace kafkaTrace = new KafkaTrace.Builder().withPartition(kafkaRecord.getPartition()).withTopic(kafkaRecord.getTopic()).withOffset(kafkaRecord.getOffset()).withHeaders(kafkaRecord.getHeaders()).withGroupId(this.client.get("group.id")).withClientId(this.client.get("client.id")).build();
            this.kafkaInstrumenter.traceIncoming(kafkaRecord, kafkaTrace, !insideBatch);
        }
    }

    public void incomingTrace(IncomingKafkaRecordBatch<K, V> kafkaBatchRecord) {
        if (this.isTracingEnabled) {
            for (KafkaRecord<K, V> record : kafkaBatchRecord.getRecords()) {
                IncomingKafkaRecord kafkaRecord = (IncomingKafkaRecord)record.unwrap(IncomingKafkaRecord.class);
                this.incomingTrace(kafkaRecord, true);
            }
        }
    }

    private Uni<IncomingKafkaRecordBatch<K, V>> receiveBatchRecord(IncomingKafkaRecordBatch<K, V> batch) {
        ArrayList records = new ArrayList();
        for (KafkaRecord<K, V> record : batch.getLatestOffsetRecords().values()) {
            IncomingKafkaRecord kafkaRecord = (IncomingKafkaRecord)record.unwrap(IncomingKafkaRecord.class);
            records.add(this.commitHandler.received(kafkaRecord));
        }
        if (records.size() == 0) {
            return Uni.createFrom().item(batch);
        }
        if (records.size() == 1) {
            return ((Uni)records.get(0)).onItem().transform(ignored -> batch);
        }
        return Uni.combine().all().unis(records).combinedWith(ignored -> batch);
    }

    private KafkaFailureHandler createFailureHandler(Vertx vertx) {
        String strategy = this.configuration.getFailureStrategy();
        Instance failureHandlerFactory = this.failureHandlerFactories.select(new Annotation[]{Identifier.Literal.of((String)strategy)});
        if (failureHandlerFactory.isResolvable()) {
            return ((KafkaFailureHandler.Factory)failureHandlerFactory.get()).create(this.configuration, vertx, this.client, this::reportFailure);
        }
        throw KafkaExceptions.ex.illegalArgumentInvalidFailureStrategy(strategy);
    }

    private KafkaCommitHandler createCommitHandler(Vertx vertx, String strategy) {
        Instance possibleCommitHandler = this.commitHandlerFactory.select(new Annotation[]{Identifier.Literal.of((String)strategy)});
        if (possibleCommitHandler.isResolvable()) {
            KafkaLogging.log.commitStrategyForChannel(strategy, this.configuration.getChannel());
            return ((KafkaCommitHandler.Factory)possibleCommitHandler.get()).create(this.configuration, vertx, this.client, this::reportFailure);
        }
        throw KafkaExceptions.ex.illegalArgumentInvalidCommitStrategy(strategy);
    }

    public Multi<IncomingKafkaRecord<K, V>> getStream() {
        return this.stream;
    }

    public Multi<IncomingKafkaRecordBatch<K, V>> getBatchStream() {
        return this.batchStream;
    }

    public void closeQuietly() {
        try {
            if (this.configuration.getGracefulShutdown().booleanValue()) {
                Duration pollTimeoutTwice = Duration.ofMillis((long)this.configuration.getPollTimeout().intValue() * 2L);
                if (!this.client.isClosed() && ((Boolean)this.client.runOnPollingThread(c -> {
                    Set partitions = c.assignment();
                    if (!partitions.isEmpty()) {
                        KafkaLogging.log.pauseAllPartitionOnTermination();
                        c.pause((Collection)partitions);
                        return true;
                    }
                    return false;
                }).await().atMost(pollTimeoutTwice)).booleanValue()) {
                    this.grace(pollTimeoutTwice);
                }
            }
            this.commitHandler.terminate(this.configuration.getGracefulShutdown());
            this.failureHandler.terminate();
        }
        catch (Throwable e) {
            KafkaLogging.log.exceptionOnClose(e);
        }
        try {
            this.client.close();
        }
        catch (Throwable e) {
            KafkaLogging.log.exceptionOnClose(e);
        }
        if (this.health != null) {
            this.health.close();
        }
    }

    private void grace(Duration duration) {
        try {
            Thread.sleep(duration.toMillis());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isAlive(HealthReport.HealthReportBuilder builder) {
        if (this.isHealthEnabled) {
            ArrayList<Throwable> actualFailures;
            KafkaSource kafkaSource = this;
            synchronized (kafkaSource) {
                actualFailures = new ArrayList<Throwable>(this.failures);
            }
            if (!actualFailures.isEmpty()) {
                builder.add(this.channel, false, actualFailures.stream().map(Throwable::getMessage).collect(Collectors.joining()));
            } else {
                builder.add(this.channel, true);
            }
        }
    }

    public void isReady(HealthReport.HealthReportBuilder builder) {
        if (this.health != null && this.isHealthReadinessEnabled) {
            this.health.isReady(builder);
        }
    }

    public void isStarted(HealthReport.HealthReportBuilder builder) {
        if (this.health != null) {
            this.health.isStarted(builder);
        }
    }

    public ReactiveKafkaConsumer<K, V> getConsumer() {
        return this.client;
    }

    String getConsumerGroup() {
        return this.group;
    }

    int getConsumerIndex() {
        return this.index;
    }

    Instance<DeserializationFailureHandler<?>> getDeserializationFailureHandlers() {
        return this.deserializationFailureHandlers;
    }

    Instance<KafkaConsumerRebalanceListener> getConsumerRebalanceListeners() {
        return this.consumerRebalanceListeners;
    }

    public KafkaCommitHandler getCommitHandler() {
        return this.commitHandler;
    }

    io.vertx.mutiny.core.Context getContext() {
        return new io.vertx.mutiny.core.Context((Context)this.context);
    }

    public String getChannel() {
        return this.channel;
    }

    public boolean hasSubscribers() {
        return this.subscribed;
    }
}

