/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.lra.participant.deployment;

import java.io.IOException;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.vfs.VirtualFile;
import org.wildfly.extension.microprofile.lra.participant._private.MicroProfileLRAParticipantLogger;
import org.wildfly.extension.microprofile.lra.participant.deployment.LRAAnnotationsUtil;

public class LRAParticipantDeploymentSetupProcessor
implements DeploymentUnitProcessor {
    private static final String WEB_INF_BEANS_XML = "WEB-INF/beans.xml";
    private static final String META_INF_BEANS_XML = "META-INF/beans.xml";

    public void deploy(DeploymentPhaseContext phaseContext) {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (LRAAnnotationsUtil.isNotLRADeployment(deploymentUnit)) {
            return;
        }
        this.addBeanXml(deploymentUnit);
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void addBeanXml(DeploymentUnit deploymentUnit) {
        VirtualFile beanXmlVFile = DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit) ? ((ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot().getChild(WEB_INF_BEANS_XML) : ((ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot().getChild(META_INF_BEANS_XML);
        if (!beanXmlVFile.exists()) {
            try {
                boolean isCreated = beanXmlVFile.getPhysicalFile().createNewFile();
                MicroProfileLRAParticipantLogger.LOGGER.debugf("The CDI marker file '%s' %s created", beanXmlVFile.getPhysicalFile(), isCreated ? "was" : "was NOT");
            }
            catch (IOException ioe) {
                MicroProfileLRAParticipantLogger.LOGGER.cannotCreateCDIMarkerFile(ioe);
            }
        }
    }
}

