/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.bootstrap.impl;

import java.util.Optional;
import java.util.function.BiConsumer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertyChecker;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.common.spi.SearchIntegrationFinalizer;
import org.hibernate.search.engine.common.spi.SearchIntegrationPartialBuildState;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingKey;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmMapping;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmMappingKey;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateSearchContextProviderService;
import org.hibernate.search.util.common.AssertionFailure;

final class HibernateOrmIntegrationPartialBuildState {
    private static final OptionalConfigurationProperty<HibernateOrmIntegrationPartialBuildState> INTEGRATION_PARTIAL_BUILD_STATE = ConfigurationProperty.forKey((String)"hibernate.search.integration_partial_build_state").as(HibernateOrmIntegrationPartialBuildState.class, HibernateOrmIntegrationPartialBuildState::parse).build();
    private final SearchIntegrationPartialBuildState integrationBuildState;
    private final HibernateOrmMappingKey mappingKey;

    public static Optional<HibernateOrmIntegrationPartialBuildState> get(ConfigurationPropertySource propertySource) {
        return (Optional)INTEGRATION_PARTIAL_BUILD_STATE.get(propertySource);
    }

    private static HibernateOrmIntegrationPartialBuildState parse(String stringToParse) {
        throw new AssertionFailure("The partial build state cannot be parsed from a String; it must be null or an instance of " + HibernateOrmIntegrationPartialBuildState.class);
    }

    HibernateOrmIntegrationPartialBuildState(SearchIntegrationPartialBuildState integrationBuildState, HibernateOrmMappingKey mappingKey) {
        this.integrationBuildState = integrationBuildState;
        this.mappingKey = mappingKey;
    }

    public void closeOnFailure() {
        this.integrationBuildState.closeOnFailure();
    }

    void set(BiConsumer<String, Object> propertyCollector) {
        propertyCollector.accept("hibernate.search.integration_partial_build_state", this);
    }

    BeanResolver beanResolver() {
        return this.integrationBuildState.beanResolver();
    }

    HibernateSearchContextProviderService doBootSecondPhase(SessionFactoryImplementor sessionFactoryImplementor, ConfigurationPropertySource propertySource, ConfigurationPropertyChecker propertyChecker) {
        SearchIntegrationFinalizer finalizer = this.integrationBuildState.finalizer(propertySource, propertyChecker);
        HibernateOrmMapping mapping = (HibernateOrmMapping)finalizer.finalizeMapping((MappingKey)this.mappingKey, (context, partialMapping) -> partialMapping.bindToSessionFactory(context, sessionFactoryImplementor));
        finalizer.finalizeIntegration();
        HibernateSearchContextProviderService contextService = HibernateSearchContextProviderService.get(sessionFactoryImplementor);
        contextService.initialize(mapping);
        return contextService;
    }
}

