/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.loading.impl;

import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.AssertionFailure;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.search.mapper.orm.common.impl.HibernateOrmUtils;
import org.hibernate.search.mapper.orm.loading.impl.AbstractHibernateOrmLoadingStrategy;
import org.hibernate.search.mapper.orm.loading.impl.EntityLoadingCacheLookupStrategyImplementor;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmSelectionEntityByIdLoader;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmSelectionLoadingContext;
import org.hibernate.search.mapper.orm.loading.impl.PersistenceContextLookupStrategy;
import org.hibernate.search.mapper.orm.loading.impl.PersistenceContextThenSecondLevelCacheLookupStrategy;
import org.hibernate.search.mapper.orm.loading.impl.TypeQueryFactory;
import org.hibernate.search.mapper.orm.loading.spi.HibernateOrmEntityLoadingStrategy;
import org.hibernate.search.mapper.orm.loading.spi.HibernateOrmLoadingSessionContext;
import org.hibernate.search.mapper.orm.loading.spi.MutableEntityLoadingOptions;
import org.hibernate.search.mapper.orm.search.loading.EntityLoadingCacheLookupStrategy;
import org.hibernate.search.mapper.pojo.loading.spi.PojoLoadingTypeContext;
import org.hibernate.search.mapper.pojo.loading.spi.PojoSelectionEntityLoader;

public class HibernateOrmEntityIdEntityLoadingStrategy<E, I>
extends AbstractHibernateOrmLoadingStrategy<E, I> {
    private final Class<E> rootEntityClass;
    private final TypeQueryFactory<E, I> queryFactory;

    public static HibernateOrmEntityLoadingStrategy<?, ?> create(PersistentClass persistentClass) {
        RootClass rootClass = persistentClass.getRootClass();
        return HibernateOrmEntityIdEntityLoadingStrategy.create(rootClass, HibernateOrmUtils.entityClass((PersistentClass)rootClass));
    }

    private static <E> HibernateOrmEntityIdEntityLoadingStrategy<E, ?> create(RootClass rootClass, Class<E> rootMappedClass) {
        Property idProperty = rootClass.getIdentifierProperty();
        TypeQueryFactory queryFactory = TypeQueryFactory.create(rootMappedClass, rootClass.getEntityName(), idProperty.getType().getReturnedClass(), idProperty.getName(), true);
        return new HibernateOrmEntityIdEntityLoadingStrategy(rootMappedClass, rootClass.getEntityName(), queryFactory);
    }

    HibernateOrmEntityIdEntityLoadingStrategy(Class<E> rootEntityClass, String rootEntityName, TypeQueryFactory<E, I> queryFactory) {
        super(rootEntityName, queryFactory);
        this.rootEntityClass = rootEntityClass;
        this.queryFactory = queryFactory;
    }

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        HibernateOrmEntityIdEntityLoadingStrategy other = (HibernateOrmEntityIdEntityLoadingStrategy)obj;
        return this.rootEntityName.equals(other.rootEntityName);
    }

    public int hashCode() {
        return this.rootEntityClass.hashCode();
    }

    @Override
    public PojoSelectionEntityLoader<E> createEntityLoader(Set<? extends PojoLoadingTypeContext<? extends E>> targetEntityTypeContexts, HibernateOrmSelectionLoadingContext loadingContext) {
        SessionFactoryImplementor sessionFactory = loadingContext.sessionImplementor().getSessionFactory();
        EntityMappingType commonSuperType = HibernateOrmEntityIdEntityLoadingStrategy.toMostSpecificCommonEntitySuperType(sessionFactory, targetEntityTypeContexts);
        if (commonSuperType == null) {
            throw this.invalidTypesException(targetEntityTypeContexts);
        }
        PojoSelectionEntityLoader<?> result = this.doCreate(commonSuperType, loadingContext.sessionContext(), loadingContext.cacheLookupStrategy(), loadingContext.loadingOptions());
        return result;
    }

    private PojoSelectionEntityLoader<?> doCreate(EntityMappingType entityMappingType, HibernateOrmLoadingSessionContext sessionContext, EntityLoadingCacheLookupStrategy cacheLookupStrategy, MutableEntityLoadingOptions loadingOptions) {
        EntityLoadingCacheLookupStrategyImplementor cacheLookupStrategyImplementor;
        SessionImplementor session = sessionContext.session();
        SessionFactoryImplementor sessionFactory = session.getSessionFactory();
        EntityMappingType rootEntityMappingType = HibernateOrmUtils.entityMappingType(sessionFactory, this.rootEntityName);
        if (!this.rootEntityClass.isAssignableFrom(entityMappingType.getJavaType().getJavaTypeClass())) {
            throw this.invalidTypeException(entityMappingType);
        }
        PersistenceContextLookupStrategy persistenceContextLookup = PersistenceContextLookupStrategy.create(session);
        switch (cacheLookupStrategy) {
            case SKIP: {
                cacheLookupStrategyImplementor = null;
                break;
            }
            case PERSISTENCE_CONTEXT: {
                cacheLookupStrategyImplementor = persistenceContextLookup;
                break;
            }
            case PERSISTENCE_CONTEXT_THEN_SECOND_LEVEL_CACHE: {
                cacheLookupStrategyImplementor = PersistenceContextThenSecondLevelCacheLookupStrategy.create(rootEntityMappingType, session);
                break;
            }
            default: {
                throw new AssertionFailure("Unexpected cache lookup strategy: " + cacheLookupStrategy);
            }
        }
        return new HibernateOrmSelectionEntityByIdLoader<E>(rootEntityMappingType, this.queryFactory, sessionContext, persistenceContextLookup, cacheLookupStrategyImplementor, loadingOptions);
    }

    private static EntityMappingType toMostSpecificCommonEntitySuperType(SessionFactoryImplementor sessionFactory, Iterable<? extends PojoLoadingTypeContext<?>> targetEntityTypeContexts) {
        EntityMappingType result = null;
        for (PojoLoadingTypeContext<?> targetTypeContext : targetEntityTypeContexts) {
            EntityMappingType type = HibernateOrmUtils.entityMappingType(sessionFactory, targetTypeContext.secondaryEntityName());
            if (result == null) {
                result = type;
                continue;
            }
            result = HibernateOrmUtils.toMostSpecificCommonEntitySuperType(result, type);
        }
        return result;
    }

    private AssertionFailure invalidTypeException(EntityMappingType otherEntityMappingType) {
        throw new AssertionFailure("The targeted entity type is not a subclass of the expected root entity type. Expected root entity name: " + this.rootEntityName + " Targeted entity name: " + otherEntityMappingType.getEntityName());
    }

    private AssertionFailure invalidTypesException(Set<? extends PojoLoadingTypeContext<?>> targetEntityTypeContexts) {
        return new AssertionFailure("Some types among the targeted entity types are not subclasses of the expected root entity type. Expected entity name: " + this.rootEntityName + " Targeted entity names: " + targetEntityTypeContexts.stream().map(PojoLoadingTypeContext::secondaryEntityName).collect(Collectors.toUnmodifiableList()));
    }
}

