/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.util;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@ApplicationScoped
public class CdiUtils {
    @Inject
    private BeanManager beanManager;

    public <T> T newBean(Class<T> clazz) {
        return CdiUtils.newBean(this.beanManager, clazz);
    }

    public static <T> T newBean(BeanManager bm, Class<T> clazz) {
        Set beans = bm.getBeans(clazz, new Annotation[0]);
        Bean bean = bm.resolve(beans);
        CreationalContext ctx = bm.createCreationalContext((Contextual)bean);
        return (T)bm.getReference(bean, clazz, ctx);
    }

    public static void addAnnotatedTypes(BeforeBeanDiscovery beforeBean, BeanManager bm, Class<?> ... types) {
        for (Class<?> type : types) {
            beforeBean.addAnnotatedType(bm.createAnnotatedType(type), type.getName());
        }
    }

    public static <T> List<T> getApplicationBeans(Class<T> type, Annotation ... qualifiers) {
        BeanManager manager = CdiUtils.getApplicationBeanManager();
        return manager.getBeans(type, qualifiers).stream().map(bean -> manager.getReference(bean, (Type)type, manager.createCreationalContext((Contextual)bean))).collect(Collectors.toList());
    }

    public static <T> Optional<T> getApplicationBean(Class<T> type, Annotation ... qualifiers) {
        List<T> instances = CdiUtils.getApplicationBeans(type, new Annotation[0]);
        if (instances.size() == 0) {
            return Optional.empty();
        }
        if (instances.size() == 1) {
            return Optional.of(instances.get(0));
        }
        throw new IllegalStateException("More than one CDI managed instance found of: " + type.getName());
    }

    public static BeanManager getApplicationBeanManager() {
        return CDI.current().getBeanManager();
    }
}

