/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session.metadata;

import java.time.Duration;
import java.util.function.BiFunction;
import org.infinispan.Cache;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.infinispan.CacheEntryComputeMutator;
import org.wildfly.clustering.ee.infinispan.InfinispanConfiguration;
import org.wildfly.clustering.web.cache.session.metadata.InvalidatableSessionMetaData;
import org.wildfly.clustering.web.cache.session.metadata.SessionMetaDataFactory;
import org.wildfly.clustering.web.cache.session.metadata.coarse.ContextualSessionMetaDataEntry;
import org.wildfly.clustering.web.cache.session.metadata.coarse.DefaultImmutableSessionMetaData;
import org.wildfly.clustering.web.cache.session.metadata.coarse.DefaultSessionMetaData;
import org.wildfly.clustering.web.cache.session.metadata.coarse.DefaultSessionMetaDataEntry;
import org.wildfly.clustering.web.cache.session.metadata.coarse.ImmutableSessionMetaDataEntry;
import org.wildfly.clustering.web.cache.session.metadata.coarse.MutableSessionMetaDataEntry;
import org.wildfly.clustering.web.cache.session.metadata.coarse.MutableSessionMetaDataOffsetValues;
import org.wildfly.clustering.web.cache.session.metadata.coarse.SessionMetaDataEntry;
import org.wildfly.clustering.web.cache.session.metadata.coarse.SessionMetaDataEntryFunction;
import org.wildfly.clustering.web.infinispan.session.metadata.SessionMetaDataKey;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;

public class InfinispanSessionMetaDataFactory<L>
implements SessionMetaDataFactory<ContextualSessionMetaDataEntry<L>> {
    private final Cache<SessionMetaDataKey, ContextualSessionMetaDataEntry<L>> cache;
    private final Cache<SessionMetaDataKey, ContextualSessionMetaDataEntry<L>> readForUpdateCache;
    private final Cache<SessionMetaDataKey, ContextualSessionMetaDataEntry<L>> tryReadForUpdateCache;
    private final Cache<SessionMetaDataKey, ContextualSessionMetaDataEntry<L>> writeOnlyCache;
    private final Cache<SessionMetaDataKey, ContextualSessionMetaDataEntry<L>> silentWriteCache;
    private final CacheProperties properties;

    public InfinispanSessionMetaDataFactory(InfinispanConfiguration configuration) {
        this.cache = configuration.getCache();
        this.readForUpdateCache = configuration.getReadForUpdateCache();
        this.tryReadForUpdateCache = configuration.getTryReadForUpdateCache();
        this.writeOnlyCache = configuration.getWriteOnlyCache();
        this.silentWriteCache = configuration.getSilentWriteCache();
        this.properties = configuration.getCacheProperties();
    }

    public ContextualSessionMetaDataEntry<L> createValue(String id, Duration defaultTimeout) {
        DefaultSessionMetaDataEntry entry = new DefaultSessionMetaDataEntry();
        entry.setTimeout(defaultTimeout);
        this.writeOnlyCache.put((Object)new SessionMetaDataKey(id), (Object)entry);
        return entry;
    }

    public ContextualSessionMetaDataEntry<L> findValue(String id) {
        return (ContextualSessionMetaDataEntry)this.readForUpdateCache.get((Object)new SessionMetaDataKey(id));
    }

    public ContextualSessionMetaDataEntry<L> tryValue(String id) {
        return (ContextualSessionMetaDataEntry)this.tryReadForUpdateCache.get((Object)new SessionMetaDataKey(id));
    }

    public boolean remove(String id) {
        this.writeOnlyCache.remove((Object)new SessionMetaDataKey(id));
        return true;
    }

    public boolean purge(String id) {
        this.silentWriteCache.remove((Object)new SessionMetaDataKey(id));
        return true;
    }

    public InvalidatableSessionMetaData createSessionMetaData(String id, ContextualSessionMetaDataEntry<L> entry) {
        MutableSessionMetaDataOffsetValues delta = this.properties.isTransactional() && entry.isNew() ? null : MutableSessionMetaDataOffsetValues.from(entry);
        Mutator mutator = delta != null ? new CacheEntryComputeMutator(this.cache, (Object)new SessionMetaDataKey(id), (BiFunction)new SessionMetaDataEntryFunction(delta)) : Mutator.PASSIVE;
        return new DefaultSessionMetaData((SessionMetaDataEntry)(delta != null ? new MutableSessionMetaDataEntry((ImmutableSessionMetaDataEntry)entry, delta) : entry), mutator);
    }

    public ImmutableSessionMetaData createImmutableSessionMetaData(String id, ContextualSessionMetaDataEntry<L> entry) {
        return new DefaultImmutableSessionMetaData(entry);
    }
}

