/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal;

import jakarta.persistence.Column;
import java.sql.Date;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Locale;
import java.util.Set;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.envers.Audited;
import org.hibernate.envers.DefaultRevisionEntity;
import org.hibernate.envers.DefaultTrackingModifiedEntitiesRevisionEntity;
import org.hibernate.envers.ModifiedEntityNames;
import org.hibernate.envers.RevisionEntity;
import org.hibernate.envers.RevisionListener;
import org.hibernate.envers.RevisionNumber;
import org.hibernate.envers.RevisionTimestamp;
import org.hibernate.envers.boot.EnversMappingException;
import org.hibernate.envers.boot.model.Attribute;
import org.hibernate.envers.boot.model.BasicAttribute;
import org.hibernate.envers.boot.model.ManyToOneAttribute;
import org.hibernate.envers.boot.model.RootPersistentEntity;
import org.hibernate.envers.boot.model.SetAttribute;
import org.hibernate.envers.boot.model.SimpleIdentifier;
import org.hibernate.envers.configuration.Configuration;
import org.hibernate.envers.configuration.internal.metadata.AuditTableData;
import org.hibernate.envers.enhanced.OrderedSequenceGenerator;
import org.hibernate.envers.enhanced.SequenceIdRevisionEntity;
import org.hibernate.envers.enhanced.SequenceIdTrackingModifiedEntitiesRevisionEntity;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.entities.RevisionTimestampData;
import org.hibernate.envers.internal.revisioninfo.DefaultRevisionInfoGenerator;
import org.hibernate.envers.internal.revisioninfo.DefaultTrackingModifiedEntitiesRevisionInfoGenerator;
import org.hibernate.envers.internal.revisioninfo.ModifiedEntityNamesReader;
import org.hibernate.envers.internal.revisioninfo.RevisionInfoGenerator;
import org.hibernate.envers.internal.revisioninfo.RevisionInfoNumberReader;
import org.hibernate.envers.internal.revisioninfo.RevisionInfoQueryCreator;
import org.hibernate.envers.internal.revisioninfo.RevisionTimestampValueResolver;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.service.ServiceRegistry;

public class RevisionInfoConfiguration {
    private static final String DEFAULT_REVISION_ENTITY_TABLE_NAME = "REVINFO";
    private static final String DEFAULT_REVISION_SEQUENCE_NAME = "REVISION_GENERATOR";
    private static final String DEFAULT_REVISION_SEQUENCE_TABLE_NAME = "REVISION_GENERATOR";
    private static final String DEFAULT_REVISION_FIELD_NAME = "REV";
    private static final String DEFAULT_REVISION_TIMESTAMP_FIELD_NAME = "REVTSTMP";
    private static final String DEFAULT_REVCHANGES_TABLE_NAME = "REVCHANGES";
    private static final String DEFAULT_REVCHANGES_ENTITY_COLUMN_NAME = "ENTITYNAME";
    private final Configuration configuration;
    private final RevisionInfoGenerator revisionInfoGenerator;
    private final RevisionInfoNumberReader revisionInfoNumberReader;
    private final RevisionInfoQueryCreator revisionInfoQueryCreator;
    private final ModifiedEntityNamesReader modifiedEntityNamesReader;
    private final String revisionInfoEntityName;
    private final PropertyData revisionInfoTimestampData;
    private final String revisionInfoTimestampTypeName;
    private final String revisionPropType;
    private final String revisionPropSqlType;
    private final String revisionInfoIdName;
    private final Class<?> revisionInfoClass;
    private final boolean useDefaultRevisionInfoMapping;

    public RevisionInfoConfiguration(Configuration config, MetadataImplementor metadata, ReflectionManager reflectionManager) {
        this.configuration = config;
        RevisionEntityResolver resolver = new RevisionEntityResolver(metadata, reflectionManager);
        this.revisionInfoClass = resolver.revisionInfoClass;
        this.revisionInfoEntityName = resolver.revisionInfoEntityName;
        this.revisionPropType = resolver.revisionPropType;
        this.revisionPropSqlType = resolver.revisionPropSqlType;
        this.revisionInfoTimestampData = resolver.revisionInfoTimestampData;
        this.revisionInfoTimestampTypeName = resolver.revisionInfoTimestampTypeName;
        this.revisionInfoIdName = resolver.revisionInfoIdData.getName();
        this.useDefaultRevisionInfoMapping = resolver.useDefaultRevisionInfoMapping;
        this.revisionInfoGenerator = resolver.revisionInfoGenerator;
        this.revisionInfoNumberReader = new RevisionInfoNumberReader(resolver.revisionInfoClass, resolver.revisionInfoIdData, (ServiceRegistry)metadata.getMetadataBuildingOptions().getServiceRegistry(), this.revisionInfoGenerator);
        this.revisionInfoQueryCreator = new RevisionInfoQueryCreator(resolver.revisionInfoEntityName, resolver.revisionInfoIdData.getName(), resolver.timestampValueResolver);
        this.modifiedEntityNamesReader = this.configuration.isTrackEntitiesChanged() ? new ModifiedEntityNamesReader(resolver.revisionInfoClass, resolver.modifiedEntityNamesData, (ServiceRegistry)metadata.getMetadataBuildingOptions().getServiceRegistry()) : null;
    }

    public String getRevisionInfoEntityName() {
        return this.revisionInfoEntityName;
    }

    public String getRevisionInfoPropertyType() {
        return this.revisionPropType;
    }

    public Class<?> getRevisionInfoClass() {
        return this.revisionInfoClass;
    }

    public PropertyData getRevisionInfoTimestampData() {
        return this.revisionInfoTimestampData;
    }

    public RevisionInfoGenerator getRevisionInfoGenerator() {
        return this.revisionInfoGenerator;
    }

    public RevisionInfoQueryCreator getRevisionInfoQueryCreator() {
        return this.revisionInfoQueryCreator;
    }

    public RevisionInfoNumberReader getRevisionInfoNumberReader() {
        return this.revisionInfoNumberReader;
    }

    public ModifiedEntityNamesReader getModifiedEntityNamesReader() {
        return this.modifiedEntityNamesReader;
    }

    public RootPersistentEntity getRevisionInfoMapping() {
        return this.useDefaultRevisionInfoMapping ? this.generateDefaultRevisionInfoMapping(this.revisionInfoIdName) : null;
    }

    public Attribute getRevisionInfoRelationMapping() {
        ManyToOneAttribute attribute = new ManyToOneAttribute(this.configuration.getRevisionFieldName(), this.revisionPropType, true, false, true, this.revisionInfoEntityName);
        attribute.setOnDelete(this.configuration.isCascadeDeleteRevision() ? "cascade" : null);
        attribute.addColumn(new org.hibernate.envers.boot.model.Column(this.configuration.getRevisionFieldName(), null, null, null, this.revisionPropSqlType, null, null));
        return attribute;
    }

    private RootPersistentEntity generateDefaultRevisionInfoMapping(String revisionInfoIdName) {
        RootPersistentEntity mapping = new RootPersistentEntity(new AuditTableData(null, null, this.configuration.getDefaultSchemaName(), this.configuration.getDefaultCatalogName()), this.revisionInfoClass, this.revisionInfoEntityName, DEFAULT_REVISION_ENTITY_TABLE_NAME);
        SimpleIdentifier identifier = new SimpleIdentifier(revisionInfoIdName, this.revisionPropType);
        if (this.configuration.isNativeIdEnabled()) {
            identifier.setGeneratorClass("native");
        } else {
            identifier.setGeneratorClass(OrderedSequenceGenerator.class.getName());
            identifier.setParameter("sequence_name", "REVISION_GENERATOR");
            identifier.setParameter("table_name", "REVISION_GENERATOR");
            identifier.setParameter("initial_value", "1");
            identifier.setParameter("increment_size", "1");
            if (this.configuration.isRevisionSequenceNoCache()) {
                identifier.setParameter("nocache", "true");
            }
        }
        identifier.addColumn(this.createColumn(DEFAULT_REVISION_FIELD_NAME, null));
        mapping.setIdentifier(identifier);
        BasicAttribute timestampAttribute = new BasicAttribute(this.revisionInfoTimestampData.getName(), this.revisionInfoTimestampTypeName, true, false);
        timestampAttribute.addColumn(this.createColumn(DEFAULT_REVISION_TIMESTAMP_FIELD_NAME, null));
        mapping.addAttribute(timestampAttribute);
        if (this.configuration.isTrackEntitiesChanged()) {
            String schema = this.configuration.getDefaultSchemaName();
            String catalog = this.configuration.getDefaultCatalogName();
            SetAttribute set = new SetAttribute("modifiedEntityNames", DEFAULT_REVCHANGES_TABLE_NAME, schema, catalog);
            set.setCascade("persist, delete");
            set.setFetch("join");
            set.setLazy("false");
            set.setKeyColumn(DEFAULT_REVISION_FIELD_NAME);
            set.setElementType("string");
            set.setColumnName(DEFAULT_REVCHANGES_ENTITY_COLUMN_NAME);
            mapping.addAttribute(set);
        }
        return mapping;
    }

    private org.hibernate.envers.boot.model.Column createColumn(String name, String type) {
        return new org.hibernate.envers.boot.model.Column(name, null, null, null, type, null, null);
    }

    private RevisionTimestampValueResolver createRevisionTimestampResolver(Class<?> revisionInfoClass, PropertyData revisionInfoTimestampData, String typeName, ServiceRegistry serviceRegistry) {
        return new RevisionTimestampValueResolver(revisionInfoClass, new RevisionTimestampData(revisionInfoTimestampData.getName(), revisionInfoTimestampData.getBeanName(), revisionInfoTimestampData.getAccessType(), typeName), serviceRegistry);
    }

    private class RevisionEntityResolver {
        private final MetadataImplementor metadata;
        private final ReflectionManager reflectionManager;
        private boolean revisionEntityFound;
        private boolean revisionNumberFound;
        private boolean revisionTimestampFound;
        private boolean modifiedEntityNamesFound;
        private String revisionInfoEntityName;
        private Class<?> revisionInfoClass;
        private Class<? extends RevisionListener> revisionListenerClass;
        private RevisionInfoGenerator revisionInfoGenerator;
        private boolean useDefaultRevisionInfoMapping;
        private PropertyData revisionInfoIdData;
        private PropertyData revisionInfoTimestampData;
        private PropertyData modifiedEntityNamesData;
        private String revisionInfoTimestampTypeName;
        private String revisionPropType;
        private String revisionPropSqlType;
        private RevisionTimestampValueResolver timestampValueResolver;

        public RevisionEntityResolver(MetadataImplementor metadata, ReflectionManager reflectionManager) {
            this.metadata = metadata;
            this.reflectionManager = reflectionManager;
            this.revisionInfoEntityName = this.getDefaultEntityName();
            this.revisionInfoIdData = this.createPropertyData("id", "field");
            this.revisionInfoTimestampData = this.createPropertyData("timestamp", "field");
            this.modifiedEntityNamesData = this.createPropertyData("modifiedEntityNames", "field");
            this.revisionInfoTimestampTypeName = "long";
            this.revisionPropType = "integer";
            this.locateRevisionEntityMapping();
        }

        private String getDefaultEntityName() {
            if (RevisionInfoConfiguration.this.configuration.isNativeIdEnabled()) {
                return DefaultRevisionEntity.class.getName();
            }
            return SequenceIdRevisionEntity.class.getName();
        }

        private void locateRevisionEntityMapping() {
            for (PersistentClass persistentClass : this.metadata.getEntityBindings()) {
                XClass clazz;
                RevisionEntity revisionEntity;
                if (persistentClass.getClassName() == null || (revisionEntity = (RevisionEntity)(clazz = this.reflectionManager.toXClass(persistentClass.getMappedClass())).getAnnotation(RevisionEntity.class)) == null) continue;
                if (this.revisionEntityFound) {
                    throw new EnversMappingException("Only one entity can be annotated with @RevisionEntity");
                }
                if (clazz.getAnnotation(Audited.class) != null) {
                    throw new EnversMappingException("The @RevisionEntity entity cannot be audited");
                }
                this.revisionEntityFound = true;
                this.resolveConfiguration(clazz);
                if (!this.revisionNumberFound || !this.revisionTimestampFound) {
                    throw new EnversMappingException(String.format(Locale.ENGLISH, "An entity annotated with @RevisionEntity must have a field annotated with %s", !this.revisionNumberFound ? "@RevisionNumber" : "@RevisionTimestamp"));
                }
                this.revisionInfoEntityName = persistentClass.getEntityName();
                this.revisionInfoClass = persistentClass.getMappedClass();
                this.revisionListenerClass = this.getRevisionListenerClass(revisionEntity.value());
                Property timestampProperty = persistentClass.getProperty(this.revisionInfoTimestampData.getName());
                this.revisionInfoTimestampTypeName = timestampProperty.getType().getName();
                this.timestampValueResolver = RevisionInfoConfiguration.this.createRevisionTimestampResolver(this.revisionInfoClass, this.revisionInfoTimestampData, this.revisionInfoTimestampTypeName, (ServiceRegistry)this.metadata.getMetadataBuildingOptions().getServiceRegistry());
                if (this.useEntityTrackingRevisionEntity(this.revisionInfoClass)) {
                    this.revisionInfoGenerator = new DefaultTrackingModifiedEntitiesRevisionInfoGenerator(this.revisionInfoEntityName, this.revisionInfoClass, this.revisionListenerClass, this.timestampValueResolver, this.modifiedEntityNamesData, (ServiceRegistry)this.metadata.getMetadataBuildingOptions().getServiceRegistry());
                    RevisionInfoConfiguration.this.configuration.setTrackEntitiesChanged(true);
                    continue;
                }
                this.revisionInfoGenerator = new DefaultRevisionInfoGenerator(this.revisionInfoEntityName, this.revisionInfoClass, this.revisionListenerClass, this.timestampValueResolver, (ServiceRegistry)this.metadata.getMetadataBuildingOptions().getServiceRegistry());
            }
            if (this.revisionInfoGenerator == null) {
                this.revisionListenerClass = this.getRevisionListenerClass(RevisionListener.class);
                if (RevisionInfoConfiguration.this.configuration.isTrackEntitiesChanged()) {
                    this.revisionInfoClass = RevisionInfoConfiguration.this.configuration.isNativeIdEnabled() ? DefaultTrackingModifiedEntitiesRevisionEntity.class : SequenceIdTrackingModifiedEntitiesRevisionEntity.class;
                    this.revisionInfoEntityName = this.revisionInfoClass.getName();
                } else {
                    this.revisionInfoClass = RevisionInfoConfiguration.this.configuration.isNativeIdEnabled() ? DefaultRevisionEntity.class : SequenceIdRevisionEntity.class;
                }
                this.timestampValueResolver = RevisionInfoConfiguration.this.createRevisionTimestampResolver(this.revisionInfoClass, this.revisionInfoTimestampData, this.revisionInfoTimestampTypeName, (ServiceRegistry)this.metadata.getMetadataBuildingOptions().getServiceRegistry());
                this.revisionInfoGenerator = RevisionInfoConfiguration.this.configuration.isTrackEntitiesChanged() ? new DefaultTrackingModifiedEntitiesRevisionInfoGenerator(this.revisionInfoEntityName, this.revisionInfoClass, this.revisionListenerClass, this.timestampValueResolver, this.modifiedEntityNamesData, (ServiceRegistry)this.metadata.getMetadataBuildingOptions().getServiceRegistry()) : new DefaultRevisionInfoGenerator(this.revisionInfoEntityName, this.revisionInfoClass, this.revisionListenerClass, this.timestampValueResolver, (ServiceRegistry)this.metadata.getMetadataBuildingOptions().getServiceRegistry());
                this.useDefaultRevisionInfoMapping = true;
            }
        }

        private boolean useEntityTrackingRevisionEntity(Class<?> clazz) {
            return RevisionInfoConfiguration.this.configuration.isTrackEntitiesChanged() || RevisionInfoConfiguration.this.configuration.isNativeIdEnabled() && DefaultTrackingModifiedEntitiesRevisionEntity.class.isAssignableFrom(clazz) || !RevisionInfoConfiguration.this.configuration.isNativeIdEnabled() && SequenceIdTrackingModifiedEntitiesRevisionEntity.class.isAssignableFrom(clazz) || this.modifiedEntityNamesFound;
        }

        private void resolveConfiguration(XClass clazz) {
            XClass superclazz = clazz.getSuperclass();
            if (!Object.class.getName().equals(superclazz.getName())) {
                this.resolveConfiguration(superclazz);
            }
            this.resolveConfigurationFromProperties(clazz, "field");
            this.resolveConfigurationFromProperties(clazz, "property");
        }

        private void resolveConfigurationFromProperties(XClass clazz, String accessType) {
            for (XProperty property : clazz.getDeclaredProperties(accessType)) {
                ModifiedEntityNames modifiedEntityNames;
                RevisionTimestamp revisionTimestamp;
                RevisionNumber revisionNumber = (RevisionNumber)property.getAnnotation(RevisionNumber.class);
                if (revisionNumber != null) {
                    this.resolveRevisionNumberFromProperty(property, accessType);
                }
                if ((revisionTimestamp = (RevisionTimestamp)property.getAnnotation(RevisionTimestamp.class)) != null) {
                    this.resolveRevisionTimestampFromProperty(property, accessType);
                }
                if ((modifiedEntityNames = (ModifiedEntityNames)property.getAnnotation(ModifiedEntityNames.class)) == null) continue;
                this.resolveModifiedEntityNamesFromProperty(property, accessType);
            }
        }

        private void resolveRevisionNumberFromProperty(XProperty property, String accessType) {
            if (this.revisionNumberFound) {
                throw new EnversMappingException("Only one property can be defined with @RevisionNumber");
            }
            XClass propertyType = property.getType();
            if (this.isAnyType(propertyType, Integer.class, Integer.TYPE)) {
                this.revisionInfoIdData = this.createPropertyData(property, accessType);
                this.revisionNumberFound = true;
            } else if (this.isAnyType(propertyType, Long.class, Long.TYPE)) {
                this.revisionInfoIdData = this.createPropertyData(property, accessType);
                this.revisionPropType = "long";
                this.revisionNumberFound = true;
            } else {
                this.throwUnexpectedAnnotatedType(property, RevisionNumber.class, "int, Integer, long, or Long");
            }
            Column column = (Column)property.getAnnotation(Column.class);
            if (column != null) {
                this.revisionPropSqlType = column.columnDefinition();
            }
        }

        private void resolveRevisionTimestampFromProperty(XProperty property, String accessType) {
            if (this.revisionTimestampFound) {
                throw new EnversMappingException("Only one property can be defined with @RevisionTimestamp");
            }
            XClass propertyType = property.getType();
            if (this.isAnyType(propertyType, Long.class, Long.TYPE, java.util.Date.class, LocalDateTime.class, Instant.class, Date.class)) {
                this.revisionInfoTimestampData = this.createPropertyData(property, accessType);
                this.revisionTimestampFound = true;
            } else {
                this.throwUnexpectedAnnotatedType(property, RevisionTimestamp.class, "long, Long, Date, LocalDateTime, Instant, or java.sql.Date");
            }
        }

        private void resolveModifiedEntityNamesFromProperty(XProperty property, String accessType) {
            if (this.modifiedEntityNamesFound) {
                throw new EnversMappingException("Only one property can be defined with @ModifiedEntityNames");
            }
            XClass propertyType = property.getType();
            if (this.isAnyType(propertyType, Set.class)) {
                XClass elementType = property.getElementClass();
                if (this.isAnyType(elementType, String.class)) {
                    this.modifiedEntityNamesData = this.createPropertyData(property, accessType);
                    this.modifiedEntityNamesFound = true;
                    return;
                }
            }
            this.throwUnexpectedAnnotatedType(property, ModifiedEntityNames.class, "Set<String>");
        }

        private PropertyData createPropertyData(XProperty property, String accessType) {
            return this.createPropertyData(property.getName(), accessType);
        }

        private PropertyData createPropertyData(String name, String accessType) {
            return new PropertyData(name, name, accessType);
        }

        private boolean isAnyType(XClass clazz, Class<?> ... types) {
            for (Class<?> type : types) {
                if (!this.isType(clazz, type)) continue;
                return true;
            }
            return false;
        }

        private boolean isType(XClass clazz, Class<?> type) {
            return this.reflectionManager.equals(clazz, type);
        }

        private Class<? extends RevisionListener> getRevisionListenerClass(Class<? extends RevisionListener> defaultListener) {
            if (RevisionInfoConfiguration.this.configuration.getRevisionListenerClass() != null) {
                return RevisionInfoConfiguration.this.configuration.getRevisionListenerClass();
            }
            return defaultListener;
        }

        private void throwUnexpectedAnnotatedType(XProperty property, Class<?> annotation, String allowedTypes) {
            throw new EnversMappingException(String.format(Locale.ENGLISH, "The field '%s' annotated with '@%s' must be of type: %s", property.getName(), annotation.getName(), allowedTypes));
        }
    }
}

