/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron.TrivialService;

class EmptyResourceDefinition
extends SimpleResourceDefinition {
    private EmptyResourceDefinition(String pathKey, RuntimeCapability<?> runtimeCapability, OperationStepHandler add, OperationStepHandler remove) {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)pathKey), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver(pathKey)).setAddHandler(add).setRemoveHandler(remove).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{runtimeCapability}));
    }

    static <T> ResourceDefinition create(Class<T> valueType, String pathKey, RuntimeCapability<?> runtimeCapability, TrivialService.ValueSupplier<T> valueSupplier) {
        ResourceAddHandler<T> add = new ResourceAddHandler<T>(valueType, runtimeCapability, valueSupplier);
        TrivialCapabilityServiceRemoveHandler remove = new TrivialCapabilityServiceRemoveHandler(add, runtimeCapability);
        return new EmptyResourceDefinition(pathKey, runtimeCapability, add, remove);
    }

    private static class ResourceAddHandler<T>
    extends BaseAddHandler {
        private final Class<T> valueType;
        private final RuntimeCapability<?> runtimeCapability;
        private final TrivialService.ValueSupplier<T> valueSupplier;

        private ResourceAddHandler(Class<T> valueType, RuntimeCapability<?> runtimeCapability, TrivialService.ValueSupplier<T> valueSupplier) {
            super(runtimeCapability, new AttributeDefinition[0]);
            this.valueType = valueType;
            this.runtimeCapability = runtimeCapability;
            this.valueSupplier = valueSupplier;
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ServiceTarget serviceTarget = context.getServiceTarget();
            RuntimeCapability runtimeCapability = this.runtimeCapability.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName componentName = runtimeCapability.getCapabilityServiceName(this.valueType);
            TrivialService<T> componentService = new TrivialService<T>(this.valueSupplier);
            ServiceBuilder componentBuilder = serviceTarget.addService(componentName, componentService);
            ElytronDefinition.commonDependencies(componentBuilder).setInitialMode(ServiceController.Mode.LAZY).install();
        }
    }
}

