/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.file;

import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.artemis.jdbc.store.drivers.AbstractJDBCDriver;
import org.apache.activemq.artemis.jdbc.store.drivers.JDBCConnectionProvider;
import org.apache.activemq.artemis.jdbc.store.file.JDBCSequentialFile;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCSequentialFileFactoryDriver
extends AbstractJDBCDriver {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected String deleteFile;
    protected String createFile;
    protected String[] createFileColumnNames;
    protected int createFileAutogeneratedKeys;
    protected String selectFileByFileName;
    protected String copyFileRecord;
    protected String renameFile;
    protected String readLargeObject;
    protected String appendToLargeObject;
    protected Integer appendToLargeObjectResultSetType;
    protected Integer appendToLargeObjectResultSetConcurrency;
    protected String selectFileNamesByExtension;

    JDBCSequentialFileFactoryDriver() {
    }

    JDBCSequentialFileFactoryDriver(JDBCConnectionProvider connectionProvider, SQLProvider provider) {
        super(connectionProvider, provider);
    }

    @Override
    protected void createSchema() throws SQLException {
        this.createTable(this.sqlProvider.getCreateFileTableSQL());
    }

    @Override
    protected void prepareStatements() {
        this.deleteFile = this.sqlProvider.getDeleteFileSQL();
        this.createFile = this.sqlProvider.getInsertFileSQL();
        this.createFileColumnNames = new String[]{"ID"};
        this.selectFileByFileName = this.sqlProvider.getSelectFileByFileName();
        this.copyFileRecord = this.sqlProvider.getCopyFileRecordByIdSQL();
        this.renameFile = this.sqlProvider.getUpdateFileNameByIdSQL();
        this.readLargeObject = this.sqlProvider.getReadLargeObjectSQL();
        this.appendToLargeObject = this.sqlProvider.getAppendToLargeObjectSQL();
        this.appendToLargeObjectResultSetType = 1003;
        this.appendToLargeObjectResultSetConcurrency = 1008;
        this.selectFileNamesByExtension = this.sqlProvider.getSelectFileNamesByExtensionSQL();
    }

    public List<String> listFiles(String extension) throws Exception {
        ArrayList<String> fileNames = new ArrayList<String>();
        try (Connection connection = this.connectionProvider.getConnection();){
            connection.setAutoCommit(false);
            try (PreparedStatement selectFileNamesByExtension = connection.prepareStatement(this.selectFileNamesByExtension);){
                selectFileNamesByExtension.setString(1, extension);
                try (ResultSet rs = selectFileNamesByExtension.executeQuery();){
                    while (rs.next()) {
                        fileNames.add(rs.getString(1));
                    }
                }
                connection.commit();
            }
            catch (SQLException e) {
                connection.rollback();
                throw e;
            }
        }
        return fileNames;
    }

    public void openFile(JDBCSequentialFile file) throws SQLException {
        long fileId = this.fileExists(file);
        if (fileId < 0L) {
            this.createFile(file);
        } else {
            file.setId(fileId);
            this.loadFile(file);
        }
    }

    void removeFile(JDBCSequentialFile file) {
    }

    /*
     * Exception decompiling
     */
    public long fileExists(JDBCSequentialFile file) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void loadFile(JDBCSequentialFile file) throws SQLException {
        try (Connection connection = this.connectionProvider.getConnection();){
            try (PreparedStatement readLargeObject = connection.prepareStatement(this.readLargeObject);){
                connection.setAutoCommit(false);
                readLargeObject.setLong(1, file.getId());
                try (ResultSet rs = readLargeObject.executeQuery();){
                    if (rs.next()) {
                        Blob blob = rs.getBlob(1);
                        if (blob != null) {
                            file.setWritePosition(blob.length());
                        } else if (logger.isTraceEnabled()) {
                            logger.trace("No Blob found for file: {} {}", (Object)file.getFileName(), (Object)file.getId());
                        }
                    }
                    connection.commit();
                }
            }
            catch (SQLException e) {
                connection.rollback();
                throw e;
            }
        }
    }

    public void createFile(JDBCSequentialFile file) throws SQLException {
        try (Connection connection = this.connectionProvider.getConnection();){
            try {
                connection.setAutoCommit(false);
                try (PreparedStatement createFile = this.createFileColumnNames != null ? connection.prepareStatement(this.createFile, this.createFileColumnNames) : connection.prepareStatement(this.createFile, this.createFileAutogeneratedKeys);){
                    createFile.setString(1, file.getFileName());
                    createFile.setString(2, file.getExtension());
                    createFile.setBytes(3, new byte[0]);
                    createFile.executeUpdate();
                    try (ResultSet keys = createFile.getGeneratedKeys();){
                        keys.next();
                        file.setId(keys.getLong(1));
                    }
                    connection.commit();
                }
            }
            catch (SQLException e) {
                connection.rollback();
                throw e;
            }
        }
    }

    public void renameFile(JDBCSequentialFile file, String newFileName) throws SQLException {
        try (Connection connection = this.connectionProvider.getConnection();){
            connection.setAutoCommit(false);
            try (PreparedStatement renameFile = connection.prepareStatement(this.renameFile);){
                renameFile.setString(1, newFileName);
                renameFile.setLong(2, file.getId());
                renameFile.executeUpdate();
                connection.commit();
            }
            catch (SQLException e) {
                connection.rollback();
                throw e;
            }
        }
    }

    public void deleteFile(JDBCSequentialFile file) throws SQLException {
        try (Connection connection = this.connectionProvider.getConnection();){
            try (PreparedStatement deleteFile = connection.prepareStatement(this.deleteFile);){
                connection.setAutoCommit(false);
                deleteFile.setLong(1, file.getId());
                deleteFile.executeUpdate();
                connection.commit();
            }
            catch (SQLException e) {
                connection.rollback();
                throw e;
            }
        }
    }

    /*
     * Exception decompiling
     */
    public int writeToFile(JDBCSequentialFile file, byte[] data, boolean append) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public int readFromFile(JDBCSequentialFile file, ByteBuffer bytes) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void copyFileData(JDBCSequentialFile fileFrom, JDBCSequentialFile fileTo) throws SQLException {
        try (Connection connection = this.connectionProvider.getConnection();){
            connection.setAutoCommit(false);
            try (PreparedStatement copyFileRecord = connection.prepareStatement(this.copyFileRecord);){
                copyFileRecord.setLong(1, fileFrom.getId());
                copyFileRecord.setLong(2, fileTo.getId());
                copyFileRecord.executeUpdate();
                connection.commit();
            }
            catch (SQLException e) {
                connection.rollback();
                throw e;
            }
        }
    }

    @Override
    public void destroy() throws SQLException {
        try (Connection connection = this.connectionProvider.getConnection();){
            try {
                connection.setAutoCommit(false);
                try (Statement statement = connection.createStatement();){
                    statement.executeUpdate(this.sqlProvider.getDropFileTableSQL());
                }
                connection.commit();
            }
            catch (SQLException e) {
                connection.rollback();
                throw e;
            }
        }
    }

    public long calculateReadLength(long objectLength, int bufferSpace, long readPosition) {
        long bytesRemaining = objectLength - readPosition;
        if (bytesRemaining > (long)bufferSpace) {
            return bufferSpace;
        }
        return bytesRemaining;
    }

    public long getMaxSize() {
        return this.sqlProvider.getMaxBlobSize();
    }
}

