/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential.source.impl;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.spec.AlgorithmParameterSpec;
import org.wildfly.common.Assert;
import org.wildfly.security.FixedSecurityFactory;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.credential.source.impl.ElytronMessages;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.UnsupportedCredentialTypeException;

public final class CredentialStoreCredentialSource
implements CredentialSource {
    private final SecurityFactory<CredentialStore> credentialStoreFactory;
    private final String alias;

    public CredentialStoreCredentialSource(SecurityFactory<CredentialStore> credentialStoreFactory, String alias) {
        Assert.checkNotNullParam((String)"credentialStoreFactory", credentialStoreFactory);
        Assert.checkNotNullParam((String)"alias", (Object)alias);
        this.credentialStoreFactory = credentialStoreFactory;
        this.alias = alias;
    }

    public CredentialStoreCredentialSource(CredentialStore credentialStore, String alias) {
        this((SecurityFactory<CredentialStore>)new FixedSecurityFactory((Object)((CredentialStore)Assert.checkNotNullParam((String)"credentialStore", (Object)credentialStore))), alias);
    }

    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
        Assert.checkNotNullParam((String)"credentialType", credentialType);
        try {
            CredentialStore credentialStore = (CredentialStore)this.credentialStoreFactory.create();
            return credentialStore.exists(this.alias, credentialType) ? SupportLevel.POSSIBLY_SUPPORTED : SupportLevel.UNSUPPORTED;
        }
        catch (UnsupportedCredentialTypeException e) {
            return SupportLevel.UNSUPPORTED;
        }
        catch (GeneralSecurityException e) {
            throw ElytronMessages.log.unableToReadCredential(e);
        }
    }

    public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
        Assert.checkNotNullParam((String)"credentialType", credentialType);
        try {
            CredentialStore credentialStore = (CredentialStore)this.credentialStoreFactory.create();
            if (ElytronMessages.log.isTraceEnabled()) {
                ElytronMessages.log.tracef("CredentialStoreCredentialSource: obtaining credential: type = %s  algorithm = %s  exists = %b", this.alias, credentialType, credentialStore.exists(this.alias, credentialType));
            }
            return (C)credentialStore.retrieve(this.alias, credentialType, algorithmName, parameterSpec);
        }
        catch (UnsupportedCredentialTypeException e) {
            return null;
        }
        catch (GeneralSecurityException e) {
            throw ElytronMessages.log.unableToReadCredential(e);
        }
    }
}

