/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.client.internal.proxy;

import io.narayana.lra.client.internal.proxy.LRAProxyParticipant;
import io.narayana.lra.proxy.logging.LRAProxyLogger;
import java.net.URI;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.eclipse.microprofile.lra.annotation.ParticipantStatus;

class ParticipantProxy {
    private final URI lraId;
    private final String participantId;
    private LRAProxyParticipant participant;
    private Future<Void> future;
    private boolean compensate;

    ParticipantProxy(URI lraId, String participantId, LRAProxyParticipant participant) {
        this.lraId = lraId;
        this.participantId = participantId;
        this.participant = participant;
    }

    ParticipantProxy(URI lraId, String participantId) {
        this.lraId = lraId;
        this.participantId = participantId;
    }

    private URI getLraId() {
        return this.lraId;
    }

    String getParticipantId() {
        return this.participantId;
    }

    LRAProxyParticipant getParticipant() {
        return this.participant;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParticipantProxy)) {
            return false;
        }
        ParticipantProxy that = (ParticipantProxy)o;
        return this.getLraId().equals(that.getLraId()) && this.getParticipantId().equals(that.getParticipantId());
    }

    public int hashCode() {
        int result = this.getLraId().hashCode();
        result = 31 * result + this.getParticipantId().hashCode();
        return result;
    }

    void setFuture(Future<Void> future, boolean compensate) {
        this.future = future;
        this.compensate = compensate;
    }

    private ParticipantStatus getExpectedStatus() {
        return this.compensate ? ParticipantStatus.Compensated : ParticipantStatus.Completed;
    }

    private ParticipantStatus getCurrentStatus() {
        return this.compensate ? ParticipantStatus.Compensating : ParticipantStatus.Completing;
    }

    private ParticipantStatus getFailedStatus() {
        return this.compensate ? ParticipantStatus.FailedToCompensate : ParticipantStatus.FailedToComplete;
    }

    Optional<ParticipantStatus> getStatus() {
        if (this.future == null) {
            return Optional.empty();
        }
        if (this.future.isDone()) {
            try {
                this.future.get();
                return Optional.of(this.getExpectedStatus());
            }
            catch (ExecutionException e) {
                LRAProxyLogger.i18NLogger.error_participantExceptionOnCompletion(this.participant.getClass().getName(), e);
                return Optional.of(this.getFailedStatus());
            }
            catch (InterruptedException e) {
                return Optional.of(this.getFailedStatus());
            }
        }
        if (this.future.isCancelled()) {
            return Optional.of(this.getExpectedStatus());
        }
        return Optional.of(this.getCurrentStatus());
    }
}

