/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.client.internal.proxy.nonjaxrs;

import io.narayana.lra.AnnotationResolver;
import io.narayana.lra.logging.LRALogger;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.lra.annotation.AfterLRA;
import org.eclipse.microprofile.lra.annotation.Compensate;
import org.eclipse.microprofile.lra.annotation.Complete;
import org.eclipse.microprofile.lra.annotation.Forget;
import org.eclipse.microprofile.lra.annotation.LRAStatus;
import org.eclipse.microprofile.lra.annotation.ParticipantStatus;
import org.eclipse.microprofile.lra.annotation.Status;

public class LRAParticipant {
    private final Class<?> javaClass;
    private Method compensateMethod;
    private Method completeMethod;
    private Method statusMethod;
    private Method forgetMethod;
    private Method afterLRAMethod;
    private Object instance;
    private final Map<URI, ParticipantResult> participantStatusMap = new HashMap<URI, ParticipantResult>();

    public LRAParticipant(Class<?> javaClass) {
        this.javaClass = javaClass;
        Arrays.stream(javaClass.getMethods()).forEach(this::processParticipantMethod);
    }

    Class<?> getJavaClass() {
        return this.javaClass;
    }

    synchronized Response compensate(URI lraId, URI parentId) {
        if (this.participantStatusMap.containsKey(lraId)) {
            this.processCompletionStageResult(this.compensateMethod, lraId, parentId, "compensate").close();
        }
        return this.invokeParticipantMethod(this.compensateMethod, lraId, parentId, "compensate");
    }

    synchronized Response complete(URI lraId, URI parentId) {
        if (this.participantStatusMap.containsKey(lraId)) {
            this.processCompletionStageResult(this.completeMethod, lraId, parentId, "complete").close();
        }
        return this.invokeParticipantMethod(this.completeMethod, lraId, parentId, "complete");
    }

    synchronized Response status(URI lraId, URI parentId) {
        if (this.participantStatusMap.containsKey(lraId)) {
            return this.processCompletionStageResult(this.statusMethod, lraId, parentId, "status");
        }
        return this.invokeParticipantMethod(this.statusMethod, lraId, parentId, "status");
    }

    synchronized Response forget(URI lraId, URI parentId) {
        return this.invokeParticipantMethod(this.forgetMethod, lraId, parentId, "forget");
    }

    synchronized Response afterLRA(URI lraId, LRAStatus lraStatus) {
        Object result = this.invokeMethod("after", this.afterLRAMethod, this.getInstance(), lraId, lraStatus);
        return result instanceof Response ? (Response)result : Response.ok().build();
    }

    private void processParticipantMethod(Method method) {
        if (this.isJaxRsMethod(method)) {
            return;
        }
        if (this.setAfterLRAAnnotation(method) || !this.setParticipantAnnotation(method)) {
            return;
        }
        this.verifyReturnType(method);
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length > 2) {
            throw new IllegalStateException(String.format("%s: %s", method.toGenericString(), "Participant method cannot have more than 2 arguments"));
        }
        if (parameterTypes.length > 0 && !parameterTypes[0].equals(URI.class)) {
            throw new IllegalStateException(String.format("%s: %s", method.toGenericString(), "Invalid argument type in LRA participant method: " + parameterTypes[0]));
        }
        if (parameterTypes.length > 1 && !parameterTypes[1].equals(URI.class)) {
            throw new IllegalStateException(String.format("%s: %s", method.toGenericString(), "Invalid argument type in LRA participant method: " + parameterTypes[1]));
        }
    }

    private boolean setAfterLRAAnnotation(Method method) {
        if (!AnnotationResolver.isAnnotationPresent(AfterLRA.class, (Method)method)) {
            return false;
        }
        if (!method.getReturnType().equals(Void.TYPE)) {
            throw new IllegalStateException(String.format("%s: %s", method.toGenericString(), "Invalid return type for @AfterLRA method: " + method.getReturnType()));
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length > 2) {
            throw new IllegalStateException(String.format("%s: %s", method.toGenericString(), "@AfterLRA method cannot have more than 2 arguments"));
        }
        if (parameterTypes.length > 0 && !parameterTypes[0].equals(URI.class)) {
            throw new IllegalStateException(String.format("%s: %s", method.toGenericString(), "Invalid first argument of @AfterLRA method: " + parameterTypes[0]));
        }
        if (parameterTypes.length > 1 && !parameterTypes[1].equals(LRAStatus.class)) {
            throw new IllegalStateException(String.format("%s: %s", method.toGenericString(), "Invalid second argument of @AfterLRA method: " + parameterTypes[1]));
        }
        this.afterLRAMethod = method;
        return true;
    }

    private boolean isJaxRsMethod(Method method) {
        return AnnotationResolver.isAnnotationPresent(GET.class, (Method)method) || AnnotationResolver.isAnnotationPresent(POST.class, (Method)method) || AnnotationResolver.isAnnotationPresent(PUT.class, (Method)method) || AnnotationResolver.isAnnotationPresent(DELETE.class, (Method)method) || AnnotationResolver.isAnnotationPresent(HEAD.class, (Method)method) || AnnotationResolver.isAnnotationPresent(OPTIONS.class, (Method)method);
    }

    private boolean setParticipantAnnotation(Method method) {
        if (AnnotationResolver.isAnnotationPresent(Compensate.class, (Method)method)) {
            this.compensateMethod = method;
            return true;
        }
        if (AnnotationResolver.isAnnotationPresent(Complete.class, (Method)method)) {
            this.completeMethod = method;
            return true;
        }
        if (AnnotationResolver.isAnnotationPresent(Status.class, (Method)method)) {
            this.statusMethod = method;
            return true;
        }
        if (AnnotationResolver.isAnnotationPresent(Forget.class, (Method)method)) {
            this.forgetMethod = method;
            return true;
        }
        return false;
    }

    private void verifyReturnType(Method method) {
        Class<?> returnType = method.getReturnType();
        if (returnType.equals(CompletionStage.class)) {
            this.verifyReturnType(LRAParticipant.getCompletionStageActualType(method), method.toGenericString(), true);
            return;
        }
        this.verifyReturnType(returnType, method.toGenericString(), false);
    }

    private void verifyReturnType(Class<?> returnType, String methodGenericString, boolean inCompletionStage) {
        if (!(returnType.equals(Void.TYPE) || returnType.equals(Void.class) || returnType.equals(ParticipantStatus.class) || returnType.equals(Response.class))) {
            throw new IllegalStateException(String.format("%s: %s", methodGenericString, "Invalid return type for participant method " + (Serializable)(inCompletionStage ? "CompletionStage<" + returnType + ">" : returnType)));
        }
    }

    private Response processCompletionStageResult(Method method, URI lraId, URI parentId, String type) {
        ParticipantResult participantResult = this.participantStatusMap.get(lraId);
        if (participantResult.isReady()) {
            this.participantStatusMap.remove(lraId);
            Object result = participantResult.getValue();
            if (this.shouldInvokeParticipantMethod(result)) {
                LRALogger.i18nLogger.warn_participantReturnsImmediateStateFromCompletionStage(this.getJavaClass().getName(), lraId.toASCIIString());
                return this.invokeParticipantMethod(method, lraId, parentId, type);
            }
            return this.processResult(result, participantResult.getType(), type);
        }
        return Response.accepted().build();
    }

    private boolean shouldInvokeParticipantMethod(Object result) {
        if (result instanceof ParticipantStatus) {
            ParticipantStatus participantStatus = (ParticipantStatus)result;
            return participantStatus.equals((Object)ParticipantStatus.Compensating) || participantStatus.equals((Object)ParticipantStatus.Completing);
        }
        return result instanceof Response && ((Response)result).getStatus() == Response.Status.ACCEPTED.getStatusCode();
    }

    private Response invokeParticipantMethod(Method method, URI lraId, URI parentId, String type) {
        Object result;
        Object participant = this.getInstance();
        switch (method.getParameterCount()) {
            case 0: {
                result = this.invokeMethod(type, method, participant, new Object[0]);
                break;
            }
            case 1: {
                result = this.invokeMethod(type, method, participant, lraId);
                break;
            }
            case 2: {
                result = this.invokeMethod(type, method, participant, lraId, parentId);
                break;
            }
            default: {
                throw new IllegalStateException(method.toGenericString() + ": invalid number of arguments: " + method.getParameterCount());
            }
        }
        return this.processResult(result, lraId, method, type);
    }

    private Object getInstance() {
        return this.instance != null ? this.instance : CDI.current().select(this.javaClass, new Annotation[0]).get();
    }

    private Object invokeMethod(String type, Method method, Object o, Object ... args) {
        try {
            return method.invoke(o, args);
        }
        catch (InvocationTargetException e) {
            return this.processThrowable(e.getTargetException(), type);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private Response processResult(Object result, URI lraId, Method method, String type) {
        if (result instanceof CompletionStage) {
            this.participantStatusMap.put(lraId, new ParticipantResult(LRAParticipant.getCompletionStageActualType(method)));
            ((CompletionStage)result).thenAccept(res -> this.participantStatusMap.get(lraId).setValue(res)).exceptionally(throwable -> {
                this.participantStatusMap.get(lraId).setValue(throwable);
                return null;
            });
            return Response.status((Response.Status)Response.Status.ACCEPTED).build();
        }
        return this.processResult(result, method.getReturnType(), type);
    }

    private Response processResult(Object result, Class<?> resultType, String type) {
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        if (resultType.equals(Void.TYPE) || resultType.equals(Void.class)) {
            builder.entity((Object)(type.equals("complete") ? ParticipantStatus.Completed.name() : ParticipantStatus.Compensated.name()));
        } else if (result == null) {
            builder.status(Response.Status.NOT_FOUND);
        } else if (result instanceof ParticipantStatus) {
            ParticipantStatus status = (ParticipantStatus)result;
            if (status == ParticipantStatus.Compensating || status == ParticipantStatus.Completing) {
                return builder.status(Response.Status.ACCEPTED).build();
            }
            builder.entity((Object)status.name());
        } else {
            if (result instanceof Response) {
                return (Response)result;
            }
            builder.entity(this.processThrowable((Throwable)result, type));
        }
        return builder.build();
    }

    private Object processThrowable(Throwable throwable, String type) {
        if (throwable instanceof WebApplicationException) {
            return ((WebApplicationException)throwable).getResponse();
        }
        if (type.equals("compensate")) {
            LRALogger.logger.debug((Object)"Compensate participant method threw an unexpected exception", throwable);
            return ParticipantStatus.FailedToCompensate.name();
        }
        if (type.equals("complete")) {
            LRALogger.logger.debug((Object)"Complete participant method threw an unexpected exception", throwable);
            return ParticipantStatus.FailedToComplete.name();
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
    }

    public void setInstance(Object instance) {
        this.instance = instance;
    }

    public void augmentTerminationURIs(Map<String, String> terminateURIs, URI baseUri) {
        String baseURI = UriBuilder.fromUri((URI)baseUri).path("lra-participant-proxy").path(this.javaClass.getName()).build(new Object[0]).toASCIIString();
        if (!terminateURIs.containsKey("complete") && this.completeMethod != null) {
            terminateURIs.put("complete", this.getURI(baseURI, "complete"));
        }
        if (!terminateURIs.containsKey("compensate") && this.compensateMethod != null) {
            terminateURIs.put("compensate", this.getURI(baseURI, "compensate"));
        }
        if (!terminateURIs.containsKey("status") && this.statusMethod != null) {
            terminateURIs.put("status", this.getURI(baseURI, "status"));
        }
        if (!terminateURIs.containsKey("forget") && this.forgetMethod != null) {
            terminateURIs.put("forget", this.getURI(baseURI, "forget"));
        }
        if (!terminateURIs.containsKey("after") && this.afterLRAMethod != null) {
            terminateURIs.put("after", this.getURI(baseURI, "after"));
        }
    }

    private String getURI(String baseURI, String path) {
        return String.format("%s/%s", baseURI, path);
    }

    boolean hasNonJaxRsMethods() {
        return this.compensateMethod != null || this.completeMethod != null || this.statusMethod != null || this.forgetMethod != null || this.afterLRAMethod != null;
    }

    private static Class<?> getCompletionStageActualType(Method method) {
        Type genericReturnType = method.getGenericReturnType();
        ParameterizedType parameterizedType = (ParameterizedType)genericReturnType;
        return (Class)parameterizedType.getActualTypeArguments()[0];
    }

    private static final class ParticipantResult {
        private boolean ready;
        private final Class<?> type;
        private Object value;

        ParticipantResult(Class<?> type) {
            this.type = type;
        }

        boolean isReady() {
            return this.ready;
        }

        void setValue(Object value) {
            this.value = value;
            this.ready = true;
        }

        Class<?> getType() {
            return this.type;
        }

        Object getValue() {
            return this.value;
        }
    }
}

