/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.Services;
import org.jboss.as.server.deployment.SimpleAttachable;
import org.jboss.as.version.Stability;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

class DeploymentUnitImpl
extends SimpleAttachable
implements DeploymentUnit {
    private final DeploymentUnit parent;
    private final String name;
    private final ServiceRegistry serviceRegistry;
    private final Stability stability;

    DeploymentUnitImpl(DeploymentUnit parent, String name, ServiceRegistry serviceRegistry, Stability stability) {
        this.parent = parent;
        this.name = name;
        this.serviceRegistry = serviceRegistry;
        this.stability = stability;
    }

    @Override
    public ServiceName getServiceName() {
        if (this.parent != null) {
            return Services.deploymentUnitName(this.parent.getName(), this.name);
        }
        return Services.deploymentUnitName(this.name);
    }

    @Override
    public DeploymentUnit getParent() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public Stability getStability() {
        return this.stability;
    }

    public String toString() {
        if (this.parent != null) {
            return String.format("subdeployment \"%s\" of %s", this.name, this.parent);
        }
        return String.format("deployment \"%s\"", this.name);
    }
}

