/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.annotation.ws.rs;

import jakarta.ws.rs.core.Response;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.time.temporal.ChronoUnit;

@Inherited
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD})
public @interface LRA {
    public static final String LRA_HTTP_CONTEXT_HEADER = "Long-Running-Action";
    public static final String LRA_HTTP_ENDED_CONTEXT_HEADER = "Long-Running-Action-Ended";
    public static final String LRA_HTTP_PARENT_CONTEXT_HEADER = "Long-Running-Action-Parent";
    public static final String LRA_HTTP_RECOVERY_HEADER = "Long-Running-Action-Recovery";

    public Type value() default Type.REQUIRED;

    public long timeLimit() default 0L;

    public ChronoUnit timeUnit() default ChronoUnit.SECONDS;

    public boolean end() default true;

    public Response.Status.Family[] cancelOnFamily() default {Response.Status.Family.CLIENT_ERROR, Response.Status.Family.SERVER_ERROR};

    public Response.Status[] cancelOn() default {};

    public static enum Type {
        REQUIRED,
        REQUIRES_NEW,
        MANDATORY,
        SUPPORTS,
        NOT_SUPPORTED,
        NEVER,
        NESTED;

    }
}

